/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import org.eclipse.gef4.mvc.operations.AbstractCompositeOperation;
import org.eclipse.gef4.mvc.operations.AddContentChildOperation;
import org.eclipse.gef4.mvc.operations.AttachToContentAnchorageOperation;
import org.eclipse.gef4.mvc.operations.DetachFromContentAnchorageOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.RemoveContentChildOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public class ContentPolicy<VR>
extends AbstractTransactionPolicy<VR> {
    public void addContentChild(Object contentChild, int index) {
        this.checkInitialized();
        this.getCompositeOperation().add(new AddContentChildOperation(this.getHost(), contentChild, index));
        this.locallyExecuteOperation();
    }

    public void attachToContentAnchorage(Object contentAnchorage, String role) {
        this.checkInitialized();
        this.getCompositeOperation().add(new AttachToContentAnchorageOperation(this.getHost(), contentAnchorage, role));
        this.locallyExecuteOperation();
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new ReverseUndoCompositeOperation("Content Change");
    }

    public void detachFromContentAnchorage(Object contentAnchorage, String role) {
        this.checkInitialized();
        this.getCompositeOperation().add(new DetachFromContentAnchorageOperation(this.getHost(), contentAnchorage, role));
        this.locallyExecuteOperation();
    }

    protected AbstractCompositeOperation getCompositeOperation() {
        return (AbstractCompositeOperation)this.getOperation();
    }

    @Override
    public IContentPart<VR, ? extends VR> getHost() {
        return (IContentPart)super.getHost();
    }

    public void removeContentChild(Object contentChild) {
        this.checkInitialized();
        this.getCompositeOperation().add(new RemoveContentChildOperation(this.getHost(), contentChild));
        this.locallyExecuteOperation();
    }

    @Override
    public void setAdaptable(IVisualPart<VR, ? extends VR> adaptable) {
        if (!(adaptable instanceof IContentPart)) {
            throw new IllegalStateException("A ContentPolicy may only be attached to an IContentPart.");
        }
        super.setAdaptable(adaptable);
    }
}

