/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.anchors;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.binding.Binding;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import org.eclipse.gef4.geometry.planar.Point;

public interface IComputationStrategy {
    public Point computePositionInScene(Node var1, Node var2, Set<Parameter<?>> var3);

    public Set<Class<? extends Parameter<?>>> getRequiredParameters();

    public static abstract class Parameter<T>
    extends ObjectPropertyBase<T> {
        private Kind kind;
        private boolean optional;
        private ObservableValue<? extends T> bindingTarget;

        protected static <T extends Parameter<?>> T get(Collection<? extends Parameter<?>> parameters, Class<T> parameterType) {
            HashSet parametersOfType = new HashSet();
            for (Parameter<?> p : parameters) {
                if (!parameterType.equals(((Object)p).getClass())) continue;
                parametersOfType.add(p);
            }
            if (parametersOfType.isEmpty()) {
                return null;
            }
            if (parametersOfType.size() > 1) {
                throw new IllegalArgumentException("The given set of parameters contains " + parameters.size() + " parameters of type " + parameterType.getSimpleName() + ": " + parameters);
            }
            return (T)((Object)((Parameter)((Object)parametersOfType.iterator().next())));
        }

        public static Kind getKind(Class<? extends Parameter<?>> paramType) {
            try {
                return paramType.newInstance().getKind();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instantiate parameter of type " + paramType.getSimpleName() + ".", e);
            }
        }

        public static boolean isOptional(Class<? extends Parameter<?>> paramType) {
            try {
                return paramType.newInstance().isOptional();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot instantiate parameter of type " + paramType.getSimpleName() + ".", e);
            }
        }

        public Parameter(Kind kind) {
            this(kind, false);
        }

        public Parameter(Kind kind, boolean optional) {
            this.kind = kind;
            this.optional = optional;
        }

        public void bind(ObservableValue<? extends T> newObservable) {
            super.bind(newObservable);
            this.bindingTarget = newObservable;
        }

        public Object getBean() {
            return null;
        }

        public final Kind getKind() {
            return this.kind;
        }

        public String getName() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void invalidateBinding() {
            if (this.isBound() && this.bindingTarget instanceof Binding) {
                ((Binding)this.bindingTarget).invalidate();
            }
        }

        public final boolean isOptional() {
            return this.optional;
        }

        public void unbind() {
            this.bindingTarget = null;
            super.unbind();
        }

        public static enum Kind {
            ANCHORAGE,
            ANCHORED;

        }
    }
}

