/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef4.mvc.domain.IDomain;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.IFXOnTypePolicy;
import org.eclipse.gef4.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef4.mvc.models.FocusModel;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXTypeTool
extends AbstractTool<Node> {
    public static final Class<IFXOnTypePolicy> ON_TYPE_POLICY_KEY = IFXOnTypePolicy.class;
    private Map<Scene, EventHandler<? super KeyEvent>> pressedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<Scene, EventHandler<? super KeyEvent>> releasedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<Scene, EventHandler<? super KeyEvent>> typedFilterMap = new IdentityHashMap<Scene, EventHandler<? super KeyEvent>>();
    private Map<IViewer<Node>, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer<Node>, ChangeListener<Boolean>>();
    private IViewer<Node> activeViewer;
    @Inject
    private ITargetPolicyResolver targetPolicyResolver;

    public List<? extends IFXOnTypePolicy> getActivePolicies(IViewer<Node> viewer) {
        return super.getActivePolicies(viewer);
    }

    protected void registerListeners() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            FocusModel focusModel = (FocusModel)viewer.getAdapter((TypeToken)new TypeToken<FocusModel<Node>>(){});
            if (focusModel == null) {
                throw new IllegalStateException("Cannot find FocusModel<Node>.");
            }
            final HashSet pressedKeys = new HashSet();
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (FXTypeTool.this.activeViewer == null) {
                        return;
                    }
                    for (IViewer iViewer : FXTypeTool.this.getDomain().getViewers().values()) {
                        if (!iViewer.isViewerFocused()) continue;
                        return;
                    }
                    for (IFXOnTypePolicy iFXOnTypePolicy : FXTypeTool.this.getActivePolicies((IViewer<Node>)FXTypeTool.this.activeViewer)) {
                        iFXOnTypePolicy.unfocus();
                    }
                    FXTypeTool.this.clearActivePolicies(FXTypeTool.this.activeViewer);
                    FXTypeTool.this.activeViewer = null;
                    FXTypeTool.this.getDomain().closeExecutionTransaction((ITool)FXTypeTool.this);
                    pressedKeys.clear();
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put((IViewer<Node>)viewer, viewerFocusChangeListener);
            Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
            if (this.pressedFilterMap.containsKey(scene)) continue;
            EventHandler<KeyEvent> pressedFilter = new EventHandler<KeyEvent>(){

                /*
                 * WARNING - void declaration
                 */
                public void handle(KeyEvent event) {
                    if (pressedKeys.isEmpty()) {
                        void var2_5;
                        Object var2_2 = null;
                        EventTarget target = event.getTarget();
                        if (target instanceof Node) {
                            Node node = (Node)target;
                            FXTypeTool.this.activeViewer = FXPartUtils.retrieveViewer((IDomain<Node>)FXTypeTool.this.getDomain(), node);
                        } else if (target instanceof Scene) {
                            for (IViewer v : FXTypeTool.this.getDomain().getViewers().values()) {
                                if (((Node)v.getRootPart().getVisual()).getScene() != target || !v.isViewerFocused()) continue;
                                FXTypeTool.this.activeViewer = v;
                                break;
                            }
                            if (FXTypeTool.this.activeViewer == null) {
                                return;
                            }
                            Node node = (Node)FXTypeTool.this.activeViewer.getRootPart().getVisual();
                        } else {
                            throw new IllegalStateException("Unsupported event target: " + target);
                        }
                        FXTypeTool.this.getDomain().openExecutionTransaction((ITool)FXTypeTool.this);
                        FXTypeTool.this.setActivePolicies(FXTypeTool.this.activeViewer, FXTypeTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXTypeTool.this, (Node)var2_5, ON_TYPE_POLICY_KEY));
                    }
                    pressedKeys.add(event.getCode());
                    for (IFXOnTypePolicy iFXOnTypePolicy : FXTypeTool.this.getActivePolicies((IViewer<Node>)FXTypeTool.this.activeViewer)) {
                        iFXOnTypePolicy.pressed(event);
                    }
                }
            };
            this.pressedFilterMap.put(scene, (EventHandler<? super KeyEvent>)pressedFilter);
            EventHandler<KeyEvent> releasedFilter = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    for (IFXOnTypePolicy iFXOnTypePolicy : FXTypeTool.this.getActivePolicies((IViewer<Node>)FXTypeTool.this.activeViewer)) {
                        iFXOnTypePolicy.released(event);
                    }
                    if (pressedKeys.size() == 1 && pressedKeys.contains(event.getCode())) {
                        FXTypeTool.this.clearActivePolicies(FXTypeTool.this.activeViewer);
                        FXTypeTool.this.activeViewer = null;
                        FXTypeTool.this.getDomain().closeExecutionTransaction((ITool)FXTypeTool.this);
                    }
                    pressedKeys.remove(event.getCode());
                }
            };
            this.releasedFilterMap.put(scene, (EventHandler<? super KeyEvent>)releasedFilter);
            EventHandler<KeyEvent> typedFilter = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    if (pressedKeys.isEmpty()) {
                        FXTypeTool.this.getDomain().openExecutionTransaction((ITool)FXTypeTool.this);
                    }
                    IViewer viewer = null;
                    Node targetNode = null;
                    EventTarget target = event.getTarget();
                    if (target instanceof Node) {
                        targetNode = (Node)target;
                        viewer = FXPartUtils.retrieveViewer((IDomain<Node>)FXTypeTool.this.getDomain(), targetNode);
                    } else if (target instanceof Scene) {
                        for (IViewer v : FXTypeTool.this.getDomain().getViewers().values()) {
                            if (((Node)v.getRootPart().getVisual()).getScene() != target || !v.isViewerFocused()) continue;
                            viewer = v;
                            break;
                        }
                        targetNode = (Node)viewer.getRootPart().getVisual();
                    } else {
                        throw new IllegalStateException("Unsupported event target: " + target);
                    }
                    List<IFXOnTypePolicy> policies = FXTypeTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXTypeTool.this, targetNode, ON_TYPE_POLICY_KEY);
                    for (IFXOnTypePolicy policy : policies) {
                        policy.typed(event);
                    }
                    if (pressedKeys.isEmpty()) {
                        FXTypeTool.this.getDomain().closeExecutionTransaction((ITool)FXTypeTool.this);
                    }
                }
            };
            this.typedFilterMap.put(scene, (EventHandler<? super KeyEvent>)typedFilter);
            scene.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)pressedFilter);
            scene.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)releasedFilter);
            scene.addEventFilter(KeyEvent.KEY_TYPED, (EventHandler)typedFilter);
        }
    }

    protected void unregisterListeners() {
        for (IViewer viewer : this.getDomain().getViewers().values()) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
            Scene scene = ((Node)viewer.getRootPart().getVisual()).getScene();
            if (this.pressedFilterMap.containsKey(scene)) {
                scene.removeEventFilter(KeyEvent.KEY_PRESSED, this.pressedFilterMap.remove(scene));
            }
            if (this.releasedFilterMap.containsKey(scene)) {
                scene.removeEventFilter(KeyEvent.KEY_RELEASED, this.releasedFilterMap.remove(scene));
            }
            if (!this.typedFilterMap.containsKey(scene)) continue;
            scene.removeEventFilter(KeyEvent.KEY_TYPED, this.typedFilterMap.remove(scene));
        }
    }
}

