/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXFeedbackPart;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultSelectionFeedbackPartFactory;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.CursorSupport;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.SelectOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXMarqueeOnDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private CursorSupport cursorSupport = new CursorSupport(this);
    private boolean invalidGesture = false;
    private Point2D startPosInRoot;
    private Point2D endPosInRoot;
    private IFeedbackPart<Node, ? extends Node> feedback;

    private static double[] bbox(Point2D start, Point2D end) {
        double tmp;
        double[] dArray = new double[]{start.getX(), start.getY(), end.getX(), end.getY()};
        double[] bbox = dArray;
        if (bbox[0] > bbox[2]) {
            tmp = bbox[0];
            bbox[0] = bbox[2];
            bbox[2] = tmp;
        }
        if (bbox[1] > bbox[3]) {
            tmp = bbox[1];
            bbox[1] = bbox[3];
            bbox[3] = tmp;
        }
        return bbox;
    }

    public static List<Node> findContainedNodes(Node root, double x0, double y0, double x1, double y1) {
        ArrayList<Node> containedNodes = new ArrayList<Node>();
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.add(root);
        while (!nodes.isEmpty()) {
            Node current = (Node)nodes.remove();
            Bounds bounds = current.getBoundsInLocal();
            bounds = current.localToScene(bounds);
            double bx1 = bounds.getMaxX();
            double bx0 = bounds.getMinX();
            double by1 = bounds.getMaxY();
            double by0 = bounds.getMinY();
            if (bx1 < x0 || bx0 > x1 || by1 < y0 || by0 > y1) continue;
            if (bx0 >= x0 && bx1 <= x1 && by0 >= y0 && by1 <= y1) {
                containedNodes.add(current);
            }
            if (!(current instanceof Parent)) continue;
            Parent p = (Parent)current;
            nodes.addAll((Collection<Node>)p.getChildrenUnmodifiable());
        }
        return containedNodes;
    }

    protected void addFeedback() {
        if (this.feedback != null) {
            this.removeFeedback();
        }
        this.feedback = new AbstractFXFeedbackPart<Rectangle>(){

            protected Rectangle createVisual() {
                Rectangle visual = new Rectangle();
                visual.setFill((Paint)Color.TRANSPARENT);
                visual.setStroke((Paint)FXMarqueeOnDragPolicy.this.getPrimarySelectionColor());
                visual.setStrokeWidth(1.0);
                visual.setStrokeType(StrokeType.CENTERED);
                visual.getStrokeDashArray().setAll((Object[])new Double[]{5.0, 5.0});
                return visual;
            }

            protected void doRefreshVisual(Rectangle visual) {
                IRootPart root = this.getRoot();
                Point2D start = visual.sceneToLocal(((Node)root.getVisual()).localToScene(FXMarqueeOnDragPolicy.this.startPosInRoot));
                Point2D end = visual.sceneToLocal(((Node)root.getVisual()).localToScene(FXMarqueeOnDragPolicy.this.endPosInRoot));
                double[] bbox = FXMarqueeOnDragPolicy.bbox(start, end);
                visual.setX(bbox[0] - 0.5);
                visual.setY(bbox[1] - 0.5);
                visual.setWidth(bbox[2] - bbox[0]);
                visual.setHeight(bbox[3] - bbox[1]);
            }
        };
        this.getHost().getRoot().addChild(this.feedback);
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        this.endPosInRoot = ((Node)this.getHost().getRoot().getVisual()).sceneToLocal(e.getSceneX(), e.getSceneY());
        this.updateFeedback();
    }

    @Override
    public void dragAborted() {
        if (!this.invalidGesture && this.feedback != null) {
            this.removeFeedback();
        }
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    protected List<IContentPart<Node, ? extends Node>> getParts(List<Node> nodes) {
        ArrayList<IContentPart<Node, ? extends Node>> parts = new ArrayList<IContentPart<Node, ? extends Node>>();
        IViewer viewer = this.getHost().getRoot().getViewer();
        for (Node node : nodes) {
            IVisualPart<Node, ? extends Node> part = FXPartUtils.retrieveVisualPart((IViewer<Node>)viewer, node);
            if (part == null || !(part instanceof IContentPart) || parts.contains(part)) continue;
            parts.add((IContentPart<Node, ? extends Node>)((IContentPart)part));
        }
        return parts;
    }

    protected Color getPrimarySelectionColor() {
        Provider connectedColorProvider = (Provider)this.getHost().getRoot().getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"PRIMARY_SELECTION_FEEDBACK_COLOR_PROVIDER"));
        return connectedColorProvider == null ? FXDefaultSelectionFeedbackPartFactory.DEFAULT_PRIMARY_SELECTION_FEEDBACK_COLOR : (Color)connectedColorProvider.get();
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    protected boolean isMarquee(MouseEvent event) {
        return !this.isRegistered(event.getTarget());
    }

    @Override
    public void press(MouseEvent e) {
        boolean bl = this.invalidGesture = !this.isMarquee(e);
        if (this.invalidGesture) {
            return;
        }
        this.startPosInRoot = ((Node)this.getHost().getRoot().getVisual()).sceneToLocal(e.getSceneX(), e.getSceneY());
        this.endPosInRoot = new Point2D(this.startPosInRoot.getX(), this.startPosInRoot.getY());
        this.addFeedback();
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        IRootPart root = this.getHost().getRoot();
        Node rootVisual = (Node)root.getVisual();
        this.endPosInRoot = rootVisual.sceneToLocal(e.getSceneX(), e.getSceneY());
        Point2D start = rootVisual.localToScene(this.startPosInRoot);
        Point2D end = rootVisual.localToScene(this.endPosInRoot);
        double[] bbox = FXMarqueeOnDragPolicy.bbox(start, end);
        List<Node> nodes = FXMarqueeOnDragPolicy.findContainedNodes((Node)rootVisual.getScene().getRoot(), bbox[0], bbox[1], bbox[2], bbox[3]);
        List<IContentPart<Node, ? extends Node>> parts = this.getParts(nodes);
        Iterator<IContentPart<Node, ? extends Node>> it = parts.iterator();
        while (it.hasNext()) {
            if (it.next().isSelectable()) continue;
            it.remove();
        }
        try {
            root.getViewer().getDomain().execute((ITransactionalOperation)new SelectOperation(root.getViewer(), parts));
        }
        catch (ExecutionException e1) {
            throw new IllegalStateException(e1);
        }
        this.removeFeedback();
    }

    protected void removeFeedback() {
        if (this.feedback != null) {
            this.getHost().getRoot().removeChild(this.feedback);
            this.feedback = null;
        }
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    protected void updateFeedback() {
        if (this.feedback != null) {
            this.feedback.refreshVisual();
        }
    }
}

