/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.StaticAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.operations.FXBendConnectionOperation;
import org.eclipse.gef4.mvc.fx.operations.FXUpdateAnchorHintsOperation;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.fx.providers.IAnchorProvider;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.AbstractCompositeOperation;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.SelectOperation;
import org.eclipse.gef4.mvc.parts.IBendableContentPart;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractBendPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXBendConnectionPolicy
extends AbstractBendPolicy<Node> {
    protected static final double DEFAULT_OVERLAY_THRESHOLD = 10.0;
    protected static final double DEFAULT_SEGMENT_OVERLAY_THRESHOLD = 6.0;
    private List<Integer> selectedExplicitAnchorIndices = new ArrayList<Integer>();
    private List<Point> selectedInitialPositions = new ArrayList<Point>();
    private List<IAnchor> preMoveExplicitAnchors = new ArrayList<IAnchor>();
    private Point preMoveStartHint = null;
    private Point preMoveEndHint = null;
    private boolean isSelectionHorizontal = false;
    private boolean usePreMoveHints = false;
    private boolean isNormalizationNeeded = false;

    static Object getAnchorageContent(IViewer<Node> viewer, IAnchor anchor) {
        Node anchorageNode = anchor.getAnchorage();
        IVisualPart<Node, ? extends Node> part = FXPartUtils.retrieveVisualPart(viewer, anchorageNode);
        if (part instanceof IContentPart) {
            return ((IContentPart)part).getContent();
        }
        return null;
    }

    static List<IBendableContentPart.BendPoint> getCurrentBendPoints(IVisualPart<Node, ? extends Connection> connectionPart) {
        ArrayList<IBendableContentPart.BendPoint> bendPoints = new ArrayList<IBendableContentPart.BendPoint>();
        Connection connection = (Connection)connectionPart.getVisual();
        ObservableList anchors = connection.getAnchorsUnmodifiable();
        int i = 0;
        while (i < anchors.size()) {
            IAnchor a = (IAnchor)anchors.get(i);
            if (!connection.getRouter().wasInserted(a)) {
                if (connection.isConnected(i)) {
                    Point positionHint = connection.getPoint(i);
                    if (i == 0 && connection.getStartPointHint() != null) {
                        positionHint = connection.getStartPointHint();
                    }
                    if (i == anchors.size() - 1 && connection.getEndPointHint() != null) {
                        positionHint = connection.getEndPointHint();
                    }
                    bendPoints.add(new IBendableContentPart.BendPoint(FXBendConnectionPolicy.getAnchorageContent((IViewer<Node>)connectionPart.getRoot().getViewer(), a), positionHint));
                } else {
                    bendPoints.add(new IBendableContentPart.BendPoint(connection.getPoint(i)));
                }
            }
            ++i;
        }
        return bendPoints;
    }

    protected boolean canConnect(int explicitAnchorIndex) {
        return explicitAnchorIndex == 0 || explicitAnchorIndex == this.getBendOperation().getNewAnchors().size() - 1;
    }

    public ITransactionalOperation commit() {
        ITransactionalOperation commit;
        if (this.isNormalizationNeeded) {
            this.normalize();
        }
        if ((commit = super.commit()) == null || commit.isNoOp()) {
            return null;
        }
        return commit;
    }

    private Point computeEndHint() {
        if (this.getConnection().getEndAnchor() instanceof DynamicAnchor && this.getConnection().getPointsUnmodifiable().size() > 1) {
            Point endPoint = this.getConnection().getEndPoint();
            Point neighbor = this.getConnection().getPoint(this.getConnection().getPointsUnmodifiable().size() - 2);
            Point translated = endPoint.getTranslated(endPoint.getDifference(neighbor).getScaled(0.5));
            return translated;
        }
        return null;
    }

    private Point computeStartHint() {
        if (this.getConnection().getStartAnchor() instanceof DynamicAnchor && this.getConnection().getPointsUnmodifiable().size() > 1) {
            Point startPoint = this.getConnection().getStartPoint();
            Point neighbor = this.getConnection().getPoint(1);
            Point translated = startPoint.getTranslated(startPoint.getDifference(neighbor).getScaled(0.5));
            return translated;
        }
        return null;
    }

    public int createAfter(int explicitAnchorIndex, Point mouseInScene) {
        this.checkInitialized();
        this.isNormalizationNeeded = true;
        int insertionIndex = explicitAnchorIndex + 1;
        this.insertExplicitAnchor(insertionIndex, mouseInScene);
        return insertionIndex;
    }

    public int createBefore(int explicitAnchorIndex, Point mouseInScene) {
        this.checkInitialized();
        this.isNormalizationNeeded = true;
        int insertionIndex = explicitAnchorIndex;
        this.insertExplicitAnchor(insertionIndex, mouseInScene);
        return insertionIndex;
    }

    protected ITransactionalOperation createOperation() {
        ForwardUndoCompositeOperation fwdOp = new ForwardUndoCompositeOperation("BendPlusHints");
        fwdOp.add((IUndoableOperation)new FXBendConnectionOperation(this.getConnection()));
        fwdOp.add((IUndoableOperation)new FXUpdateAnchorHintsOperation(this.getConnection()));
        return fwdOp;
    }

    protected ReverseUndoCompositeOperation createReselectOperation() {
        if (!(this.getHost() instanceof IContentPart) || !((SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).isSelected((IContentPart)this.getHost())) {
            return null;
        }
        ReverseUndoCompositeOperation reselectOperation = new ReverseUndoCompositeOperation("re-select");
        IViewer viewer = this.getHost().getRoot().getViewer();
        DeselectOperation deselectOperation = new DeselectOperation(viewer, Collections.singletonList((IContentPart)this.getHost()));
        SelectOperation selectOperation = new SelectOperation(viewer, Collections.singletonList((IContentPart)this.getHost()));
        reselectOperation.add((IUndoableOperation)deselectOperation);
        reselectOperation.add((IUndoableOperation)selectOperation);
        return reselectOperation;
    }

    protected IAnchor createUnconnectedAnchor(Point selectedPointCurrentPositionInLocal) {
        return new StaticAnchor((Node)this.getConnection(), selectedPointCurrentPositionInLocal);
    }

    protected IAnchor findOrCreateAnchor(Point positionInLocal, boolean canConnect) {
        IAnchor anchor = null;
        if (canConnect) {
            Point selectedPointCurrentPositionInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)positionInLocal)));
            List pickedNodes = NodeUtils.getNodesAt((Node)((Node)this.getHost().getRoot().getVisual()), (double)selectedPointCurrentPositionInScene.x, (double)selectedPointCurrentPositionInScene.y);
            anchor = this.getCompatibleAnchor(this.getParts(pickedNodes));
        }
        if (anchor == null) {
            anchor = this.createUnconnectedAnchor(positionInLocal);
        }
        return anchor;
    }

    protected FXBendConnectionOperation getBendOperation() {
        return (FXBendConnectionOperation)((Object)((AbstractCompositeOperation)super.getOperation()).getOperations().get(0));
    }

    private IAnchor getCompatibleAnchor(List<IContentPart<Node, ? extends Node>> partsUnderMouse) {
        for (IContentPart<Node, ? extends Node> part : partsUnderMouse) {
            IAnchor anchor;
            IAnchorProvider anchorProvider;
            if (part == this.getHost() || (anchorProvider = (IAnchorProvider)part.getAdapter(IAnchorProvider.class)) == null || (anchor = anchorProvider.get(this.getHost())) == null) continue;
            return anchor;
        }
        return null;
    }

    protected Connection getConnection() {
        return (Connection)this.getHost().getVisual();
    }

    protected List<IBendableContentPart.BendPoint> getCurrentBendPoints() {
        return FXBendConnectionPolicy.getCurrentBendPoints(this.getHost());
    }

    protected int getExplicitIndex(int startConnectionIndex, int step) {
        ObservableList anchors = this.getConnection().getAnchorsUnmodifiable();
        IConnectionRouter router = this.getConnection().getRouter();
        int i = startConnectionIndex;
        while (i >= 0 && i < anchors.size()) {
            IAnchor anchor = (IAnchor)anchors.get(i);
            if (!router.wasInserted(anchor)) {
                List<IAnchor> newAnchors = this.getBendOperation().getNewAnchors();
                int j = 0;
                while (j < newAnchors.size()) {
                    if (this.getBendOperation().getConnectionIndex(j) == i) {
                        return j;
                    }
                    ++j;
                }
                throw new IllegalStateException("The explicit anchors of the connection are out of sync with the explicit anchors of the policy.");
            }
            i += step;
        }
        throw new IllegalStateException("The start and end anchor of a Connection need to be explicit.");
    }

    public int getExplicitIndexAtOrAfter(int connectionIndex) {
        return this.getExplicitIndex(connectionIndex, 1);
    }

    public int getExplicitIndexAtOrBefore(int connectionIndex) {
        return this.getExplicitIndex(connectionIndex, -1);
    }

    public IVisualPart<Node, Connection> getHost() {
        return super.getHost();
    }

    protected Point getMouseDeltaInLocal(Point initialMousePositionInScene, Point currentMousePositionInScene) {
        Point mouseInLocal = FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)currentMousePositionInScene)));
        Point deltaInLocal = mouseInLocal.getTranslated(FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)initialMousePositionInScene))).getNegated());
        return deltaInLocal;
    }

    protected double getOverlayThreshold() {
        if (this.getConnection().getRouter() instanceof OrthogonalRouter && this.selectedExplicitAnchorIndices.size() == 2) {
            return 6.0;
        }
        GridModel model = (GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class);
        if (model != null && model.isSnapToGrid()) {
            return Math.min(model.getGridCellWidth(), model.getGridCellHeight()) / 4.0;
        }
        return 10.0;
    }

    private List<IContentPart<Node, ? extends Node>> getParts(List<Node> nodesUnderMouse) {
        ArrayList<IContentPart<Node, ? extends Node>> parts = new ArrayList<IContentPart<Node, ? extends Node>>();
        IViewer viewer = this.getHost().getRoot().getViewer();
        for (Node node : nodesUnderMouse) {
            IVisualPart<Node, ? extends Node> part = FXPartUtils.retrieveVisualPart((IViewer<Node>)viewer, node);
            if (!(part instanceof IContentPart)) continue;
            parts.add((IContentPart<Node, ? extends Node>)((IContentPart)part));
        }
        return parts;
    }

    private Point getPoint(int explicitAnchorIndex) {
        return this.getConnection().getPoint(this.getBendOperation().getConnectionIndex(explicitAnchorIndex));
    }

    private FXUpdateAnchorHintsOperation getUpdateHintsOperation() {
        return (FXUpdateAnchorHintsOperation)((Object)((AbstractCompositeOperation)super.getOperation()).getOperations().get(1));
    }

    public void init() {
        this.selectedExplicitAnchorIndices.clear();
        this.selectedInitialPositions.clear();
        this.preMoveExplicitAnchors.clear();
        this.preMoveStartHint = null;
        this.preMoveEndHint = null;
        this.usePreMoveHints = false;
        this.isNormalizationNeeded = false;
        super.init();
    }

    protected void insertExplicitAnchor(int insertionIndex, Point mouseInScene) {
        Point mouseInLocal = FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)mouseInScene)));
        this.getBendOperation().getNewAnchors().add(insertionIndex, this.createUnconnectedAnchor(mouseInLocal));
        this.locallyExecuteOperation();
    }

    public boolean isExplicit(int connectionIndex) {
        IAnchor anchor = this.getConnection().getAnchor(connectionIndex);
        return !this.getConnection().getRouter().wasInserted(anchor);
    }

    private boolean isExplicitOverlay(int overlayingExplicitAnchorIndex, int overlainExplicitAnchorIndex) {
        return this.getPoint(overlayingExplicitAnchorIndex).getDistance(this.getPoint(overlainExplicitAnchorIndex)) <= this.getOverlayThreshold();
    }

    public boolean isSelectionHorizontal() {
        return this.isSelectionHorizontal;
    }

    private boolean isUnpreciseEquals(double y0, double y1) {
        return Math.abs(y0 - y1) < 1.0;
    }

    protected void locallyExecuteOperation() {
        try {
            this.getBendOperation().execute(null, null);
        }
        catch (Exception x) {
            throw new IllegalStateException(x);
        }
        if (this.usePreMoveHints) {
            this.getUpdateHintsOperation().setNewHints(this.preMoveStartHint, this.preMoveEndHint);
        } else {
            Point newStartHint = this.computeStartHint();
            Point newEndHint = this.computeEndHint();
            this.getUpdateHintsOperation().setNewHints(newStartHint, newEndHint);
        }
        try {
            this.getUpdateHintsOperation().execute(null, null);
        }
        catch (Exception x) {
            throw new IllegalStateException(x);
        }
    }

    public int makeExplicit(int connectionIndex) {
        return this.makeExplicit(connectionIndex, connectionIndex).get(0);
    }

    public List<Integer> makeExplicit(int startConnectionIndex, int endConnectionIndex) {
        this.isNormalizationNeeded = true;
        ArrayList<ImplicitGroup> implicitGroups = new ArrayList<ImplicitGroup>();
        boolean isStartExplicit = this.isExplicit(startConnectionIndex);
        implicitGroups.add(new ImplicitGroup(this.getExplicitIndexAtOrBefore(startConnectionIndex)));
        int i = startConnectionIndex;
        while (i <= endConnectionIndex) {
            if (this.isExplicit(i)) {
                int explicitAnchorHandle = this.getExplicitIndexAtOrBefore(i);
                implicitGroups.add(new ImplicitGroup(explicitAnchorHandle));
            } else {
                Point pointInLocal = this.getConnection().getPoint(i);
                Point pointInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)pointInLocal)));
                ((ImplicitGroup)implicitGroups.get((int)(implicitGroups.size() - 1))).points.add(pointInScene);
            }
            ++i;
        }
        if (((ImplicitGroup)implicitGroups.get((int)0)).points.isEmpty()) {
            implicitGroups.remove(0);
        }
        int addedCount = 0;
        ArrayList<Integer> handles = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < implicitGroups.size()) {
            ImplicitGroup ig = (ImplicitGroup)implicitGroups.get(i2);
            int prec = ig.precedingExplicitIndex + addedCount;
            if (!handles.isEmpty() || isStartExplicit) {
                handles.add(prec);
            }
            for (Point p : ig.points) {
                prec = this.createAfter(prec, p);
                ++addedCount;
                handles.add(prec);
            }
            ++i2;
        }
        return handles;
    }

    public void move(Point initialMouseInScene, Point currentMouseInScene) {
        boolean isOrtho;
        this.checkInitialized();
        int numPoints = this.selectedExplicitAnchorIndices.size();
        boolean bl = isOrtho = numPoints == 2 && this.getConnection().getRouter() instanceof OrthogonalRouter;
        if (this.preMoveExplicitAnchors.isEmpty()) {
            this.isNormalizationNeeded = true;
            int i = 0;
            while (i < this.selectedExplicitAnchorIndices.size()) {
                this.selectedInitialPositions.add(i, this.getPoint(this.selectedExplicitAnchorIndices.get(i)));
                ++i;
            }
            this.preMoveExplicitAnchors.addAll(this.getBendOperation().getNewAnchors());
            if (isOrtho) {
                double y0 = this.selectedInitialPositions.get((int)0).y;
                double y1 = this.selectedInitialPositions.get((int)1).y;
                this.isSelectionHorizontal = this.isUnpreciseEquals(y0, y1);
            }
            this.preMoveStartHint = this.computeStartHint();
            this.preMoveEndHint = this.computeEndHint();
        } else {
            this.getBendOperation().setNewAnchors(this.preMoveExplicitAnchors);
            this.getUpdateHintsOperation().setNewHints(this.preMoveStartHint, this.preMoveEndHint);
            this.usePreMoveHints = true;
            this.locallyExecuteOperation();
            this.usePreMoveHints = false;
        }
        Point mouseDeltaInLocal = this.getMouseDeltaInLocal(initialMouseInScene, currentMouseInScene);
        if (isOrtho) {
            if (this.isSelectionHorizontal) {
                mouseDeltaInLocal.x = 0.0;
            } else {
                mouseDeltaInLocal.y = 0.0;
            }
        }
        int i = 0;
        while (i < this.selectedExplicitAnchorIndices.size()) {
            Point selectedPointCurrentPositionInLocal = this.selectedInitialPositions.get(i).getTranslated(mouseDeltaInLocal);
            int explicitAnchorIndex = this.selectedExplicitAnchorIndices.get(i);
            boolean canConnect = this.canConnect(explicitAnchorIndex);
            this.getBendOperation().getNewAnchors().set(explicitAnchorIndex, this.findOrCreateAnchor(selectedPointCurrentPositionInLocal, canConnect));
            ++i;
        }
        this.locallyExecuteOperation();
        this.removeOverlain();
    }

    public void normalize() {
        if (!(this.getConnection().getRouter() instanceof OrthogonalRouter)) {
            return;
        }
        this.locallyExecuteOperation();
        ObservableList anchors = this.getConnection().getAnchorsUnmodifiable();
        ObservableList positions = this.getConnection().getPointsUnmodifiable();
        int explicitIndex = 0;
        boolean removed = false;
        int i = 1;
        while (i < anchors.size() - 1) {
            IAnchor anchor = (IAnchor)anchors.get(i);
            if (!this.getConnection().getRouter().wasInserted(anchor)) {
                ++explicitIndex;
                Point prev = (Point)positions.get(i - 1);
                Point next = (Point)positions.get(i + 1);
                Point current = (Point)positions.get(i);
                Vector inDirection = new Vector(prev, current);
                Vector outDirection = new Vector(current, next);
                if (inDirection.isNull() || outDirection.isNull() || inDirection.isParallelTo(outDirection)) {
                    Point prevInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(prev.x, prev.y));
                    if (this.getConnection().getRouter().wasInserted((IAnchor)anchors.get(i + 1))) {
                        this.makeExplicit(i + 1);
                    }
                    if (this.getConnection().getRouter().wasInserted((IAnchor)anchors.get(i - 1))) {
                        this.createBefore(explicitIndex, prevInScene);
                        ++explicitIndex;
                    }
                    this.getBendOperation().getNewAnchors().remove(explicitIndex);
                    removed = true;
                    break;
                }
            }
            ++i;
        }
        if (removed) {
            this.normalize();
        }
    }

    private void removeOverlain() {
        if (this.getConnection().getRouter() instanceof OrthogonalRouter && this.selectedExplicitAnchorIndices.size() == 2) {
            this.removeOverlainSegments();
        } else {
            this.removeOverlainPoints();
        }
    }

    private void removeOverlainPoints() {
        int explicitAnchorsSize = this.getBendOperation().getNewAnchors().size();
        int i = this.selectedExplicitAnchorIndices.size() - 1;
        while (i >= 0 && explicitAnchorsSize > 2) {
            boolean isRightOverlain;
            int index = this.selectedExplicitAnchorIndices.get(i);
            boolean isLeftOverlain = index > 0 && this.isExplicitOverlay(index, index - 1);
            boolean bl = isRightOverlain = index < explicitAnchorsSize - 1 && this.isExplicitOverlay(index, index + 1);
            if (isLeftOverlain || isRightOverlain) {
                int overlainIndex;
                int n = overlainIndex = isLeftOverlain ? index - 1 : index + 1;
                if (!this.selectedExplicitAnchorIndices.contains(overlainIndex)) {
                    this.getBendOperation().getNewAnchors().remove(index);
                    this.locallyExecuteOperation();
                }
            }
            --i;
        }
    }

    private void removeOverlainSegments() {
        int[][] possibleSegmentOverlays = new int[][]{{-2, -1, 2, 3}, {-2, -1, 2}, {-1, 2, 3}, {-1, 2}, {-2, -1}, {2, 3}, {2}, {-1}};
        boolean removed = false;
        int i = 0;
        while (i < possibleSegmentOverlays.length && !removed) {
            removed = this.testAndRemoveSegmentOverlay(possibleSegmentOverlays[i]);
            ++i;
        }
        if (removed) {
            this.locallyExecuteOperation();
        }
    }

    protected void route() {
    }

    public void select(int explicitAnchorIndex) {
        this.checkInitialized();
        this.selectedExplicitAnchorIndices.add(explicitAnchorIndex);
    }

    public void selectSegment(int segmentIndex) {
        int firstSegmentIndex = segmentIndex;
        int secondSegmentIndex = segmentIndex + 1;
        Node firstAnchorage = this.getConnection().getAnchor(firstSegmentIndex).getAnchorage();
        boolean isFirstConnected = firstAnchorage != null && firstAnchorage != this.getConnection();
        Node secondAnchorage = this.getConnection().getAnchor(secondSegmentIndex).getAnchorage();
        boolean isSecondConnected = secondAnchorage != null && secondAnchorage != this.getConnection();
        List<Integer> explicit = this.makeExplicit(firstSegmentIndex, secondSegmentIndex);
        int firstAnchorHandle = explicit.get(0);
        int secondAnchorHandle = explicit.get(1);
        if (isFirstConnected) {
            firstAnchorHandle = this.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)this.getPoint(firstAnchorHandle)))));
            ++secondAnchorHandle;
        }
        if (isSecondConnected) {
            secondAnchorHandle = this.createBefore(secondAnchorHandle, FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)this.getPoint(secondAnchorHandle)))));
        }
        this.select(firstAnchorHandle);
        this.select(secondAnchorHandle);
    }

    private boolean testAndRemoveSegmentOverlay(int[] overlainPointIndicesRelativeToSelection) {
        List<Point> points = Arrays.asList(Point.getCopy((Point[])((Point[])this.getConnection().getPointsUnmodifiable().toArray((Object[])new Point[0]))));
        int firstIndex = overlainPointIndicesRelativeToSelection[0];
        int lastIndex = overlainPointIndicesRelativeToSelection[overlainPointIndicesRelativeToSelection.length - 1];
        int selectionStartIndexInConnection = this.getBendOperation().getConnectionIndex(this.selectedExplicitAnchorIndices.get(0));
        if (selectionStartIndexInConnection + firstIndex < 0 || selectionStartIndexInConnection + firstIndex >= points.size()) {
            return false;
        }
        if (selectionStartIndexInConnection + lastIndex < 0 || selectionStartIndexInConnection + lastIndex >= points.size()) {
            return false;
        }
        ArrayList<Point> overlainPoints = new ArrayList<Point>();
        int i = 0;
        while (i < overlainPointIndicesRelativeToSelection.length) {
            overlainPoints.add(points.get(selectionStartIndexInConnection + overlainPointIndicesRelativeToSelection[i]));
            ++i;
        }
        double p = this.isSelectionHorizontal ? ((Point)overlainPoints.get((int)0)).y : ((Point)overlainPoints.get((int)0)).x;
        int i2 = 1;
        while (i2 < overlainPoints.size()) {
            Point q = (Point)overlainPoints.get(i2);
            if (this.isSelectionHorizontal && !this.isUnpreciseEquals(p, q.y) || !this.isSelectionHorizontal && !this.isUnpreciseEquals(p, q.x)) {
                return false;
            }
            if (this.isSelectionHorizontal && !this.isUnpreciseEquals(p, q.y) || !this.isSelectionHorizontal && !this.isUnpreciseEquals(p, q.x)) {
                return false;
            }
            ++i2;
        }
        Point resultStart = (Point)overlainPoints.get(0);
        Point resultEnd = (Point)overlainPoints.get(overlainPoints.size() - 1);
        Point selectionStart = points.get(selectionStartIndexInConnection);
        Point selectionEnd = points.get(selectionStartIndexInConnection + 1);
        double distance = Math.abs(this.isSelectionHorizontal ? resultStart.y - selectionStart.y : resultStart.x - selectionStart.x);
        if (distance > this.getOverlayThreshold()) {
            return false;
        }
        if (overlainPointIndicesRelativeToSelection.length <= 2) {
            if (this.isSelectionHorizontal) {
                if (firstIndex < 0) {
                    resultEnd.x = selectionEnd.x;
                } else {
                    resultStart.x = selectionStart.x;
                }
            } else if (firstIndex < 0) {
                resultEnd.y = selectionEnd.y;
            } else {
                resultStart.y = selectionStart.y;
            }
        }
        int overlayStartIndex = Math.min(selectionStartIndexInConnection, selectionStartIndexInConnection + firstIndex);
        int overlayEndIndex = Math.max(selectionStartIndexInConnection + 1, selectionStartIndexInConnection + lastIndex);
        List<Integer> explicit = this.makeExplicit(overlayStartIndex, overlayEndIndex);
        int removedCount = 0;
        int i3 = explicit.size() - 2;
        while (i3 >= 1) {
            this.getBendOperation().getNewAnchors().remove(explicit.get(i3));
            ++removedCount;
            --i3;
        }
        Integer resultStartIndex = explicit.get(0);
        if (!(this.getBendOperation().getNewAnchors().get(resultStartIndex) instanceof DynamicAnchor)) {
            this.getBendOperation().getNewAnchors().set(resultStartIndex, this.createUnconnectedAnchor(resultStart));
        }
        Integer resultEndIndex = explicit.get(explicit.size() - 1) - removedCount;
        if (!(this.getBendOperation().getNewAnchors().get(resultEndIndex) instanceof DynamicAnchor)) {
            this.getBendOperation().getNewAnchors().set(resultEndIndex, this.createUnconnectedAnchor(resultEnd));
        }
        return true;
    }

    public String toString() {
        return "FXBendConnectionPolicy[host=" + this.getHost() + "]";
    }

    private static class ImplicitGroup {
        int precedingExplicitIndex;
        List<Point> points = new ArrayList<Point>();

        public ImplicitGroup(int precedingExplicitIndex) {
            this.precedingExplicitIndex = precedingExplicitIndex;
        }
    }
}

