/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.inject.Provider;
import java.util.Collections;
import java.util.List;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.util.Pair;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.common.attributes.IAttributeStore;
import org.eclipse.gef4.fx.listeners.VisualChangeListener;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.operations.FXTransformOperation;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.parts.ITransformableContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public abstract class AbstractLabelPart
extends AbstractFXContentPart<Group>
implements ITransformableContentPart<Node, Group> {
    public static final String CSS_CLASS_LABEL = "label";
    private VisualChangeListener vcl = new VisualChangeListener(){

        protected void boundsInLocalChanged(Bounds oldBounds, Bounds newBounds) {
            AbstractLabelPart.this.refreshVisual();
        }

        protected void localToParentTransformChanged(Node observed, Transform oldTransform, Transform newTransform) {
            AbstractLabelPart.this.refreshVisual();
        }
    };
    private MapChangeListener<String, Object> elementAttributesObserver = new MapChangeListener<String, Object>(){

        public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
            AbstractLabelPart.this.refreshVisual();
        }
    };
    private Text text;

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        this.vcl.register((Node)anchorage.getVisual(), (Node)this.getVisual());
    }

    public abstract Point computeLabelPosition();

    protected Text createText() {
        this.text = new Text();
        this.text.setTextOrigin(VPos.TOP);
        this.text.setManaged(false);
        this.text.setPickOnBounds(true);
        this.text.getStyleClass().add((Object)CSS_CLASS_LABEL);
        return this.text;
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        this.vcl.unregister();
    }

    protected void doActivate() {
        super.doActivate();
        ((IAttributeStore)this.getContent().getKey()).attributesProperty().addListener(this.elementAttributesObserver);
    }

    protected void doDeactivate() {
        ((IAttributeStore)this.getContent().getKey()).attributesProperty().removeListener(this.elementAttributesObserver);
        super.doDeactivate();
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    public Pair<? extends IAttributeStore, String> getContent() {
        return (Pair)super.getContent();
    }

    public String getLabelPositionAttributeKey() {
        String labelRole = (String)this.getContent().getValue();
        String attributeKey = null;
        if ("element-external-label".equals(labelRole)) {
            attributeKey = "element-external-label-position";
        } else if (CSS_CLASS_LABEL.equals(labelRole)) {
            attributeKey = "edge-label-position";
        } else if ("edge-source-label".equals(labelRole)) {
            attributeKey = "edge-source-label-position";
        } else if ("edge-target-label".equals(labelRole)) {
            attributeKey = "edge-target-label-position";
        } else {
            throw new IllegalArgumentException("Unsupported content element.");
        }
        return attributeKey;
    }

    public Point getStoredLabelPosition() {
        String key = this.getLabelPositionAttributeKey();
        ObservableMap attributes = ((IAttributeStore)this.getContent().getKey()).getAttributes();
        if (!attributes.containsKey((Object)key)) {
            return null;
        }
        return (Point)attributes.get((Object)key);
    }

    protected Text getText() {
        return this.text;
    }

    protected void refreshPosition(Node visual, Point position) {
        if (position != null) {
            FXTransformOperation refreshPositionOp = new FXTransformOperation((Affine)((Provider)this.getAdapter(FXTransformPolicy.TRANSFORM_PROVIDER_KEY)).get(), Geometry2FX.toFXAffine((AffineTransform)new AffineTransform(1.0, 0.0, 0.0, 1.0, position.x, position.y)));
            try {
                refreshPositionOp.execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    public void setStoredLabelPosition(Point computedPosition) {
        String key = this.getLabelPositionAttributeKey();
        ObservableMap attributes = ((IAttributeStore)this.getContent().getKey()).getAttributes();
        attributes.put((Object)key, (Object)computedPosition);
    }

    public void transformContent(AffineTransform transform) {
        Point storedLabelPosition = this.getStoredLabelPosition();
        if (storedLabelPosition == null) {
            storedLabelPosition = new Point();
        }
        this.setStoredLabelPosition(transform.getTransformed(storedLabelPosition));
    }
}

