/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import javafx.collections.SetChangeListener;
import javafx.scene.Node;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.zest.fx.models.HidingModel;

public abstract class AbstractHidingBehavior
extends AbstractBehavior<Node> {
    private SetChangeListener<org.eclipse.gef4.graph.Node> hidingModelObserver = new SetChangeListener<org.eclipse.gef4.graph.Node>(){

        public void onChanged(SetChangeListener.Change<? extends org.eclipse.gef4.graph.Node> change) {
            AbstractHidingBehavior.this.onHidingModelChange(change);
        }
    };
    private boolean isHidden;

    protected abstract boolean determineHiddenStatus();

    protected void doActivate() {
        HidingModel hidingModel = this.getHidingModel();
        hidingModel.hiddenProperty().addListener(this.hidingModelObserver);
    }

    protected void doDeactivate() {
        HidingModel hidingModel = this.getHidingModel();
        hidingModel.hiddenProperty().removeListener(this.hidingModelObserver);
    }

    protected HidingModel getHidingModel() {
        return (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
    }

    protected void hide() {
        ((Node)this.getHost().getVisual()).setVisible(false);
        ((Node)this.getHost().getVisual()).setMouseTransparent(true);
    }

    protected boolean isHidden() {
        return this.isHidden;
    }

    protected void onHidingModelChange(SetChangeListener.Change<? extends org.eclipse.gef4.graph.Node> change) {
        boolean wasHidden = this.isHidden;
        this.isHidden = this.determineHiddenStatus();
        if (wasHidden && !this.isHidden) {
            this.show();
        } else if (!wasHidden && this.isHidden) {
            this.hide();
        }
    }

    protected void show() {
        ((Node)this.getHost().getVisual()).setVisible(true);
        ((Node)this.getHost().getVisual()).setMouseTransparent(false);
    }
}

