/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.policies;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.mvc.examples.logo.policies.AbstractCloneContentPolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnClickPolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.policies.AbstractInteractionPolicy;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.CreationPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXCloneOnClickPolicy
extends AbstractInteractionPolicy<Node>
implements IFXOnClickPolicy {
    public void click(MouseEvent event) {
        if (!this.isCloneModifierDown(event)) {
            return;
        }
        Object cloneContent = ((AbstractCloneContentPolicy)((Object)this.getHost().getAdapter(AbstractCloneContentPolicy.class))).cloneContent();
        IRootPart root = this.getHost().getRoot();
        CreationPolicy creationPolicy = (CreationPolicy)root.getAdapter((TypeToken)new TypeToken<CreationPolicy<Node>>(){});
        this.init((AbstractTransactionPolicy)creationPolicy);
        IContentPart clonedContentPart = creationPolicy.create(cloneContent, (IContentPart)this.getHost().getParent(), (SetMultimap)HashMultimap.create());
        this.commit((AbstractTransactionPolicy)creationPolicy);
        if (clonedContentPart.getVisual() instanceof Connection) {
            Connection connection = (Connection)clonedContentPart.getVisual();
            if (connection.getStartAnchor() == null) {
                connection.setStartPoint(((Connection)this.getHost().getVisual()).getStartPoint());
            }
            if (connection.getEndAnchor() == null) {
                connection.setEndPoint(((Connection)this.getHost().getVisual()).getEndPoint());
            }
        }
        IViewer viewer = this.getHost().getRoot().getViewer();
        ArrayList toBeDeselected = new ArrayList(((SelectionModel)viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable());
        toBeDeselected.remove(clonedContentPart);
        try {
            viewer.getDomain().execute((IUndoableOperation)new DeselectOperation(this.getHost().getRoot().getViewer(), toBeDeselected));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        AffineTransform originalTransform = FX2Geometry.toAffineTransform((Transform)((Transform)((Provider)this.getHost().getAdapter(FXTransformPolicy.TRANSFORM_PROVIDER_KEY)).get()));
        FXTransformPolicy transformPolicy = (FXTransformPolicy)clonedContentPart.getAdapter(FXTransformPolicy.class);
        this.init((AbstractTransactionPolicy)transformPolicy);
        transformPolicy.setTransform(originalTransform);
        this.commit((AbstractTransactionPolicy)transformPolicy);
    }

    protected boolean isCloneModifierDown(MouseEvent e) {
        return e.isAltDown() || e.isShiftDown();
    }
}

