/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.LayoutProperties;

class AlgorithmHelper {
    private static int MIN_NODE_SIZE = 8;
    private static double PADDING_PERCENT = 0.8;

    AlgorithmHelper() {
    }

    public static void fitWithinBounds(Node[] entities, Rectangle destinationBounds, boolean resize) {
        Rectangle startingBounds = AlgorithmHelper.getLayoutBounds(entities, false);
        double sizeScale = Math.min(destinationBounds.getWidth() / startingBounds.getWidth(), destinationBounds.getHeight() / startingBounds.getHeight());
        if (entities.length == 1) {
            AlgorithmHelper.fitSingleEntity(entities[0], destinationBounds, resize);
            return;
        }
        int i = 0;
        while (i < entities.length) {
            Node entity = entities[i];
            Dimension size = LayoutProperties.getSize(entity);
            if (LayoutProperties.isMovable(entity).booleanValue()) {
                Point location = LayoutProperties.getLocation(entity);
                double percentX = (location.x - startingBounds.getX()) / startingBounds.getWidth();
                double percentY = (location.y - startingBounds.getY()) / startingBounds.getHeight();
                if (resize && LayoutProperties.isResizable(entity).booleanValue()) {
                    size.width *= sizeScale;
                    size.height *= sizeScale;
                    LayoutProperties.setSize(entity, new Dimension(size));
                }
                location.x = destinationBounds.getX() + size.width / 2.0 + percentX * (destinationBounds.getWidth() - size.width);
                location.y = destinationBounds.getY() + size.height / 2.0 + percentY * (destinationBounds.getHeight() - size.height);
                if (Double.isNaN(location.x) || Double.isNaN(location.y)) {
                    location.x = 0.0;
                    location.y = 0.0;
                }
                LayoutProperties.setLocation(entity, new Point(location));
            } else if (resize && LayoutProperties.isResizable(entity).booleanValue()) {
                LayoutProperties.setSize(entity, size.getScaled(sizeScale));
            }
            ++i;
        }
    }

    private static void fitSingleEntity(Node entity, Rectangle destinationBounds, boolean resize) {
        if (LayoutProperties.isMovable(entity).booleanValue()) {
            LayoutProperties.setLocation(entity, new Point(destinationBounds.getX() + destinationBounds.getWidth() / 2.0, destinationBounds.getY() + destinationBounds.getHeight() / 2.0));
        }
        if (resize && LayoutProperties.isResizable(entity).booleanValue()) {
            double width = destinationBounds.getWidth();
            double height = destinationBounds.getHeight();
            double preferredAspectRatio = LayoutProperties.getPreferredAspectRatio(entity);
            if (preferredAspectRatio > 0.0) {
                LayoutProperties.setSize(entity, AlgorithmHelper.fixAspectRatio(width, height, preferredAspectRatio));
            } else {
                LayoutProperties.setSize(entity, new Dimension(width, height));
            }
        }
    }

    public static void maximizeSizes(Node[] entities) {
        if (entities.length > 1) {
            double nodeSize;
            Dimension minDistance = AlgorithmHelper.getMinimumDistance(entities);
            double width = nodeSize = Math.max(minDistance.width, minDistance.height) * PADDING_PERCENT;
            double height = nodeSize;
            int i = 0;
            while (i < entities.length) {
                Node entity = entities[i];
                if (LayoutProperties.isResizable(entity).booleanValue()) {
                    double preferredRatio = LayoutProperties.getPreferredAspectRatio(entity);
                    if (preferredRatio > 0.0) {
                        LayoutProperties.setSize(entity, AlgorithmHelper.fixAspectRatio(width, height, preferredRatio));
                    } else {
                        LayoutProperties.setSize(entity, new Dimension(width, height));
                    }
                }
                ++i;
            }
        }
    }

    private static Dimension fixAspectRatio(double width, double height, double preferredRatio) {
        double actualRatio = width / height;
        if (actualRatio > preferredRatio && (width = height * preferredRatio) < (double)MIN_NODE_SIZE) {
            width = MIN_NODE_SIZE;
            height = width / preferredRatio;
        }
        if (actualRatio < preferredRatio && (height = width / preferredRatio) < (double)MIN_NODE_SIZE) {
            height = MIN_NODE_SIZE;
            width = height * preferredRatio;
        }
        return new Dimension(width, height);
    }

    public static Rectangle getLayoutBounds(Node[] entities, boolean includeNodeSize) {
        double rightSide = Double.NEGATIVE_INFINITY;
        double bottomSide = Double.NEGATIVE_INFINITY;
        double leftSide = Double.POSITIVE_INFINITY;
        double topSide = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < entities.length) {
            Node entity = entities[i];
            Point location = LayoutProperties.getLocation(entity);
            Dimension size = LayoutProperties.getSize(entity);
            if (includeNodeSize) {
                leftSide = Math.min(location.x - size.width / 2.0, leftSide);
                topSide = Math.min(location.y - size.height / 2.0, topSide);
                rightSide = Math.max(location.x + size.width / 2.0, rightSide);
                bottomSide = Math.max(location.y + size.height / 2.0, bottomSide);
            } else {
                leftSide = Math.min(location.x, leftSide);
                topSide = Math.min(location.y, topSide);
                rightSide = Math.max(location.x, rightSide);
                bottomSide = Math.max(location.y, bottomSide);
            }
            ++i;
        }
        return new Rectangle(leftSide, topSide, rightSide - leftSide, bottomSide - topSide);
    }

    public static Dimension getMinimumDistance(Node[] entities) {
        Dimension horAndVertdistance = new Dimension(Double.MAX_VALUE, Double.MAX_VALUE);
        double minDistance = Double.MAX_VALUE;
        int i = 0;
        while (i < entities.length) {
            Point location1 = LayoutProperties.getLocation(entities[i]);
            int j = i + 1;
            while (j < entities.length) {
                Point location2 = LayoutProperties.getLocation(entities[j]);
                double distanceX = location1.x - location2.x;
                double distanceY = location1.y - location2.y;
                double distance = distanceX * distanceX + distanceY * distanceY;
                if (distance < minDistance) {
                    minDistance = distance;
                    horAndVertdistance.width = Math.abs(distanceX);
                    horAndVertdistance.height = Math.abs(distanceY);
                }
                ++j;
            }
            ++i;
        }
        return horAndVertdistance;
    }
}

