/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.ui.view;

import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.examples.logo.MvcLogoExample;
import org.eclipse.gef4.mvc.examples.logo.MvcLogoExampleModule;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricCurve;
import org.eclipse.gef4.mvc.examples.logo.ui.MvcLogoExampleUiModule;
import org.eclipse.gef4.mvc.examples.logo.ui.properties.FXCurvePropertySource;
import org.eclipse.gef4.mvc.fx.ui.parts.AbstractFXView;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.SelectOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.ui.properties.SetPropertyValueOperation;
import org.eclipse.gef4.mvc.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.gef4.mvc.ui.properties.UndoablePropertySheetPage;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class MvcLogoExampleView
extends AbstractFXView {
    private UndoablePropertySheetEntry rootEntry;

    public MvcLogoExampleView() {
        super(Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new MvcLogoExampleModule()}).with(new Module[]{new MvcLogoExampleUiModule()})}));
        FXViewer viewer = this.getContentViewer();
        ContentModel contentModel = (ContentModel)viewer.getAdapter(ContentModel.class);
        contentModel.getContents().setAll((Collection)MvcLogoExample.createDefaultContents());
    }

    public Object getAdapter(Class key) {
        if (IPropertySheetPage.class.equals((Object)key)) {
            UndoablePropertySheetPage propertySheetPage = (UndoablePropertySheetPage)super.getAdapter(key);
            if (this.rootEntry == null) {
                this.rootEntry = new UndoablePropertySheetEntry((IOperationHistory)this.getAdapter(IOperationHistory.class), (IUndoContext)this.getAdapter(IUndoContext.class)){

                    protected void valueChanged(UndoablePropertySheetEntry child, ITransactionalOperation operation) {
                        if (operation instanceof SetPropertyValueOperation) {
                            SetPropertyValueOperation changeRoutingStyleOperation = (SetPropertyValueOperation)operation;
                            if (changeRoutingStyleOperation.getPropertySource() instanceof FXCurvePropertySource && FXCurvePropertySource.ROUTING_STYLE_PROPERTY.getId().equals(changeRoutingStyleOperation.getPropertyId())) {
                                FXCurvePropertySource ps = (FXCurvePropertySource)changeRoutingStyleOperation.getPropertySource();
                                ChangeWayPointsOperation clearWaypointsOperation = new ChangeWayPointsOperation("Clear waypoints", ps.getCurve(), ps.getCurve().getWayPointsCopy(), Collections.emptyList());
                                ForwardUndoCompositeOperation c = new ForwardUndoCompositeOperation("Change routing style");
                                c.add((IUndoableOperation)changeRoutingStyleOperation);
                                c.add((IUndoableOperation)clearWaypointsOperation);
                                IContentPart contentPart = (IContentPart)MvcLogoExampleView.this.getContentViewer().getContentPartMap().get(ps.getCurve());
                                DeselectOperation deselectOperation = new DeselectOperation((IViewer)MvcLogoExampleView.this.getContentViewer(), Collections.singletonList(contentPart));
                                SelectOperation selectOperation = new SelectOperation((IViewer)MvcLogoExampleView.this.getContentViewer(), Collections.singletonList(contentPart));
                                c.add((IUndoableOperation)deselectOperation);
                                c.add((IUndoableOperation)selectOperation);
                                super.valueChanged(child, (ITransactionalOperation)c);
                            } else {
                                super.valueChanged(child, operation);
                            }
                        } else {
                            super.valueChanged(child, operation);
                        }
                    }
                };
                propertySheetPage.setRootEntry((IPropertySheetEntry)this.rootEntry);
            }
            return propertySheetPage;
        }
        return super.getAdapter(key);
    }

    protected FXViewer getPaletteViewer() {
        return (FXViewer)this.getDomain().getAdapter(AdapterKey.get(FXViewer.class, (String)"paletteViewer"));
    }

    protected void hookViewers() {
        FXViewer contentViewer = this.getContentViewer();
        InfiniteCanvas contentRootNode = contentViewer.getCanvas();
        this.getCanvas().setScene(new Scene((Parent)contentRootNode));
    }

    public static final class ChangeWayPointsOperation
    extends AbstractOperation
    implements ITransactionalOperation {
        private final FXGeometricCurve curve;
        private final List<Point> newWayPoints;
        private final List<Point> oldWayPoints;

        public ChangeWayPointsOperation(String label, FXGeometricCurve curve, List<Point> oldWayPoints, List<Point> newWayPoints) {
            super(label);
            this.curve = curve;
            this.oldWayPoints = oldWayPoints;
            this.newWayPoints = newWayPoints;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            this.curve.setWayPoints(this.newWayPoints.toArray(new Point[0]));
            return Status.OK_STATUS;
        }

        public boolean isContentRelevant() {
            return true;
        }

        public boolean isNoOp() {
            return this.oldWayPoints == this.newWayPoints || this.oldWayPoints != null && this.oldWayPoints.equals(this.newWayPoints);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            this.curve.setWayPoints(this.oldWayPoints.toArray(new Point[0]));
            return Status.OK_STATUS;
        }
    }
}

