/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.behaviors.ContentPartPool;
import org.eclipse.gef4.mvc.operations.AbstractCompositeOperation;
import org.eclipse.gef4.mvc.operations.ChangeFocusOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.SelectOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IContentPartFactory;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;
import org.eclipse.gef4.mvc.policies.ContentPolicy;

public class CreationPolicy<VR>
extends AbstractTransactionPolicy<VR> {
    @Inject
    private IContentPartFactory<VR> contentPartFactory;
    @Inject
    private ContentPartPool<VR> contentPartPool;

    public IContentPart<VR, ? extends VR> create(Object content, IContentPart<VR, ? extends VR> parent, int index, SetMultimap<IContentPart<VR, ? extends VR>, String> anchoreds) {
        ITransactionalOperation selectOperation;
        this.checkInitialized();
        if (content == null) {
            throw new IllegalArgumentException("The given content may not be null.");
        }
        if (parent == null) {
            throw new IllegalArgumentException("The given parent may not be null.");
        }
        if (anchoreds == null) {
            throw new IllegalArgumentException("The given anchored parts may not be null");
        }
        IContentPart<VR, VR> contentPart = this.contentPartFactory.createContentPart(content, null, null);
        contentPart.setContent(content);
        parent.addChild(contentPart, index);
        for (Map.Entry anchored : anchoreds.entries()) {
            ((IContentPart)anchored.getKey()).attachToAnchorage(contentPart, (String)anchored.getValue());
        }
        this.contentPartPool.add(contentPart);
        ContentPolicy parentContentPolicy = (ContentPolicy)parent.getAdapter(new TypeToken<ContentPolicy<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.getHost().getRoot().getViewer().getClass())));
        if (parentContentPolicy == null) {
            throw new IllegalStateException("No ContentPolicy registered for <" + parent + ">.");
        }
        parentContentPolicy.init();
        parentContentPolicy.addContentChild(content, index);
        ITransactionalOperation addToParentOperation = parentContentPolicy.commit();
        if (addToParentOperation != null) {
            this.getCompositeOperation().add(addToParentOperation);
        }
        for (IContentPart anchored : anchoreds.keys()) {
            ContentPolicy anchoredPolicy = (ContentPolicy)anchored.getAdapter(new TypeToken<ContentPolicy<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.getHost().getRoot().getViewer().getClass())));
            if (anchoredPolicy == null) {
                throw new IllegalStateException("No ContentPolicy registered for <" + anchored + ">.");
            }
            anchoredPolicy.init();
            for (String role : anchoreds.get((Object)anchored)) {
                anchoredPolicy.attachToContentAnchorage(content, role);
            }
            ITransactionalOperation attachToAnchorageOperation = anchoredPolicy.commit();
            if (attachToAnchorageOperation == null) continue;
            this.getCompositeOperation().add(attachToAnchorageOperation);
        }
        ITransactionalOperation focusOperation = this.createFocusOperation(contentPart);
        if (focusOperation != null) {
            this.getCompositeOperation().add(focusOperation);
        }
        if ((selectOperation = this.createSelectOperation(contentPart)) != null) {
            this.getCompositeOperation().add(selectOperation);
        }
        this.locallyExecuteOperation();
        return contentPart;
    }

    public IContentPart<VR, ? extends VR> create(Object content, IContentPart<VR, ? extends VR> parent, SetMultimap<IContentPart<VR, ? extends VR>, String> anchoreds) {
        return this.create(content, parent, parent.getChildrenUnmodifiable().size(), anchoreds);
    }

    protected ITransactionalOperation createFocusOperation(IContentPart<VR, ? extends VR> part) {
        return new ChangeFocusOperation<VR>(part.getRoot().getViewer(), part);
    }

    @Override
    protected ITransactionalOperation createOperation() {
        return new ReverseUndoCompositeOperation("Create Content");
    }

    protected ITransactionalOperation createSelectOperation(IContentPart<VR, ? extends VR> part) {
        return new SelectOperation<VR>(part.getRoot().getViewer(), Collections.singletonList(part));
    }

    protected AbstractCompositeOperation getCompositeOperation() {
        return (AbstractCompositeOperation)this.getOperation();
    }
}

