/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXSegmentHandlePart;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.CursorSupport;
import org.eclipse.gef4.mvc.fx.policies.FXResizePolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnDragPolicy;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public class FXResizeTransformSelectedOnHandleDragPolicy
extends AbstractFXInteractionPolicy
implements IFXOnDragPolicy {
    private Point initialMouseLocation = null;
    private Rectangle selectionBounds;
    private Map<IContentPart<Node, ? extends Node>, Double> relX1 = null;
    private Map<IContentPart<Node, ? extends Node>, Double> relY1 = null;
    private Map<IContentPart<Node, ? extends Node>, Double> relX2 = null;
    private Map<IContentPart<Node, ? extends Node>, Double> relY2 = null;
    private boolean invalidGesture = false;
    private Map<IContentPart<Node, ? extends Node>, Integer> scaleIndices = new HashMap<IContentPart<Node, ? extends Node>, Integer>();
    private Map<IContentPart<Node, ? extends Node>, Integer> translateIndices = new HashMap<IContentPart<Node, ? extends Node>, Integer>();
    private CursorSupport cursorSupport = new CursorSupport(this);
    private List<IContentPart<Node, ? extends Node>> targetParts;

    private void computeRelatives(IContentPart<Node, ? extends Node> targetPart) {
        Rectangle bounds = this.getVisualBounds(targetPart);
        double left = bounds.getX() - this.selectionBounds.getX();
        this.relX1.put(targetPart, left / this.selectionBounds.getWidth());
        double right = left + bounds.getWidth();
        this.relX2.put(targetPart, right / this.selectionBounds.getWidth());
        double top = bounds.getY() - this.selectionBounds.getY();
        this.relY1.put(targetPart, top / this.selectionBounds.getHeight());
        double bottom = top + bounds.getHeight();
        this.relY2.put(targetPart, bottom / this.selectionBounds.getHeight());
    }

    @Override
    public void drag(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            return;
        }
        if (this.selectionBounds == null) {
            return;
        }
        Rectangle sel = this.updateSelectionBounds(e);
        for (IContentPart<Node, ? extends Node> targetPart : this.targetParts) {
            Bounds initialBounds = this.getBounds(this.selectionBounds, targetPart);
            Bounds newBounds = this.getBounds(sel, targetPart);
            double dx = newBounds.getMinX() - initialBounds.getMinX();
            double dy = newBounds.getMinY() - initialBounds.getMinY();
            Node visual = (Node)targetPart.getVisual();
            Point2D originInParent = visual.getParent().sceneToLocal(0.0, 0.0);
            Point2D deltaInParent = visual.getParent().sceneToLocal(dx, dy);
            dx = deltaInParent.getX() - originInParent.getX();
            dy = deltaInParent.getY() - originInParent.getY();
            this.getTransformPolicy(targetPart).setPostTranslate(this.translateIndices.get(targetPart), dx, dy);
            AffineTransform affineTransform = this.getTransformPolicy(targetPart).getCurrentTransform();
            if (affineTransform.getRotation().equals((Object)Angle.fromDeg((double)0.0))) {
                double dw = newBounds.getWidth() - initialBounds.getWidth();
                double dh = newBounds.getHeight() - initialBounds.getHeight();
                Point2D originInLocal = visual.sceneToLocal(newBounds.getMinX(), newBounds.getMinY());
                Point2D dstInLocal = visual.sceneToLocal(newBounds.getMinX() + dw, newBounds.getMinY() + dh);
                dw = dstInLocal.getX() - originInLocal.getX();
                dh = dstInLocal.getY() - originInLocal.getY();
                this.getResizePolicy(targetPart).resize(dw, dh);
                continue;
            }
            double sx = newBounds.getWidth() / initialBounds.getWidth();
            double sy = newBounds.getHeight() / initialBounds.getHeight();
            this.getTransformPolicy(targetPart).setPostScale(this.scaleIndices.get(targetPart), sx, sy);
        }
    }

    @Override
    public void dragAborted() {
        if (this.invalidGesture) {
            return;
        }
        for (IContentPart<Node, ? extends Node> part : this.targetParts) {
            FXTransformPolicy transformPolicy = this.getTransformPolicy(part);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals((IVisualPart)part);
            this.rollback((AbstractTransactionPolicy)transformPolicy);
            FXResizePolicy resizePolicy = this.getResizePolicy(part);
            if (resizePolicy == null) continue;
            this.rollback((AbstractTransactionPolicy)resizePolicy);
        }
        this.scaleIndices.clear();
        this.translateIndices.clear();
        this.selectionBounds = null;
        this.initialMouseLocation = null;
        this.relY2 = null;
        this.relX2 = null;
        this.relY1 = null;
        this.relX1 = null;
    }

    private Bounds getBounds(Rectangle sel, IContentPart<Node, ? extends Node> targetPart) {
        double x1 = sel.getX() + sel.getWidth() * this.relX1.get(targetPart);
        double x2 = sel.getX() + sel.getWidth() * this.relX2.get(targetPart);
        double y1 = sel.getY() + sel.getHeight() * this.relY1.get(targetPart);
        double y2 = sel.getY() + sel.getHeight() * this.relY2.get(targetPart);
        return new BoundingBox(x1, y1, x2 - x1, y2 - y1);
    }

    protected CursorSupport getCursorSupport() {
        return this.cursorSupport;
    }

    public AbstractFXSegmentHandlePart<Node> getHost() {
        return (AbstractFXSegmentHandlePart)super.getHost();
    }

    protected FXResizePolicy getResizePolicy(IContentPart<Node, ? extends Node> part) {
        return (FXResizePolicy)((Object)part.getAdapter(FXResizePolicy.class));
    }

    private Rectangle getSelectionBounds(List<IContentPart<Node, ? extends Node>> targetParts) {
        if (targetParts.isEmpty()) {
            throw new IllegalArgumentException("No target parts given.");
        }
        Rectangle bounds = this.getVisualBounds(targetParts.get(0));
        if (targetParts.size() == 1) {
            return bounds;
        }
        ListIterator<IContentPart<Node, ? extends Node>> iterator = targetParts.listIterator(1);
        while (iterator.hasNext()) {
            IContentPart<Node, ? extends Node> cp = iterator.next();
            bounds.union(this.getVisualBounds(cp));
        }
        return bounds;
    }

    protected List<IContentPart<Node, ? extends Node>> getTargetParts() {
        return ((SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable();
    }

    protected FXTransformPolicy getTransformPolicy(IContentPart<Node, ? extends Node> part) {
        return (FXTransformPolicy)((Object)part.getAdapter(FXTransformPolicy.class));
    }

    protected Rectangle getVisualBounds(IContentPart<Node, ? extends Node> contentPart) {
        if (contentPart == null) {
            throw new IllegalArgumentException("contentPart may not be null!");
        }
        return FX2Geometry.toRectangle((Bounds)((Node)contentPart.getVisual()).localToScene(((Node)contentPart.getVisual()).getLayoutBounds()));
    }

    @Override
    public void hideIndicationCursor() {
        this.getCursorSupport().restoreCursor();
    }

    @Override
    public void press(MouseEvent e) {
        this.targetParts = this.getTargetParts();
        if (this.targetParts.size() < 2 || e.isControlDown()) {
            this.invalidGesture = true;
            return;
        }
        this.initialMouseLocation = new Point(e.getSceneX(), e.getSceneY());
        this.selectionBounds = this.getSelectionBounds(this.targetParts);
        this.relX1 = new HashMap<IContentPart<Node, ? extends Node>, Double>();
        this.relY1 = new HashMap<IContentPart<Node, ? extends Node>, Double>();
        this.relX2 = new HashMap<IContentPart<Node, ? extends Node>, Double>();
        this.relY2 = new HashMap<IContentPart<Node, ? extends Node>, Double>();
        for (IContentPart<Node, ? extends Node> targetPart : this.targetParts) {
            FXTransformPolicy transformPolicy = this.getTransformPolicy(targetPart);
            if (transformPolicy == null) continue;
            this.storeAndDisableRefreshVisuals((IVisualPart)targetPart);
            this.computeRelatives(targetPart);
            this.init((AbstractTransactionPolicy)transformPolicy);
            Point pivotInScene = this.getVisualBounds(targetPart).getTopLeft();
            Point pivotInParent = FX2Geometry.toPoint((Point2D)((Node)this.getHost().getVisual()).getParent().sceneToLocal(pivotInScene.x, pivotInScene.y));
            int translateToOriginIndex = transformPolicy.createPostTransform();
            int scaleIndex = transformPolicy.createPostTransform();
            int translateBackIndex = transformPolicy.createPostTransform();
            transformPolicy.setPostTranslate(translateToOriginIndex, -pivotInParent.x, -pivotInParent.y);
            transformPolicy.setPostTranslate(translateBackIndex, pivotInParent.x, pivotInParent.y);
            this.scaleIndices.put(targetPart, scaleIndex);
            this.translateIndices.put(targetPart, transformPolicy.createPostTransform());
            FXResizePolicy resizePolicy = this.getResizePolicy(targetPart);
            if (resizePolicy == null) continue;
            this.init((AbstractTransactionPolicy)resizePolicy);
        }
    }

    @Override
    public void release(MouseEvent e, Dimension delta) {
        if (this.invalidGesture) {
            this.invalidGesture = false;
            return;
        }
        for (IContentPart<Node, ? extends Node> part : this.targetParts) {
            FXTransformPolicy transformPolicy = this.getTransformPolicy(part);
            if (transformPolicy == null) continue;
            this.restoreRefreshVisuals((IVisualPart)part);
            this.commit((AbstractTransactionPolicy)transformPolicy);
            FXResizePolicy resizePolicy = this.getResizePolicy(part);
            if (resizePolicy == null) continue;
            this.commit((AbstractTransactionPolicy)resizePolicy);
        }
        this.scaleIndices.clear();
        this.translateIndices.clear();
        this.selectionBounds = null;
        this.initialMouseLocation = null;
        this.relY2 = null;
        this.relX2 = null;
        this.relY1 = null;
        this.relX1 = null;
    }

    @Override
    public boolean showIndicationCursor(KeyEvent event) {
        return false;
    }

    @Override
    public boolean showIndicationCursor(MouseEvent event) {
        return false;
    }

    private Rectangle updateSelectionBounds(MouseEvent e) {
        Rectangle sel = this.selectionBounds.getCopy();
        double dx = e.getSceneX() - this.initialMouseLocation.x;
        double dy = e.getSceneY() - this.initialMouseLocation.y;
        int segment = this.getHost().getSegmentIndex();
        if (segment == 0 || segment == 3) {
            sel.shrink(dx, 0.0, 0.0, 0.0);
        } else if (segment == 1 || segment == 2) {
            sel.expand(0.0, 0.0, dx, 0.0);
        }
        if (segment == 0 || segment == 1) {
            sel.shrink(0.0, dy, 0.0, 0.0);
        } else if (segment == 2 || segment == 3) {
            sel.expand(0.0, 0.0, 0.0, dy);
        }
        return sel;
    }
}

