/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.geometry.Bounds;
import javafx.scene.Node;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.fx.operations.FXResizeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.policies.AbstractResizePolicy;

public class FXResizePolicy
extends AbstractResizePolicy<Node> {
    protected ITransactionalOperation createOperation() {
        return new FXResizeOperation("Resize", this.getVisualToResize(), this.getCurrentSize(), 0.0, 0.0);
    }

    protected Dimension getCurrentSize() {
        Bounds layoutBounds = this.getVisualToResize().getLayoutBounds();
        return new Dimension(layoutBounds.getWidth(), layoutBounds.getHeight());
    }

    protected double getMinimumHeight() {
        return 5.0;
    }

    protected double getMinimumWidth() {
        return 5.0;
    }

    protected FXResizeOperation getResizeOperation() {
        return (FXResizeOperation)this.getOperation();
    }

    protected Node getVisualToResize() {
        return (Node)this.getHost().getVisual();
    }

    protected void updateResizeOperation(double dw, double dh) {
        double layoutDh;
        FXResizeOperation resizeOperation = this.getResizeOperation();
        Node visual = resizeOperation.getVisual();
        boolean resizable = visual.isResizable();
        double layoutDw = resizable ? dw : 0.0;
        double d = layoutDh = resizable ? dh : 0.0;
        if (resizable) {
            if (resizeOperation.getInitialSize().width + layoutDw < this.getMinimumWidth()) {
                layoutDw = this.getMinimumWidth() - resizeOperation.getInitialSize().width;
            }
            if (resizeOperation.getInitialSize().height + layoutDh < this.getMinimumHeight()) {
                layoutDh = this.getMinimumHeight() - resizeOperation.getInitialSize().height;
            }
        }
        resizeOperation.setDw(layoutDw);
        resizeOperation.setDh(layoutDh);
    }
}

