/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import javafx.animation.AnimationTimer;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.gef4.mvc.fx.policies.FXChangeViewportPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnTypePolicy;
import org.eclipse.gef4.mvc.policies.AbstractInteractionPolicy;

public class FXPanOnTypePolicy
extends AbstractInteractionPolicy<Node>
implements IFXOnTypePolicy {
    public static final double DEFAULT_SCROLL_AMOUNT_PER_SECOND = 150.0;
    private AnimationTimer timer;
    private boolean isRunning;
    private boolean isDown;
    private boolean isUp;
    private boolean isLeft;
    private boolean isRight;
    private long startMillisDown;
    private long startMillisUp;
    private long startMillisLeft;
    private long startMillisRight;
    private long currentMillisDown = 0L;
    private long currentMillisUp = 0L;
    private long currentMillisLeft = 0L;
    private long currentMillisRight = 0L;
    private long totalMillisDown = 0L;
    private long totalMillisUp = 0L;
    private long totalMillisLeft = 0L;
    private long totalMillisRight = 0L;

    public double getScrollAmountPerSecond() {
        return 150.0;
    }

    @Override
    public void pressed(KeyEvent event) {
        long now = System.currentTimeMillis();
        if (!this.isDown && event.getCode().equals((Object)KeyCode.DOWN)) {
            this.isDown = true;
            this.startMillisDown = now;
            this.currentMillisDown = 0L;
        } else if (!this.isUp && event.getCode().equals((Object)KeyCode.UP)) {
            this.isUp = true;
            this.startMillisUp = now;
            this.currentMillisUp = 0L;
        } else if (!this.isLeft && event.getCode().equals((Object)KeyCode.LEFT)) {
            this.isLeft = true;
            this.startMillisLeft = now;
            this.currentMillisLeft = 0L;
        } else if (!this.isRight && event.getCode().equals((Object)KeyCode.RIGHT)) {
            this.isRight = true;
            this.startMillisRight = now;
            this.currentMillisRight = 0L;
        }
        if (!this.isRunning && (this.isDown || this.isUp || this.isLeft || this.isRight)) {
            FXChangeViewportPolicy viewportPolicy = (FXChangeViewportPolicy)((Object)this.getHost().getRoot().getAdapter(FXChangeViewportPolicy.class));
            this.init(viewportPolicy);
            if (this.timer == null) {
                this.timer = new AnimationTimer(){

                    public void handle(long nanos) {
                        long now = System.currentTimeMillis();
                        if (FXPanOnTypePolicy.this.isDown) {
                            FXPanOnTypePolicy.this.currentMillisDown = now - FXPanOnTypePolicy.this.startMillisDown;
                        }
                        if (FXPanOnTypePolicy.this.isUp) {
                            FXPanOnTypePolicy.this.currentMillisUp = now - FXPanOnTypePolicy.this.startMillisUp;
                        }
                        if (FXPanOnTypePolicy.this.isLeft) {
                            FXPanOnTypePolicy.this.currentMillisLeft = now - FXPanOnTypePolicy.this.startMillisLeft;
                        }
                        if (FXPanOnTypePolicy.this.isRight) {
                            FXPanOnTypePolicy.this.currentMillisRight = now - FXPanOnTypePolicy.this.startMillisRight;
                        }
                        FXPanOnTypePolicy.this.updateScrollPosition();
                    }
                };
            }
            this.timer.start();
            this.isRunning = true;
        }
    }

    @Override
    public void released(KeyEvent event) {
        long now = System.currentTimeMillis();
        if (event.getCode().equals((Object)KeyCode.DOWN)) {
            this.isDown = false;
            this.totalMillisDown += now - this.startMillisDown;
            this.currentMillisDown = 0L;
        } else if (event.getCode().equals((Object)KeyCode.UP)) {
            this.isUp = false;
            this.totalMillisUp += now - this.startMillisUp;
            this.currentMillisUp = 0L;
        } else if (event.getCode().equals((Object)KeyCode.LEFT)) {
            this.isLeft = false;
            this.totalMillisLeft += now - this.startMillisLeft;
            this.currentMillisLeft = 0L;
        } else if (event.getCode().equals((Object)KeyCode.RIGHT)) {
            this.isRight = false;
            this.totalMillisRight += now - this.startMillisRight;
            this.currentMillisRight = 0L;
        }
        if (!(!this.isRunning || this.isDown || this.isUp || this.isLeft || this.isRight)) {
            this.isRunning = false;
            this.timer.stop();
            this.updateScrollPosition();
            FXChangeViewportPolicy viewportPolicy = (FXChangeViewportPolicy)((Object)this.getHost().getRoot().getAdapter(FXChangeViewportPolicy.class));
            this.commit(viewportPolicy);
            this.totalMillisDown = 0L;
            this.totalMillisUp = 0L;
            this.totalMillisLeft = 0L;
            this.totalMillisRight = 0L;
        }
    }

    @Override
    public void typed(KeyEvent event) {
    }

    @Override
    public void unfocus() {
    }

    protected void updateScrollPosition() {
        double scrollAmount = this.getScrollAmountPerSecond();
        double dx = (double)(this.totalMillisLeft + this.currentMillisLeft) / 1000.0 * scrollAmount - (double)(this.totalMillisRight + this.currentMillisRight) / 1000.0 * scrollAmount;
        double dy = (double)(this.totalMillisUp + this.currentMillisUp) / 1000.0 * scrollAmount - (double)(this.totalMillisDown + this.currentMillisDown) / 1000.0 * scrollAmount;
        FXChangeViewportPolicy viewportPolicy = (FXChangeViewportPolicy)((Object)this.getHost().getRoot().getAdapter(FXChangeViewportPolicy.class));
        viewportPolicy.scrollAbsolute(dx, dy);
    }
}

