/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.ui.properties;

import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.gef4.mvc.ui.properties.UndoablePropertySheetEntry;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class UndoablePropertySheetPage
extends PropertySheetPage {
    private final IOperationHistory operationHistory;
    private final IOperationHistoryListener operationHistoryListener;
    private UndoRedoActionGroup actionGroup;

    public UndoablePropertySheetPage(IOperationHistory operationHistory, IUndoContext undoContext, UndoRedoActionGroup actionGroup) {
        this.operationHistory = operationHistory;
        this.actionGroup = actionGroup;
        this.operationHistoryListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (event.getEventType() == 2 || event.getEventType() == 3) {
                    UndoablePropertySheetPage.this.refresh();
                }
            }
        };
        operationHistory.addOperationHistoryListener(this.operationHistoryListener);
        this.setRootEntry((IPropertySheetEntry)new UndoablePropertySheetEntry(operationHistory, undoContext));
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        if (this.actionGroup != null) {
            this.actionGroup.fillActionBars(actionBars);
        }
    }

    public void dispose() {
        if (this.operationHistory != null) {
            this.operationHistory.removeOperationHistoryListener(this.operationHistoryListener);
        }
        super.dispose();
    }
}

