/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IResizableContentPart;

public class ResizeContentOperation<VR>
extends AbstractOperation
implements ITransactionalOperation {
    private final IResizableContentPart<VR, ? extends VR> resizableContentPart;
    private Dimension initialSize;
    private Dimension finalSize;

    public ResizeContentOperation(IResizableContentPart<VR, ? extends VR> resizableContentPart, Dimension initialSize, Dimension finalSize) {
        super("Update Content Size");
        this.resizableContentPart = resizableContentPart;
        this.initialSize = initialSize;
        this.finalSize = finalSize;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.resizableContentPart.resizeContent(this.finalSize);
        return Status.OK_STATUS;
    }

    @Override
    public boolean isContentRelevant() {
        return true;
    }

    @Override
    public boolean isNoOp() {
        return this.initialSize.equals((Object)this.finalSize);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.resizableContentPart.resizeContent(this.initialSize);
        return Status.OK_STATUS;
    }
}

