/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.gef4.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef4.common.collections.CollectionUtils;
import org.eclipse.gef4.mvc.parts.IContentPart;

public class SelectionModel<VR> {
    public static final String SELECTION_PROPERTY = "selection";
    private ObservableList<IContentPart<VR, ? extends VR>> selection = CollectionUtils.observableArrayList();
    private ObservableList<IContentPart<VR, ? extends VR>> selectionUnmodifiable = FXCollections.unmodifiableObservableList(this.selection);
    private ReadOnlyListWrapper<IContentPart<VR, ? extends VR>> selectionUnmodifiableProperty = new ReadOnlyListWrapperEx((Object)this, "selection", this.selectionUnmodifiable);

    public void appendToSelection(IContentPart<VR, ? extends VR> toBeAppended) {
        this.appendToSelection(Collections.singletonList(toBeAppended));
    }

    public void appendToSelection(List<? extends IContentPart<VR, ? extends VR>> toBeAppended) {
        List<IContentPart<VR, VR>> newSelection = this.getSelectionCopy();
        newSelection.removeAll(toBeAppended);
        for (IContentPart<VR, VR> iContentPart : toBeAppended) {
            if (newSelection.contains(iContentPart)) {
                throw new IllegalArgumentException("The content part " + iContentPart + " is provided more than once in the given list.");
            }
            newSelection.add(iContentPart);
        }
        if (!this.selection.equals(newSelection)) {
            this.selection.setAll(newSelection);
        }
    }

    public void clearSelection() {
        if (!this.selection.isEmpty()) {
            this.selection.clear();
        }
    }

    private List<IContentPart<VR, ? extends VR>> getSelectionCopy() {
        return new ArrayList<IContentPart<VR, ? extends VR>>(this.selection);
    }

    public ObservableList<IContentPart<VR, ? extends VR>> getSelectionUnmodifiable() {
        return this.selectionUnmodifiable;
    }

    public boolean isSelected(IContentPart<VR, ? extends VR> contentPart) {
        return this.selection.contains(contentPart);
    }

    public void prependToSelection(IContentPart<VR, ? extends VR> toBePrepended) {
        this.prependToSelection(Collections.singletonList(toBePrepended));
    }

    public void prependToSelection(List<? extends IContentPart<VR, ? extends VR>> toBePrepended) {
        List<IContentPart<VR, VR>> newSelection = this.getSelectionCopy();
        newSelection.removeAll(toBePrepended);
        int i = 0;
        for (IContentPart<VR, VR> iContentPart : toBePrepended) {
            if (newSelection.contains(iContentPart)) {
                throw new IllegalArgumentException("The content part " + iContentPart + " is provided more than once in the given list.");
            }
            newSelection.add(i++, iContentPart);
        }
        if (!this.selection.equals(newSelection)) {
            this.selection.setAll(newSelection);
        }
    }

    public void removeFromSelection(Collection<? extends IContentPart<VR, ? extends VR>> contentParts) {
        this.selection.removeAll(contentParts);
    }

    public void removeFromSelection(IContentPart<VR, ? extends VR> contentPart) {
        this.selection.remove(contentPart);
    }

    public ReadOnlyListProperty<IContentPart<VR, ? extends VR>> selectionUnmodifiableProperty() {
        return this.selectionUnmodifiableProperty.getReadOnlyProperty();
    }

    public void setSelection(IContentPart<VR, ? extends VR> newSelection) {
        this.setSelection(Collections.singletonList(newSelection));
    }

    public void setSelection(List<? extends IContentPart<VR, ? extends VR>> selection) {
        ArrayList<IContentPart<VR, VR>> newSelection = new ArrayList<IContentPart<VR, VR>>();
        int i = 0;
        for (IContentPart<VR, VR> iContentPart : selection) {
            if (newSelection.contains(iContentPart)) {
                throw new IllegalArgumentException("The content part " + iContentPart + " is provided more than once in the given list.");
            }
            newSelection.add(i++, iContentPart);
        }
        if (!this.selection.equals(newSelection)) {
            this.selection.setAll(newSelection);
        }
    }
}

