/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef4.dot.internal.DotAttributes;
import org.eclipse.gef4.dot.internal.DotLanguageSupport;
import org.eclipse.gef4.dot.internal.parser.dot.AttrList;
import org.eclipse.gef4.dot.internal.parser.dot.AttrStmt;
import org.eclipse.gef4.dot.internal.parser.dot.Attribute;
import org.eclipse.gef4.dot.internal.parser.dot.AttributeType;
import org.eclipse.gef4.dot.internal.parser.dot.DotAst;
import org.eclipse.gef4.dot.internal.parser.dot.DotGraph;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeRhsNode;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeStmtNode;
import org.eclipse.gef4.dot.internal.parser.dot.GraphType;
import org.eclipse.gef4.dot.internal.parser.dot.NodeId;
import org.eclipse.gef4.dot.internal.parser.dot.NodeStmt;
import org.eclipse.gef4.dot.internal.parser.dot.Stmt;
import org.eclipse.gef4.dot.internal.parser.dot.util.DotSwitch;
import org.eclipse.gef4.dot.internal.parser.splines.Splines;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;

public final class DotInterpreter
extends DotSwitch<Object> {
    private Graph.Builder graphBuilder;
    private Map<String, Node> nodesByName = new HashMap<String, Node>();
    private Map<String, String> globalGraphAttributes = new HashMap<String, String>();
    private Map<String, String> globalNodeAttributes = new HashMap<String, String>();
    private Map<String, String> globalEdgeAttributes = new HashMap<String, String>();
    private boolean createEdge;
    private String currentArrowHead;
    private String currentArrowTail;
    private String currentArrowSize;
    private String currentEdgeDirection;
    private String currentEdgeStyle;
    private String currentEdgeLabel;
    private String currentEdgeSourceNodeName;
    private String currentEdgePos;
    private String currentEdgeXLabel;
    private String currentEdgeXlp;
    private String currentEdgeLp;
    private String currentEdgeTailLabel;
    private String currentEdgeHeadLabel;
    private String currentEdgeHeadLp;
    private String currentEdgeTailLp;
    private String currentEdgeId;
    private String currentEdgeOp;

    public List<Graph> interpret(DotAst dotAst) {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (DotGraph dotGraph : dotAst.getGraphs()) {
            this.globalGraphAttributes.clear();
            this.globalNodeAttributes.clear();
            this.globalEdgeAttributes.clear();
            this.graphBuilder = new Graph.Builder();
            this.nodesByName.clear();
            TreeIterator contents = EcoreUtil.getAllProperContents((EObject)dotGraph, (boolean)false);
            while (contents.hasNext()) {
                this.doSwitch((EObject)contents.next());
            }
            Graph g = (Graph)this.doSwitch(dotGraph);
            if (g == null) continue;
            graphs.add(g);
        }
        return graphs;
    }

    @Override
    public Object caseDotGraph(DotGraph dotGraph) {
        GraphType graphType;
        String name = this.escaped(dotGraph.getName());
        if (name != null) {
            this.graphBuilder.attr("_name", (Object)name);
        }
        this.graphBuilder.attr("_type", (Object)(GraphType.GRAPH.equals((Object)(graphType = dotGraph.getType())) ? DotAttributes._TYPE__G__GRAPH : DotAttributes._TYPE__G__DIGRAPH));
        Graph graph = this.graphBuilder.build();
        String layout = this.getAttributeValue(dotGraph, "layout");
        if (layout != null) {
            DotAttributes.setLayout(graph, layout);
        } else if (this.globalGraphAttributes.containsKey("layout")) {
            DotAttributes.setLayout(graph, this.globalGraphAttributes.get("layout"));
        }
        String rankdir = this.getAttributeValue(dotGraph, "rankdir");
        if (rankdir != null) {
            DotAttributes.setRankdir(graph, rankdir);
        } else if (this.globalGraphAttributes.containsKey("rankdir")) {
            DotAttributes.setRankdir(graph, this.globalGraphAttributes.get("rankdir"));
        }
        String splines = this.getAttributeValue(dotGraph, "splines");
        if (splines == null && this.globalGraphAttributes.containsKey("splines")) {
            splines = this.globalGraphAttributes.get("splines");
        }
        if (splines != null) {
            Boolean booleanValue = DotLanguageSupport.parseAttributeValue(DotLanguageSupport.BOOL_PARSER, splines);
            if (booleanValue != null) {
                DotAttributes.setSplinesParsed(graph, Boolean.TRUE.equals(booleanValue) ? Splines.TRUE : Splines.FALSE);
            } else {
                DotAttributes.setSplines(graph, splines);
            }
        }
        return graph;
    }

    @Override
    public Object caseAttrStmt(AttrStmt attrStmt) {
        AttributeType type = attrStmt.getType();
        switch (type) {
            case EDGE: {
                for (AttrList al : attrStmt.getAttrLists()) {
                    for (Attribute a : al.getAttributes()) {
                        this.globalEdgeAttributes.put(a.getName(), this.escaped(a.getValue()));
                    }
                }
                break;
            }
            case NODE: {
                for (AttrList al : attrStmt.getAttrLists()) {
                    for (Attribute a : al.getAttributes()) {
                        this.globalNodeAttributes.put(a.getName(), this.escaped(a.getValue()));
                    }
                }
                break;
            }
            case GRAPH: {
                for (AttrList al : attrStmt.getAttrLists()) {
                    for (Attribute a : al.getAttributes()) {
                        this.globalGraphAttributes.put(a.getName(), this.escaped(a.getValue()));
                    }
                }
                break;
            }
        }
        return super.caseAttrStmt(attrStmt);
    }

    @Override
    public Object caseNodeStmt(NodeStmt nodeStmt) {
        String skew;
        String sides;
        String shape;
        String height;
        String width;
        String xlp;
        String pos;
        String xLabel;
        String label;
        String id;
        Node node = this.node(this.escaped(nodeStmt.getNode().getName()));
        String distortion = this.getAttributeValue(nodeStmt, "distortion");
        if (distortion != null) {
            DotAttributes.setDistortion(node, distortion);
        }
        if ((id = this.getAttributeValue(nodeStmt, "id")) != null) {
            DotAttributes.setId(node, id);
        }
        if ((label = this.getAttributeValue(nodeStmt, "label")) != null) {
            DotAttributes.setLabel(node, label);
        }
        if ((xLabel = this.getAttributeValue(nodeStmt, "xlabel")) != null) {
            DotAttributes.setXLabel(node, xLabel);
        }
        if ((pos = this.getAttributeValue(nodeStmt, "pos")) != null) {
            DotAttributes.setPos(node, pos);
        }
        if ((xlp = this.getAttributeValue(nodeStmt, "xlp")) != null) {
            DotAttributes.setXlp(node, xlp);
        }
        if ((width = this.getAttributeValue(nodeStmt, "width")) != null) {
            DotAttributes.setWidth(node, width);
        }
        if ((height = this.getAttributeValue(nodeStmt, "height")) != null) {
            DotAttributes.setHeight(node, height);
        }
        if ((shape = this.getAttributeValue(nodeStmt, "shape")) != null) {
            DotAttributes.setShape(node, shape);
        }
        if ((sides = this.getAttributeValue(nodeStmt, "sides")) != null) {
            DotAttributes.setSides(node, sides);
        }
        if ((skew = this.getAttributeValue(nodeStmt, "skew")) != null) {
            DotAttributes.setSkew(node, skew);
        }
        return super.caseNodeStmt(nodeStmt);
    }

    @Override
    public Object caseEdgeStmtNode(EdgeStmtNode object) {
        this.currentEdgeId = this.getAttributeValue(object, "id");
        this.currentEdgeLabel = this.getAttributeValue(object, "label");
        this.currentEdgeLp = this.getAttributeValue(object, "lp");
        this.currentEdgeXLabel = this.getAttributeValue(object, "xlabel");
        this.currentEdgeXlp = this.getAttributeValue(object, "xlp");
        this.currentEdgeStyle = this.getAttributeValue(object, "style");
        this.currentEdgePos = this.getAttributeValue(object, "pos");
        this.currentEdgeHeadLabel = this.getAttributeValue(object, "headlabel");
        this.currentEdgeHeadLp = this.getAttributeValue(object, "head_lp");
        this.currentEdgeTailLabel = this.getAttributeValue(object, "taillabel");
        this.currentEdgeTailLp = this.getAttributeValue(object, "tail_lp");
        this.currentArrowHead = this.getAttributeValue(object, "arrowhead");
        this.currentArrowTail = this.getAttributeValue(object, "arrowtail");
        this.currentArrowSize = this.getAttributeValue(object, "arrowsize");
        this.currentEdgeDirection = this.getAttributeValue(object, "dir");
        return super.caseEdgeStmtNode(object);
    }

    @Override
    public Object caseNodeId(NodeId object) {
        if (!this.createEdge) {
            this.currentEdgeSourceNodeName = this.escaped(object.getName());
        } else {
            String targetNodeName = this.escaped(object.getName());
            if (this.currentEdgeSourceNodeName != null && targetNodeName != null) {
                this.edge(this.currentEdgeSourceNodeName, this.currentEdgeOp, targetNodeName);
                this.currentEdgeSourceNodeName = targetNodeName;
            }
            this.createEdge = false;
        }
        return super.caseNodeId(object);
    }

    private void edge(String sourceNodeName, String edgeOp, String targetNodeName) {
        Edge edge = new Edge.Builder(this.node(sourceNodeName), this.node(targetNodeName)).attr("_name", (Object)(String.valueOf(sourceNodeName) + edgeOp + targetNodeName)).buildEdge();
        if (this.currentEdgeId != null) {
            DotAttributes.setId(edge, this.currentEdgeId);
        }
        if (this.currentEdgeLabel != null) {
            DotAttributes.setLabel(edge, this.currentEdgeLabel);
        } else if (this.globalEdgeAttributes.containsKey("label")) {
            DotAttributes.setLabel(edge, this.globalEdgeAttributes.get("label"));
        }
        if (this.currentEdgeXLabel != null) {
            DotAttributes.setXLabel(edge, this.currentEdgeXLabel);
        } else if (this.globalEdgeAttributes.containsKey("xlabel")) {
            DotAttributes.setXLabel(edge, this.globalEdgeAttributes.get("xlabel"));
        }
        if (this.currentEdgeHeadLabel != null) {
            DotAttributes.setHeadLabel(edge, this.currentEdgeHeadLabel);
        } else if (this.globalEdgeAttributes.containsKey("headlabel")) {
            DotAttributes.setHeadLabel(edge, this.globalEdgeAttributes.get("headlabel"));
        }
        if (this.currentEdgeTailLabel != null) {
            DotAttributes.setTailLabel(edge, this.currentEdgeTailLabel);
        } else if (this.globalEdgeAttributes.containsKey("taillabel")) {
            DotAttributes.setTailLabel(edge, this.globalEdgeAttributes.get("taillabel"));
        }
        if (this.currentEdgeStyle != null) {
            DotAttributes.setStyle(edge, this.currentEdgeStyle);
        } else if (this.globalEdgeAttributes.containsKey("style")) {
            DotAttributes.setStyle(edge, this.globalEdgeAttributes.get("style"));
        }
        if (this.currentArrowHead != null) {
            DotAttributes.setArrowHead(edge, this.currentArrowHead);
        } else if (this.globalEdgeAttributes.containsKey("arrowhead")) {
            DotAttributes.setArrowHead(edge, this.globalEdgeAttributes.get("arrowhead"));
        }
        if (this.currentArrowTail != null) {
            DotAttributes.setArrowTail(edge, this.currentArrowTail);
        } else if (this.globalEdgeAttributes.containsKey("arrowtail")) {
            DotAttributes.setArrowTail(edge, this.globalEdgeAttributes.get("arrowtail"));
        }
        if (this.currentArrowSize != null) {
            DotAttributes.setArrowSize(edge, this.currentArrowSize);
        } else if (this.globalEdgeAttributes.containsKey("arrowsize")) {
            DotAttributes.setArrowSize(edge, this.globalEdgeAttributes.get("arrowsize"));
        }
        if (this.currentEdgeDirection != null) {
            DotAttributes.setDir(edge, this.currentEdgeDirection);
        } else if (this.globalEdgeAttributes.containsKey("dir")) {
            DotAttributes.setDir(edge, this.globalEdgeAttributes.get("dir"));
        }
        if (this.currentEdgePos != null) {
            DotAttributes.setPos(edge, this.currentEdgePos);
        }
        if (this.currentEdgeLp != null) {
            DotAttributes.setLp(edge, this.currentEdgeLp);
        }
        if (this.currentEdgeXlp != null) {
            DotAttributes.setXlp(edge, this.currentEdgeXlp);
        }
        if (this.currentEdgeHeadLp != null) {
            DotAttributes.setHeadLp(edge, this.currentEdgeHeadLp);
        }
        if (this.currentEdgeTailLp != null) {
            DotAttributes.setTailLp(edge, this.currentEdgeTailLp);
        }
        this.graphBuilder.edges(new Edge[]{edge});
    }

    @Override
    public Object caseEdgeRhsNode(EdgeRhsNode object) {
        this.createEdge = true;
        this.currentEdgeOp = object.getOp().getLiteral();
        return super.caseEdgeRhsNode(object);
    }

    private Node node(String nodeName) {
        if (!this.nodesByName.containsKey(nodeName)) {
            Node node = new Node.Builder().attr("_name", (Object)nodeName).buildNode();
            this.graphBuilder.nodes(new Node[]{node});
            this.nodesByName.put(nodeName, node);
            if (this.globalNodeAttributes.containsKey("label")) {
                DotAttributes.setLabel(node, this.globalNodeAttributes.get("label"));
            }
            if (this.globalNodeAttributes.containsKey("xlabel")) {
                DotAttributes.setXLabel(node, this.globalNodeAttributes.get("xlabel"));
            }
            if (this.globalNodeAttributes.containsKey("width")) {
                DotAttributes.setWidth(node, this.globalNodeAttributes.get("width"));
            }
            if (this.globalNodeAttributes.containsKey("height")) {
                DotAttributes.setHeight(node, this.globalNodeAttributes.get("height"));
            }
        }
        return this.nodesByName.get(nodeName);
    }

    private String getAttributeValue(DotGraph graph, String name) {
        for (Stmt stmt : graph.getStmts()) {
            String value = null;
            if (stmt instanceof AttrStmt) {
                value = this.getAttributeValue((AttrStmt)stmt, name);
            } else if (stmt instanceof Attribute) {
                value = this.getAttributeValue((Attribute)stmt, name);
            }
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getAttributeValue(NodeStmt stmt, String name) {
        return this.getAttributeValue((List<AttrList>)stmt.getAttrLists(), name);
    }

    private String getAttributeValue(List<AttrList> attrLists, String name) {
        for (AttrList attrList : attrLists) {
            String value = this.getAttributeValue(attrList, name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getAttributeValue(AttrStmt attrStmt, String name) {
        return this.getAttributeValue((List<AttrList>)attrStmt.getAttrLists(), name);
    }

    private String getAttributeValue(EdgeStmtNode edgeStmtNode, String name) {
        return this.getAttributeValue((List<AttrList>)edgeStmtNode.getAttrLists(), name);
    }

    private String getAttributeValue(AttrList attrList, String name) {
        for (EObject next : attrList.eContents()) {
            String value;
            if (!(next instanceof Attribute) || (value = this.getAttributeValue((Attribute)next, name)) == null) continue;
            return value;
        }
        return null;
    }

    private String getAttributeValue(Attribute attribute, String name) {
        if (attribute.getName().equals(name)) {
            return this.escaped(attribute.getValue());
        }
        return null;
    }

    private String escaped(String id) {
        if (id == null) {
            return null;
        }
        return id.replaceAll("^\"|\"$", "").replaceAll("\\\\\"", "\"");
    }
}

