/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.Set;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXFeedbackPart;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXSelectionFeedbackPart
extends AbstractFXFeedbackPart<GeometryNode<IGeometry>> {
    public static final double STROKE_WIDTH = 1.5;
    public static final Color PRIMARY_COLOR = Color.BLACK;
    public static final Color SECONDARY_COLOR = Color.web((String)"#666666");
    private Provider<? extends IGeometry> feedbackGeometryProvider;

    protected GeometryNode<IGeometry> createVisual() {
        GeometryNode feedbackVisual = new GeometryNode();
        feedbackVisual.setFill((Paint)Color.TRANSPARENT);
        feedbackVisual.setMouseTransparent(true);
        feedbackVisual.setManaged(false);
        feedbackVisual.setStrokeWidth(1.5);
        return feedbackVisual;
    }

    public void doRefreshVisual(GeometryNode<IGeometry> visual) {
        Set anchorages = this.getAnchoragesUnmodifiable().keySet();
        if (anchorages.isEmpty()) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        visual.setGeometry(feedbackGeometry);
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
        }
        IVisualPart anchorage = (IVisualPart)anchorages.iterator().next();
        IViewer viewer = anchorage.getRoot().getViewer();
        ObservableList selected = ((SelectionModel)viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).getSelectionUnmodifiable();
        if (selected.get(0) == anchorage) {
            visual.setStroke((Paint)PRIMARY_COLOR);
            visual.toFront();
        } else {
            visual.setStroke((Paint)SECONDARY_COLOR);
        }
    }

    protected IGeometry getFeedbackGeometry() {
        return NodeUtils.sceneToLocal((Node)((Node)this.getVisual()), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    public void setGeometryProvider(Provider<? extends IGeometry> geometryProvider) {
        this.feedbackGeometryProvider = geometryProvider;
    }
}

