/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXFeedbackPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXHoverFeedbackPart
extends AbstractFXFeedbackPart<GeometryNode<IGeometry>> {
    public static final Color DEFAULT_STROKE = Color.web((String)"#5a61af");
    public static final String EFFECT_PROVIDER = "HoverFeedbackEffectProvider";
    private Provider<? extends IGeometry> feedbackGeometryProvider;

    protected GeometryNode<IGeometry> createVisual() {
        GeometryNode visual = new GeometryNode();
        visual.setFill((Paint)Color.TRANSPARENT);
        visual.setMouseTransparent(true);
        visual.setManaged(false);
        visual.setStrokeType(StrokeType.OUTSIDE);
        visual.setStrokeWidth(1.0);
        visual.setEffect(this.getHoverFeedbackEffect());
        visual.setStroke((Paint)DEFAULT_STROKE);
        return visual;
    }

    public void doRefreshVisual(GeometryNode<IGeometry> visual) {
        if (this.getAnchoragesUnmodifiable().size() != 1) {
            return;
        }
        IGeometry feedbackGeometry = this.getFeedbackGeometry();
        if (feedbackGeometry == null) {
            return;
        }
        visual.setGeometry(feedbackGeometry);
        if (feedbackGeometry instanceof ICurve) {
            visual.setStrokeType(StrokeType.CENTERED);
        } else {
            visual.setStrokeType(StrokeType.OUTSIDE);
        }
    }

    protected IGeometry getFeedbackGeometry() {
        return NodeUtils.sceneToLocal((Node)((Node)this.getVisual()), (IGeometry)((IGeometry)this.feedbackGeometryProvider.get()));
    }

    public Effect getHoverFeedbackEffect() {
        Provider effectProvider = null;
        if (!this.getAnchoragesUnmodifiable().isEmpty()) {
            IVisualPart host = (IVisualPart)this.getAnchoragesUnmodifiable().keys().iterator().next();
            effectProvider = (Provider)host.getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<? extends Effect>>(){}, (String)EFFECT_PROVIDER));
        }
        if (effectProvider == null) {
            DropShadow effect = new DropShadow();
            effect.setRadius(3.0);
            return effect;
        }
        return (Effect)effectProvider.get();
    }

    public void setGeometryProvider(Provider<? extends IGeometry> geometryProvider) {
        this.feedbackGeometryProvider = geometryProvider;
    }
}

