package org.eclipse.gef4.dot.internal.parser.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowShape;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowShapes;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowtypePackage;
import org.eclipse.gef4.dot.internal.parser.arrowtype.DeprecatedArrowShape;
import org.eclipse.gef4.dot.internal.parser.services.DotArrowTypeGrammarAccess;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;

@SuppressWarnings("all")
public class DotArrowTypeSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private DotArrowTypeGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == ArrowtypePackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case ArrowtypePackage.ARROW_SHAPE:
				if(context == grammarAccess.getArrowShapeRule()) {
					sequence_ArrowShape(context, (ArrowShape) semanticObject); 
					return; 
				}
				else break;
			case ArrowtypePackage.ARROW_SHAPES:
				if(context == grammarAccess.getArrowShapesRule() ||
				   context == grammarAccess.getArrowTypeRule()) {
					sequence_ArrowShapes(context, (ArrowShapes) semanticObject); 
					return; 
				}
				else break;
			case ArrowtypePackage.DEPRECATED_ARROW_SHAPE:
				if(context == grammarAccess.getArrowTypeRule() ||
				   context == grammarAccess.getDeprecatedArrowShapeRule()) {
					sequence_DeprecatedArrowShape(context, (DeprecatedArrowShape) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (open?='o'? (side='l' | side='r')? shape=PrimitiveShape)
	 */
	protected void sequence_ArrowShape(EObject context, ArrowShape semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (arrowShapes+=ArrowShape (arrowShapes+=ArrowShape (arrowShapes+=ArrowShape arrowShapes+=ArrowShape?)?)?)
	 */
	protected void sequence_ArrowShapes(EObject context, ArrowShapes semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (arrowShapes+='ediamond' | arrowShapes+='open' | arrowShapes+='halfopen' | arrowShapes+='empty' | arrowShapes+='invempty')
	 */
	protected void sequence_DeprecatedArrowShape(EObject context, DeprecatedArrowShape semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
