/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.policies;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.behaviors.ContentBehavior;
import org.eclipse.gef4.mvc.fx.operations.FXChangeViewportOperation;
import org.eclipse.gef4.mvc.fx.policies.FXChangeViewportPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.parts.PartUtils;
import org.eclipse.gef4.zest.fx.models.NavigationModel;
import org.eclipse.gef4.zest.fx.operations.NavigateOperation;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class SemanticZoomPolicy
extends FXChangeViewportPolicy {
    private ContentModel contentModel;
    private NavigationModel navigationModel;

    protected ITransactionalOperation createOperation() {
        return new NavigateOperation((FXViewer)this.getHost().getRoot().getViewer());
    }

    protected List<NodePart> findNestingNodes() {
        ObservableList rootChildren = this.getHost().getRoot().getChildrenUnmodifiable();
        ObservableList graphChildren = rootChildren.size() > 0 ? ((IVisualPart)rootChildren.get(0)).getChildrenUnmodifiable() : Collections.emptyList();
        List nestingNodeContentParts = PartUtils.filterParts((Collection)graphChildren, NodePart.class);
        int i = nestingNodeContentParts.size() - 1;
        while (i >= 0) {
            NodePart nodePart = (NodePart)((Object)nestingNodeContentParts.get(i));
            if (nodePart.getContent().getNestedGraph() == null) {
                nestingNodeContentParts.remove(i);
            }
            --i;
        }
        return nestingNodeContentParts;
    }

    protected FXChangeViewportOperation getChangeViewportOperation() {
        return this.getNavigateOperation().getChangeViewportOperation();
    }

    protected NavigateOperation getNavigateOperation() {
        return (NavigateOperation)this.getOperation();
    }

    public void init() {
        this.contentModel = (ContentModel)this.getHost().getRoot().getViewer().getAdapter(ContentModel.class);
        if (this.contentModel == null) {
            throw new IllegalArgumentException("ContentModel could not be obtained!");
        }
        this.navigationModel = (NavigationModel)this.getHost().getRoot().getViewer().getAdapter(NavigationModel.class);
        if (this.navigationModel == null) {
            throw new IllegalArgumentException("NavigationModel could not be obtained!");
        }
        super.init();
    }

    public void zoomRelative(double relativeZoom, double sceneX, double sceneY) {
        this.checkInitialized();
        double initialZoomLevel = this.getChangeViewportOperation().getNewTransform().getScaleX();
        double finalZoomLevel = initialZoomLevel * relativeZoom;
        boolean openGraph = false;
        if (initialZoomLevel < finalZoomLevel && finalZoomLevel > 3.0) {
            List<NodePart> nestingNodeContentParts = this.findNestingNodes();
            double pivotDistance = Double.MAX_VALUE;
            NodePart pivotPart = null;
            InfiniteCanvas infiniteCanvas = ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas();
            Rectangle viewportBounds = new Rectangle(0.0, 0.0, infiniteCanvas.getWidth(), infiniteCanvas.getHeight());
            Point pivotPoint = FX2Geometry.toPoint((Point2D)infiniteCanvas.sceneToLocal(sceneX, sceneY));
            for (NodePart nodePart : new ArrayList<NodePart>(nestingNodeContentParts)) {
                double distance;
                Group visual = (Group)nodePart.getVisual();
                Bounds boundsInScene = visual.localToScene(visual.getLayoutBounds());
                Rectangle boundsInViewport = FX2Geometry.toRectangle((Bounds)infiniteCanvas.sceneToLocal(boundsInScene));
                if (!boundsInViewport.touches(viewportBounds) || !((distance = boundsInViewport.getCenter().getDistance(pivotPoint)) < pivotDistance)) continue;
                pivotPart = nodePart;
            }
            if (pivotPart != null) {
                openGraph = true;
                this.getNavigateOperation().setFinalState(pivotPart.getContent().getNestedGraph(), true);
            }
        } else if (initialZoomLevel > finalZoomLevel && finalZoomLevel < 0.7) {
            Graph nestingGraph;
            Graph currentGraph = (Graph)this.contentModel.getContents().get(0);
            Graph graph = nestingGraph = currentGraph.getNestingNode() != null ? currentGraph.getNestingNode().getGraph() : null;
            if (nestingGraph != null) {
                openGraph = true;
                this.getNavigateOperation().setFinalState(nestingGraph, false);
            }
        }
        if (openGraph) {
            this.locallyExecuteOperation();
        } else {
            super.zoomRelative(relativeZoom, sceneX, sceneY);
        }
        for (NodePart nestingNodePart : this.findNestingNodes()) {
            nestingNodePart.refreshContentChildren();
            ((ContentBehavior)nestingNodePart.getAdapter((TypeToken)new TypeToken<ContentBehavior<Node>>(){})).synchronizeContentChildren((List)ImmutableList.copyOf((Collection)nestingNodePart.getContentChildrenUnmodifiable()));
        }
    }
}

