/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.util.Pair;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.behaviors.ContentBehavior;
import org.eclipse.gef4.mvc.fx.parts.AbstractFXContentPart;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.behaviors.GraphLayoutBehavior;
import org.eclipse.gef4.zest.fx.layout.GraphLayoutContext;
import org.eclipse.gef4.zest.fx.models.NavigationModel;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class GraphPart
extends AbstractFXContentPart<Group> {
    private MapChangeListener<String, Object> graphAttributesObserver = new MapChangeListener<String, Object>(){

        public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
            GraphPart.this.refreshVisual();
            GraphPart.this.applyLayout(true);
        }
    };
    private ListChangeListener<Object> graphChildrenObserver = new ListChangeListener<Object>(){

        public void onChanged(ListChangeListener.Change<? extends Object> c) {
            ((ContentBehavior)GraphPart.this.getAdapter((TypeToken)new TypeToken<ContentBehavior<Node>>(){})).synchronizeContentChildren(GraphPart.this.doGetContentChildren());
            GraphPart.this.updateLayoutContext();
            ((GraphLayoutBehavior)((Object)GraphPart.this.getAdapter(GraphLayoutBehavior.class))).applyLayout(true);
        }
    };

    protected void addChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Group)this.getVisual()).getChildren().add(index, (Object)((Node)child.getVisual()));
    }

    private void applyLayout(boolean clean) {
        GraphLayoutBehavior layoutBehavior = (GraphLayoutBehavior)((Object)this.getAdapter(GraphLayoutBehavior.class));
        if (layoutBehavior != null) {
            layoutBehavior.applyLayout(clean);
        }
    }

    protected Group createVisual() {
        Group visual = new Group();
        visual.setAutoSizeChildren(false);
        return visual;
    }

    protected void doActivate() {
        boolean isViewportChanged;
        super.doActivate();
        this.getContent().attributesProperty().addListener(this.graphAttributesObserver);
        this.getContent().getNodes().addListener(this.graphChildrenObserver);
        this.getContent().getEdges().addListener(this.graphChildrenObserver);
        NavigationModel navigationModel = (NavigationModel)this.getViewer().getAdapter(NavigationModel.class);
        NavigationModel.ViewportState savedViewport = navigationModel == null ? null : navigationModel.getViewportState(this.getContent());
        InfiniteCanvas canvas = ((FXViewer)this.getViewer()).getCanvas();
        boolean isNested = this.getParent() instanceof NodePart;
        boolean bl = isViewportChanged = savedViewport != null && (savedViewport.getWidth() != canvas.getWidth() || savedViewport.getHeight() != canvas.getHeight());
        if (savedViewport == null || isNested || isViewportChanged) {
            this.applyLayout(true);
        }
    }

    protected void doDeactivate() {
        this.getContent().attributesProperty().removeListener(this.graphAttributesObserver);
        this.getContent().getNodes().removeListener(this.graphChildrenObserver);
        this.getContent().getEdges().removeListener(this.graphChildrenObserver);
        super.doDeactivate();
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        return HashMultimap.create();
    }

    protected List<? extends Object> doGetContentChildren() {
        ArrayList<Pair> children = new ArrayList<Pair>();
        children.addAll((Collection<Pair>)this.getContent().getEdges());
        for (Edge e : this.getContent().getEdges()) {
            if (ZestProperties.getLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"label"));
            }
            if (ZestProperties.getExternalLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"element-external-label"));
            }
            if (ZestProperties.getSourceLabel(e) != null) {
                children.add(new Pair((Object)e, (Object)"source-label"));
            }
            if (ZestProperties.getTargetLabel(e) == null) continue;
            children.add(new Pair((Object)e, (Object)"target-label"));
        }
        children.addAll((Collection<Pair>)this.getContent().getNodes());
        for (org.eclipse.gef4.graph.Node n : this.getContent().getNodes()) {
            if (ZestProperties.getExternalLabel(n) == null) continue;
            children.add(new Pair((Object)n, (Object)"element-external-label"));
        }
        return children;
    }

    public void doRefreshVisual(Group visual) {
    }

    public Graph getContent() {
        return (Graph)super.getContent();
    }

    protected void removeChildVisual(IVisualPart<Node, ? extends Node> child, int index) {
        ((Group)this.getVisual()).getChildren().remove(child.getVisual());
    }

    public void setContent(Object content) {
        super.setContent(content);
        this.updateLayoutContext();
    }

    private void updateLayoutContext() {
        GraphLayoutContext layoutContext = (GraphLayoutContext)((Object)this.getAdapter(GraphLayoutContext.class));
        if (layoutContext != null) {
            layoutContext.setGraph(this.getContent());
        }
    }
}

