/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Text;
import javafx.util.Pair;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.parts.AbstractLabelPart;

public class EdgeLabelPart
extends AbstractLabelPart {
    @Override
    public Point computeLabelPosition() {
        Point position = null;
        String value = (String)this.getContent().getValue();
        if ("label".equals(value)) {
            position = this.getMidPoint();
        } else if ("element-external-label".equals(value)) {
            position = this.getMidPoint();
        } else if ("source-label".equals(value)) {
            position = this.getStartPoint();
        } else if ("target-label".equals(value)) {
            position = this.getEndPoint();
        }
        return position;
    }

    protected Group createVisual() {
        Text text = this.createText();
        Group g = new Group();
        g.getStyleClass().add((Object)"edge");
        g.getChildren().add((Object)text);
        return g;
    }

    protected SetMultimap<? extends Object, String> doGetContentAnchorages() {
        HashMultimap contentAnchorages = HashMultimap.create();
        contentAnchorages.put(this.getContent().getKey(), (Object)((String)this.getContent().getValue()));
        return contentAnchorages;
    }

    protected void doRefreshVisual(Group visual) {
        String label;
        Edge edge = (Edge)this.getContent().getKey();
        ReadOnlyMapProperty attrs = edge.attributesProperty();
        if ("label".equals(this.getContent().getValue())) {
            String label2 = ZestProperties.getLabel(edge);
            if (label2 != null) {
                this.getText().setText(label2);
            }
            if (attrs.containsKey("element-label-css-style")) {
                String textCssStyle = ZestProperties.getLabelCssStyle(edge);
                ((Group)this.getVisual()).setStyle(textCssStyle);
            }
        } else if ("element-external-label".equals(this.getContent().getValue())) {
            String label3 = ZestProperties.getExternalLabel(edge);
            if (label3 != null) {
                this.getText().setText(label3);
            }
            if (attrs.containsKey("element-external-label-css-style")) {
                String textCssStyle = ZestProperties.getLabelCssStyle(edge);
                ((Group)this.getVisual()).setStyle(textCssStyle);
            }
        } else if ("source-label".equals(this.getContent().getValue())) {
            String label4 = ZestProperties.getSourceLabel(edge);
            if (label4 != null) {
                this.getText().setText(label4);
            }
        } else if ("target-label".equals(this.getContent().getValue()) && (label = ZestProperties.getTargetLabel(edge)) != null) {
            this.getText().setText(label);
        }
        if (this.getFirstAnchorage() == null) {
            return;
        }
        this.refreshPosition((Node)this.getVisual(), this.getStoredLabelPosition());
    }

    public Pair<Edge, String> getContent() {
        return super.getContent();
    }

    private Point getEndPoint() {
        Connection connection = (Connection)this.getFirstAnchorage().getVisual();
        Point endPoint = connection.getEndPoint();
        Vector v = new Vector(endPoint, connection.getStartPoint()).getNormalized().getMultiplied(this.getText().getLayoutBounds().getHeight());
        return NodeUtils.sceneToLocal((Node)((Group)this.getVisual()).getParent(), (Point)NodeUtils.localToScene((Node)connection, (Point)endPoint.getTranslated(v.x, v.y)));
    }

    protected IContentPart<Node, ? extends Connection> getFirstAnchorage() {
        return this.getAnchoragesUnmodifiable().isEmpty() ? null : (IContentPart)this.getAnchoragesUnmodifiable().keys().iterator().next();
    }

    private Point getMidPoint() {
        Connection connection = (Connection)this.getFirstAnchorage().getVisual();
        Point midPoint = connection.getCenter();
        return NodeUtils.sceneToLocal((Node)((Group)this.getVisual()).getParent(), (Point)NodeUtils.localToScene((Node)connection, (Point)midPoint));
    }

    private Point getStartPoint() {
        Connection connection = (Connection)this.getFirstAnchorage().getVisual();
        Point startPoint = connection.getStartPoint();
        Vector v = new Vector(startPoint, connection.getEndPoint()).getNormalized().getMultiplied(this.getText().getLayoutBounds().getHeight());
        return NodeUtils.sceneToLocal((Node)((Group)this.getVisual()).getParent(), (Point)NodeUtils.localToScene((Node)connection, (Point)startPoint.getTranslated(v.x, v.y)));
    }
}

