/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.layout;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.AbstractLayoutContext;
import org.eclipse.gef4.layout.IEdgeLayout;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.zest.fx.layout.GraphEdgeLayout;
import org.eclipse.gef4.zest.fx.layout.GraphNodeLayout;

public class GraphLayoutContext
extends AbstractLayoutContext {
    private final ReadOnlyMapWrapper<String, Object> attributesProperty = new ReadOnlyMapWrapperEx((Object)this, "attributes", FXCollections.observableHashMap());
    private final Map<Node, GraphNodeLayout> nodeMap = new IdentityHashMap<Node, GraphNodeLayout>();
    private final Map<Edge, GraphEdgeLayout> edgeMap = new IdentityHashMap<Edge, GraphEdgeLayout>();
    private Graph graph;

    public GraphLayoutContext() {
        this.setGraph(null);
    }

    public GraphLayoutContext(Graph graph) {
        this.setGraph(graph);
    }

    public ReadOnlyMapProperty<String, Object> attributesProperty() {
        return this.attributesProperty.getReadOnlyProperty();
    }

    public ObservableMap<String, Object> getAttributes() {
        return this.attributesProperty.get();
    }

    public GraphEdgeLayout getEdgeLayout(Edge edge) {
        return this.edgeMap.get(edge);
    }

    public IEdgeLayout[] getEdges() {
        IEdgeLayout[] all;
        ArrayList<IEdgeLayout> connections = new ArrayList<IEdgeLayout>();
        IEdgeLayout[] iEdgeLayoutArray = all = super.getEdges();
        int n = all.length;
        int n2 = 0;
        while (n2 < n) {
            IEdgeLayout c = iEdgeLayoutArray[n2];
            if (!(this.isLayoutIrrelevant(c) || this.isLayoutIrrelevant(c.getSource()) || this.isLayoutIrrelevant(c.getTarget()))) {
                connections.add(c);
            }
            ++n2;
        }
        return connections.toArray(new IEdgeLayout[0]);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public GraphNodeLayout getNodeLayout(Node node) {
        return this.nodeMap.get(node);
    }

    public INodeLayout[] getNodes() {
        INodeLayout[] allNodes;
        ArrayList<INodeLayout> nodes = new ArrayList<INodeLayout>();
        INodeLayout[] iNodeLayoutArray = allNodes = super.getNodes();
        int n = allNodes.length;
        int n2 = 0;
        while (n2 < n) {
            INodeLayout n3 = iNodeLayoutArray[n2];
            if (!this.isLayoutIrrelevant(n3)) {
                nodes.add(n3);
            }
            ++n2;
        }
        return nodes.toArray(new INodeLayout[0]);
    }

    public void setGraph(Graph graph) {
        if (graph == null) {
            graph = new Graph();
        }
        this.graph = graph;
        this.transferNodes();
        this.transferEdges();
    }

    private void transferEdges() {
        this.clearEdges();
        this.edgeMap.clear();
        for (Edge edge : this.graph.getEdges()) {
            GraphEdgeLayout graphConnection = new GraphEdgeLayout(this, edge);
            this.addEdge(graphConnection);
            this.edgeMap.put(edge, graphConnection);
        }
    }

    private void transferNodes() {
        this.clearNodes();
        this.nodeMap.clear();
        for (Node node : this.graph.getNodes()) {
            GraphNodeLayout graphNode = new GraphNodeLayout(this, node);
            this.addNode(graphNode);
            this.nodeMap.put(node, graphNode);
        }
    }
}

