/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import com.google.inject.Provider;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.mvc.fx.policies.FXResizePolicy;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.zest.fx.behaviors.AbstractLayoutBehavior;
import org.eclipse.gef4.zest.fx.behaviors.GraphLayoutBehavior;
import org.eclipse.gef4.zest.fx.layout.GraphNodeLayout;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class NodeLayoutBehavior
extends AbstractLayoutBehavior {
    @Override
    protected void adaptFromLayout() {
        NodePart nodePart = this.getHost();
        Node visual = (Node)nodePart.getVisual();
        Bounds layoutBounds = visual.getLayoutBounds();
        Affine transform = (Affine)((Provider)nodePart.getAdapter(FXTransformPolicy.TRANSFORM_PROVIDER_KEY)).get();
        double x = transform.getTx();
        double y = transform.getTy();
        double w = layoutBounds.getWidth();
        double h = layoutBounds.getHeight();
        GraphNodeLayout nodeLayout = this.getNodeLayout();
        Point location = LayoutProperties.getLocation((INodeLayout)nodeLayout);
        Dimension size = LayoutProperties.getSize((INodeLayout)nodeLayout);
        double dx = location.x - size.width / 2.0 - x;
        double dy = location.y - size.height / 2.0 - y;
        double dw = size.width - w;
        double dh = size.height - h;
        FXResizePolicy resizePolicy = (FXResizePolicy)nodePart.getAdapter(FXResizePolicy.class);
        resizePolicy.init();
        resizePolicy.resize(dw, dh);
        ITransactionalOperation resizeOperation = resizePolicy.commit();
        if (resizeOperation != null) {
            try {
                resizeOperation.execute(null, null);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        FXTransformPolicy transformPolicy = (FXTransformPolicy)nodePart.getAdapter(FXTransformPolicy.class);
        transformPolicy.init();
        transformPolicy.setTransform(FX2Geometry.toAffineTransform((Transform)transform).setToTranslation(x + dx, y + dy));
        ITransactionalOperation transformOperation = transformPolicy.commit();
        if (transformOperation != null) {
            try {
                transformOperation.execute(null, null);
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
        nodePart.refreshVisual();
    }

    @Override
    protected GraphLayoutBehavior getGraphLayoutBehavior() {
        IContentPart graphPart = (IContentPart)this.getHost().getRoot().getViewer().getContentPartMap().get(this.getHost().getContent().getGraph());
        return (GraphLayoutBehavior)((Object)graphPart.getAdapter(GraphLayoutBehavior.class));
    }

    public NodePart getHost() {
        return (NodePart)super.getHost();
    }

    protected GraphNodeLayout getNodeLayout() {
        GraphNodeLayout nodeLayout = this.getGraphLayoutBehavior().getGraphLayoutContext().getNodeLayout(this.getHost().getContent());
        if (nodeLayout == null) {
            throw new IllegalStateException("Cannot find INodeLayout in NavigationModel.");
        }
        return nodeLayout;
    }

    @Override
    protected void provideToLayout() {
        Node visual = (Node)this.getHost().getVisual();
        Bounds hostBounds = visual.getLayoutBounds();
        double minx = hostBounds.getMinX();
        double miny = hostBounds.getMinY();
        double maxx = hostBounds.getMaxX();
        double maxy = hostBounds.getMaxY();
        Affine transform = (Affine)((Provider)this.getHost().getAdapter(FXTransformPolicy.TRANSFORM_PROVIDER_KEY)).get();
        GraphNodeLayout nodeLayout = this.getNodeLayout();
        LayoutProperties.setLocation((INodeLayout)nodeLayout, (double)(transform.getTx() + minx), (double)(transform.getTy() + miny));
        LayoutProperties.setSize((INodeLayout)nodeLayout, (double)(maxx - minx), (double)(maxy - miny));
        LayoutProperties.setResizable((INodeLayout)nodeLayout, (boolean)visual.isResizable());
    }
}

