/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.layout.Pane;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.layout.IEdgeLayout;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.ILayoutFilter;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.zest.fx.ZestProperties;
import org.eclipse.gef4.zest.fx.behaviors.AbstractLayoutBehavior;
import org.eclipse.gef4.zest.fx.layout.GraphEdgeLayout;
import org.eclipse.gef4.zest.fx.layout.GraphLayoutContext;
import org.eclipse.gef4.zest.fx.layout.GraphNodeLayout;
import org.eclipse.gef4.zest.fx.models.HidingModel;
import org.eclipse.gef4.zest.fx.models.NavigationModel;
import org.eclipse.gef4.zest.fx.parts.GraphPart;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class GraphLayoutBehavior
extends AbstractLayoutBehavior {
    private MapChangeListener<String, Object> layoutContextAttributesObserver = new MapChangeListener<String, Object>(){

        public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
            if ("layout_bounds".equals(change.getKey()) && change.getMap().get(change.getKey()) != null) {
                GraphLayoutBehavior.this.applyLayout(true);
            }
        }
    };
    private GraphLayoutContext layoutContext;
    private Pane nestingVisual;
    private ChangeListener<? super Bounds> nestingVisualLayoutBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldLayoutBounds, Bounds newLayoutBounds) {
            GraphLayoutBehavior.this.onNestingVisualLayoutBoundsChange(oldLayoutBounds, newLayoutBounds);
        }
    };
    private ChangeListener<? super Bounds> viewportBoundsChangeListener = new ChangeListener<Bounds>(){

        public void changed(ObservableValue<? extends Bounds> observable, Bounds oldLayoutBounds, Bounds newLayoutBounds) {
            GraphLayoutBehavior.this.onViewportModelPropertyChange(oldLayoutBounds, newLayoutBounds);
        }
    };
    private List<Runnable> provideLayoutRunnables = new ArrayList<Runnable>();
    private Runnable provideLayoutRunnable = new Runnable(){

        @Override
        public void run() {
            for (Runnable r : GraphLayoutBehavior.this.provideLayoutRunnables) {
                r.run();
            }
        }
    };
    private List<Runnable> adaptToLayoutRunnables = new ArrayList<Runnable>();
    private Runnable adaptToLayoutRunnable = new Runnable(){

        @Override
        public void run() {
            for (Runnable r : GraphLayoutBehavior.this.adaptToLayoutRunnables) {
                r.run();
            }
        }
    };
    private List<Runnable> updateLabelsRunnables = new ArrayList<Runnable>();
    private Runnable updateLabelsRunnable = new Runnable(){

        @Override
        public void run() {
            for (Runnable r : GraphLayoutBehavior.this.updateLabelsRunnables) {
                r.run();
            }
        }
    };

    @Override
    protected void adaptFromLayout() {
    }

    public void applyLayout(boolean clean) {
        InfiniteCanvas canvas = ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas();
        Rectangle bounds = LayoutProperties.getBounds((ILayoutContext)this.layoutContext);
        ((NavigationModel)this.getHost().getRoot().getViewer().getAdapter(NavigationModel.class)).setViewportState(this.layoutContext.getGraph(), new NavigationModel.ViewportState(0.0, 0.0, bounds.getWidth(), bounds.getHeight(), FX2Geometry.toAffineTransform((Transform)canvas.getContentTransform())));
        Object layoutAlgorithmValue = this.getHost().getContent().attributesProperty().get((Object)"layout");
        if (layoutAlgorithmValue != null) {
            ILayoutAlgorithm layoutAlgorithm = (ILayoutAlgorithm)layoutAlgorithmValue;
            if (this.layoutContext.getLayoutAlgorithm() == null) {
                this.layoutContext.setLayoutAlgorithm(layoutAlgorithm);
            }
        } else if (this.layoutContext.getLayoutAlgorithm() != null) {
            this.layoutContext.setLayoutAlgorithm(null);
        }
        this.layoutContext.applyLayout(true);
        this.layoutContext.flushChanges();
    }

    @Override
    protected void doActivate() {
        Rectangle initialBounds = new Rectangle();
        if (this.getHost().getParent() == this.getHost().getRoot()) {
            this.getInfiniteCanvas().scrollableBoundsProperty().addListener(this.viewportBoundsChangeListener);
            FXViewer fxViewer = (FXViewer)this.getHost().getRoot().getViewer();
            initialBounds.setX(0.0);
            initialBounds.setY(0.0);
            initialBounds.setWidth(fxViewer.getCanvas().getWidth());
            initialBounds.setHeight(fxViewer.getCanvas().getHeight());
        } else if (this.getHost().getContent().getNestingNode() != null) {
            this.nestingVisual = this.getNestingPart().getNestedChildrenPane();
            this.nestingVisual.layoutBoundsProperty().addListener(this.nestingVisualLayoutBoundsChangeListener);
            Bounds layoutBounds = this.nestingVisual.getLayoutBounds();
            initialBounds.setWidth(layoutBounds.getWidth() / 0.25);
            initialBounds.setHeight(layoutBounds.getHeight() / 0.25);
        } else {
            throw new IllegalStateException("Graph is neither nested nor root?!");
        }
        this.layoutContext = this.getGraphLayoutContext();
        final HidingModel hidingModel = (HidingModel)this.getHost().getRoot().getViewer().getAdapter(HidingModel.class);
        this.layoutContext.addLayoutFilter(new ILayoutFilter(){

            public boolean isLayoutIrrelevant(IEdgeLayout connectionLayout) {
                return ZestProperties.getLayoutIrrelevant(((GraphEdgeLayout)connectionLayout).getEdge(), true) != false || this.isLayoutIrrelevant(connectionLayout.getSource()) || this.isLayoutIrrelevant(connectionLayout.getTarget());
            }

            public boolean isLayoutIrrelevant(INodeLayout nodeLayout) {
                Node node = ((GraphNodeLayout)nodeLayout).getNode();
                return ZestProperties.getLayoutIrrelevant(node, true) != false || hidingModel.isHidden(node);
            }
        });
        LayoutProperties.setBounds((ILayoutContext)this.layoutContext, (Rectangle)initialBounds);
        this.layoutContext.attributesProperty().addListener(this.layoutContextAttributesObserver);
        this.layoutContext.schedulePreLayoutPass(this.provideLayoutRunnable);
        this.layoutContext.schedulePostLayoutPass(this.adaptToLayoutRunnable);
        this.layoutContext.schedulePostLayoutPass(this.updateLabelsRunnable);
    }

    @Override
    protected void doDeactivate() {
        if (this.layoutContext != null) {
            this.layoutContext.attributesProperty().removeListener(this.layoutContextAttributesObserver);
        }
        if (this.nestingVisual == null) {
            this.getInfiniteCanvas().scrollableBoundsProperty().removeListener(this.viewportBoundsChangeListener);
        } else {
            this.nestingVisual.layoutBoundsProperty().removeListener(this.nestingVisualLayoutBoundsChangeListener);
        }
        this.layoutContext.unschedulePreLayoutPass(this.provideLayoutRunnable);
        this.layoutContext.unschedulePostLayoutPass(this.adaptToLayoutRunnable);
        this.layoutContext.unschedulePostLayoutPass(this.updateLabelsRunnable);
        this.layoutContext = null;
        this.nestingVisual = null;
    }

    @Override
    protected GraphLayoutBehavior getGraphLayoutBehavior() {
        return this;
    }

    protected GraphLayoutContext getGraphLayoutContext() {
        return (GraphLayoutContext)((Object)this.getHost().getAdapter(GraphLayoutContext.class));
    }

    public GraphPart getHost() {
        return (GraphPart)super.getHost();
    }

    protected InfiniteCanvas getInfiniteCanvas() {
        return ((FXViewer)this.getHost().getRoot().getViewer()).getCanvas();
    }

    protected NodePart getNestingPart() {
        Node nestingNode = this.getHost().getContent().getNestingNode();
        IContentPart nestingNodePart = (IContentPart)this.getHost().getRoot().getViewer().getContentPartMap().get(nestingNode);
        return (NodePart)nestingNodePart;
    }

    protected void onNestingVisualLayoutBoundsChange(Bounds oldLayoutBounds, Bounds newLayoutBounds) {
        double width = newLayoutBounds.getWidth() / 0.25;
        double height = newLayoutBounds.getHeight() / 0.25;
        Rectangle newBounds = new Rectangle(0.0, 0.0, width, height);
        LayoutProperties.setBounds((ILayoutContext)this.layoutContext, (Rectangle)newBounds);
    }

    protected void onViewportModelPropertyChange(Bounds oldScrollableBounds, Bounds newScrollableBounds) {
        InfiniteCanvas canvas = this.getInfiniteCanvas();
        Rectangle newBounds = new Rectangle(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        LayoutProperties.setBounds((ILayoutContext)this.layoutContext, (Rectangle)newBounds);
    }

    @Override
    protected void provideToLayout() {
    }

    public void scheduleAdaptToLayout(Runnable adaptToLayout) {
        this.adaptToLayoutRunnables.add(adaptToLayout);
    }

    public void schedulePostLayoutPass(Runnable updateLabels) {
        this.updateLabelsRunnables.add(updateLabels);
    }

    public void scheduleProvideLayout(Runnable provideLayout) {
        this.provideLayoutRunnables.add(provideLayout);
    }

    public void unscheduleAdaptToLayout(Runnable adaptToLayout) {
        this.adaptToLayoutRunnables.remove(adaptToLayout);
    }

    public void unschedulePostLayoutPass(Runnable updateLabels) {
        this.updateLabelsRunnables.remove(updateLabels);
    }

    public void unscheduleProvideLayout(Runnable provideLayout) {
        this.provideLayoutRunnables.remove(provideLayout);
    }
}

