/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import javafx.scene.Node;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.behaviors.GraphLayoutBehavior;
import org.eclipse.gef4.zest.fx.parts.AbstractLabelPart;

public abstract class AbstractLayoutBehavior
extends AbstractBehavior<Node> {
    private Runnable adaptToLayout = new Runnable(){

        @Override
        public void run() {
            AbstractLayoutBehavior.this.adaptFromLayout();
        }
    };
    private Runnable provideLayout = new Runnable(){

        @Override
        public void run() {
            AbstractLayoutBehavior.this.provideToLayout();
        }
    };
    private Runnable updateLabels = new Runnable(){

        @Override
        public void run() {
            AbstractLayoutBehavior.this.updateLabels();
        }
    };

    protected abstract void adaptFromLayout();

    protected void doActivate() {
        GraphLayoutBehavior layoutBehavior = this.getGraphLayoutBehavior();
        layoutBehavior.scheduleProvideLayout(this.provideLayout);
        layoutBehavior.scheduleAdaptToLayout(this.adaptToLayout);
        layoutBehavior.schedulePostLayoutPass(this.updateLabels);
    }

    protected void doDeactivate() {
        GraphLayoutBehavior layoutBehavior = this.getGraphLayoutBehavior();
        layoutBehavior.unscheduleProvideLayout(this.provideLayout);
        layoutBehavior.unscheduleAdaptToLayout(this.adaptToLayout);
        layoutBehavior.unschedulePostLayoutPass(this.updateLabels);
    }

    protected abstract GraphLayoutBehavior getGraphLayoutBehavior();

    protected abstract void provideToLayout();

    protected void updateLabels() {
        for (IVisualPart anchored : this.getHost().getAnchoredsUnmodifiable().elementSet()) {
            if (!(anchored instanceof AbstractLabelPart)) continue;
            AbstractLabelPart labelPart = (AbstractLabelPart)anchored;
            Point computedPosition = labelPart.computeLabelPosition();
            labelPart.setStoredLabelPosition(computedPosition);
            labelPart.refreshVisual();
        }
    }
}

