/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.parts;

import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef4.mvc.behaviors.ContentBehavior;
import org.eclipse.gef4.mvc.parts.AbstractVisualPart;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IFeedbackPart;
import org.eclipse.gef4.mvc.parts.IHandlePart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.parts.PartUtils;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractRootPart<VR, V extends VR>
extends AbstractVisualPart<VR, V>
implements IRootPart<VR, V> {
    private IViewer<VR> viewer;

    @Override
    protected void activateChildren() {
        for (IVisualPart<VR, Object> child : this.getContentPartChildren()) {
            child.activate();
        }
        for (IVisualPart<VR, Object> child : this.getChildrenUnmodifiable()) {
            if (child instanceof IContentPart) continue;
            child.activate();
        }
    }

    @Override
    protected void attachToAnchorageVisual(IVisualPart<VR, ? extends VR> anchorage, String role) {
        throw new UnsupportedOperationException("IRootVisualPart does not support this");
    }

    @Override
    protected void deactivateChildren() {
        for (IVisualPart<VR, Object> child : this.getContentPartChildren()) {
            child.deactivate();
        }
        for (IVisualPart<VR, Object> child : this.getChildrenUnmodifiable()) {
            if (child instanceof IContentPart) continue;
            child.deactivate();
        }
    }

    @Override
    protected void detachFromAnchorageVisual(IVisualPart<VR, ? extends VR> anchorage, String role) {
        throw new UnsupportedOperationException("IRootVisualPart does not support this");
    }

    public IViewer<VR> getAdaptable() {
        return this.getViewer();
    }

    @Override
    public List<IContentPart<VR, ? extends VR>> getContentPartChildren() {
        return PartUtils.filterParts(this.getChildrenUnmodifiable(), IContentPart.class);
    }

    @Override
    public List<IFeedbackPart<VR, ? extends VR>> getFeedbackPartChildren() {
        return PartUtils.filterParts(this.getChildrenUnmodifiable(), IFeedbackPart.class);
    }

    @Override
    public List<IHandlePart<VR, ? extends VR>> getHandlePartChildren() {
        return PartUtils.filterParts(this.getChildrenUnmodifiable(), IHandlePart.class);
    }

    @Override
    public IRootPart<VR, ? extends VR> getRoot() {
        return this;
    }

    @Override
    public IViewer<VR> getViewer() {
        return this.viewer;
    }

    public void setAdaptable(IViewer<VR> viewer) {
        IViewer<VR> oldViewer = this.viewer;
        if (oldViewer != null && viewer != oldViewer) {
            this.unregister(oldViewer);
        }
        this.viewer = viewer;
        if (viewer != null && viewer != oldViewer) {
            this.register(viewer);
        }
    }

    @Override
    protected void unregister(IViewer<VR> viewer) {
        ContentBehavior contentBehavior = (ContentBehavior)this.getAdapter(new TypeToken<ContentBehavior<VR>>(this.getClass()){});
        if (contentBehavior != null) {
            contentBehavior.synchronizeContentChildren(Collections.emptyList());
        }
        super.unregister(viewer);
    }
}

