/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.examples;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Collections;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.gef4.mvc.fx.domain.FXDomain;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.zest.fx.ZestFxModule;

public abstract class AbstractZestExample
extends Application {
    private static int id = 0;
    protected static final String ID = "css-id";
    protected static final String LABEL = "label";
    protected static final String CSS_CLASS = "css-class";
    protected static final String LAYOUT_IRRELEVANT = "element-layout-irrelevant";
    private String title;
    protected FXDomain domain;
    protected FXViewer viewer;
    protected Graph graph;

    protected static String genId() {
        return Integer.toString(id++);
    }

    protected static Edge e(Node n, Node m, Object ... attr) {
        String label = String.valueOf((String)n.attributesProperty().get((Object)LABEL)) + (String)m.attributesProperty().get((Object)LABEL);
        Edge.Builder builder = new Edge.Builder(n, m).attr(LABEL, (Object)label).attr(ID, (Object)AbstractZestExample.genId());
        int i = 0;
        while (i < attr.length) {
            builder.attr(attr[i].toString(), attr[i + 1]);
            i += 2;
        }
        return builder.buildEdge();
    }

    protected static Edge e(Graph graph, Node n, Node m, Object ... attr) {
        Edge edge = AbstractZestExample.e(n, m, attr);
        edge.setGraph(graph);
        graph.getEdges().add((Object)edge);
        return edge;
    }

    protected static Node n(Object ... attr) {
        Node.Builder builder = new Node.Builder();
        String id = AbstractZestExample.genId();
        builder.attr(ID, (Object)id).attr(LABEL, (Object)id);
        int i = 0;
        while (i < attr.length) {
            builder.attr(attr[i].toString(), attr[i + 1]);
            i += 2;
        }
        return builder.buildNode();
    }

    protected static Node n(Graph graph, Object ... attr) {
        Node node = AbstractZestExample.n(attr);
        node.setGraph(graph);
        graph.getNodes().add((Object)node);
        return node;
    }

    public AbstractZestExample(String title) {
        this.title = title;
    }

    protected abstract Graph createGraph();

    public void start(Stage primaryStage) throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{this.createModule()});
        this.domain = (FXDomain)injector.getInstance(FXDomain.class);
        this.viewer = (FXViewer)this.domain.getAdapter(FXViewer.class);
        primaryStage.setScene(this.createScene(this.viewer));
        primaryStage.setResizable(true);
        primaryStage.setWidth((double)this.getStageWidth());
        primaryStage.setHeight((double)this.getStageHeight());
        primaryStage.setTitle(this.title);
        primaryStage.show();
        this.domain.activate();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractZestExample.this.graph = AbstractZestExample.this.createGraph();
                ((ContentModel)AbstractZestExample.this.viewer.getAdapter(ContentModel.class)).getContents().setAll(Collections.singletonList(AbstractZestExample.this.graph));
            }
        });
    }

    protected Scene createScene(FXViewer viewer) {
        return new Scene((Parent)viewer.getCanvas());
    }

    protected int getStageHeight() {
        return 480;
    }

    protected int getStageWidth() {
        return 640;
    }

    protected Module createModule() {
        return new ZestFxModule();
    }
}

