/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.LayoutProperties;
import org.eclipse.gef4.layout.algorithms.TreeLayoutObserver;

public class SpaceTreeLayoutAlgorithm
implements ILayoutAlgorithm {
    public static final int TOP_DOWN = 1;
    public static final int BOTTOM_UP = 2;
    public static final int LEFT_RIGHT = 3;
    public static final int RIGHT_LEFT = 4;
    private TreeLayoutObserver.TreeNodeFactory spaceTreeNodeFactory = new TreeLayoutObserver.TreeNodeFactory(){

        @Override
        public TreeLayoutObserver.TreeNode createTreeNode(INodeLayout nodeLayout, TreeLayoutObserver observer) {
            return new SpaceTreeNode(nodeLayout, observer);
        }
    };
    private int direction = 1;
    private double leafGap = 15.0;
    private double branchGap = this.leafGap + 5.0;
    private double layerGap = 20.0;
    private ILayoutContext context;
    private TreeLayoutObserver treeObserver;
    private double availableSpace;
    private ArrayList<SpaceTreeLayer> spaceTreeLayers = new ArrayList();
    private SpaceTreeNode protectedNode = null;

    public void setLeafGap(double value) {
        this.leafGap = value;
    }

    public void setBranchGap(double value) {
        this.branchGap = value;
    }

    public void setLayerGap(double value) {
        this.layerGap = value;
    }

    public double getLeafGap() {
        return this.leafGap;
    }

    public double getBranchGap() {
        return this.branchGap;
    }

    public double getLayerGap() {
        return this.layerGap;
    }

    public SpaceTreeLayoutAlgorithm() {
    }

    public SpaceTreeLayoutAlgorithm(int direction) {
        this.setDirection(direction);
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (direction == this.direction) {
            return;
        }
        if (direction != 1 && direction != 2 && direction != 3 && direction != 4) {
            throw new IllegalArgumentException("Invalid direction: " + direction);
        }
        this.direction = direction;
    }

    @Override
    public void applyLayout(boolean clean) {
        Rectangle bounds = LayoutProperties.getBounds(this.context);
        if (bounds.isEmpty()) {
            return;
        }
        if (clean) {
            this.treeObserver.recomputeTree();
            this.maximizeExpansion((SpaceTreeNode)this.treeObserver.getSuperRoot());
        }
        SpaceTreeNode superRoot = (SpaceTreeNode)this.treeObserver.getSuperRoot();
        superRoot.flushExpansionChanges();
        superRoot.flushLocationChanges(0.0);
    }

    private void maximizeExpansion(SpaceTreeNode nodeToExpand) {
        this.protectedNode = nodeToExpand;
        double availableSpace = this.getAvailableSpace();
        double requiredSpace = 0.0;
        this.spaceTreeLayers.get(nodeToExpand.depth + 1).removeNodes(nodeToExpand.children);
        ArrayList<TreeLayoutObserver.TreeNode> nodesInThisLayer = null;
        ArrayList<TreeLayoutObserver.TreeNode> nodesInNextLayer = new ArrayList<TreeLayoutObserver.TreeNode>();
        nodesInNextLayer.add(nodeToExpand);
        double spaceRequiredInNextLayer = nodeToExpand.spaceRequiredForNode();
        int layer = 0;
        while (!nodesInNextLayer.isEmpty()) {
            NodeSnapshot[][] snapShot = this.takeSnapShot();
            requiredSpace = Math.max(requiredSpace, spaceRequiredInNextLayer);
            spaceRequiredInNextLayer = 0.0;
            nodesInThisLayer = nodesInNextLayer;
            nodesInNextLayer = new ArrayList();
            int numOfNodesWithChildren = 0;
            for (SpaceTreeNode spaceTreeNode : nodesInThisLayer) {
                if (spaceTreeNode.children.isEmpty()) continue;
                spaceTreeNode.expanded = true;
                spaceRequiredInNextLayer += spaceTreeNode.spaceRequiredForChildren();
                nodesInNextLayer.addAll(spaceTreeNode.children);
                ++numOfNodesWithChildren;
            }
            for (SpaceTreeNode spaceTreeNode : nodesInNextLayer) {
                spaceTreeNode.expanded = false;
            }
            if (numOfNodesWithChildren == 0) break;
            boolean addedNewLayer = false;
            if (((spaceRequiredInNextLayer += this.branchGap * (double)(numOfNodesWithChildren - 1)) <= requiredSpace || spaceRequiredInNextLayer <= availableSpace || layer < 1 && nodeToExpand.depth + layer < 1) && !nodesInNextLayer.isEmpty()) {
                SpaceTreeLayer spaceTreeLayer = this.spaceTreeLayers.get(nodeToExpand.depth + layer + 1);
                spaceTreeLayer.addNodes(nodesInNextLayer);
                SpaceTreeNode firstChild = (SpaceTreeNode)nodesInNextLayer.get(0);
                SpaceTreeNode lastChild = (SpaceTreeNode)nodesInNextLayer.get(nodesInNextLayer.size() - 1);
                double boundsWidth = spaceRequiredInNextLayer - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                double startPosition = Math.max((availableSpace - boundsWidth) / 2.0, firstChild.spaceRequiredForNode() / 2.0);
                this.setAvailableSpace(spaceRequiredInNextLayer);
                spaceTreeLayer.fitNodesWithinBounds(nodesInNextLayer, startPosition, startPosition + boundsWidth);
                this.setAvailableSpace(0.0);
                if (nodeToExpand.childrenPositionsOK(nodesInThisLayer) || layer == 0 || nodeToExpand.depth + layer < 1) {
                    addedNewLayer = true;
                }
            }
            if (!addedNewLayer) {
                this.revertToSnapshot(snapShot);
                break;
            }
            ++layer;
        }
        nodeToExpand.centerParentsBottomUp();
        nodeToExpand.centerParentsTopDown();
    }

    @Override
    public void setLayoutContext(ILayoutContext context) {
        if (this.context != null) {
            this.treeObserver.stop();
        }
        this.context = context;
        this.treeObserver = new TreeLayoutObserver(context, this.spaceTreeNodeFactory);
    }

    @Override
    public ILayoutContext getLayoutContext() {
        return this.context;
    }

    private double getAvailableSpace() {
        Rectangle bounds = LayoutProperties.getBounds(this.context);
        double result = this.direction == 1 || this.direction == 2 ? bounds.getWidth() : bounds.getHeight();
        result = Math.max(result, this.availableSpace);
        for (SpaceTreeLayer layer : this.spaceTreeLayers) {
            if (layer.nodes.isEmpty()) break;
            SpaceTreeNode first = layer.nodes.get(0);
            SpaceTreeNode last = layer.nodes.get(layer.nodes.size() - 1);
            result = Math.max(result, last.positionInLayer - first.positionInLayer + (first.spaceRequiredForNode() + last.spaceRequiredForNode()) / 2.0);
        }
        return result;
    }

    private void setAvailableSpace(double availableSpace) {
        this.availableSpace = availableSpace;
    }

    private double expectedDistance(SpaceTreeNode node, SpaceTreeNode neighbor) {
        double expectedDistance = (node.spaceRequiredForNode() + neighbor.spaceRequiredForNode()) / 2.0;
        return expectedDistance += node.parent == neighbor.parent ? this.leafGap : this.branchGap;
    }

    private NodeSnapshot[][] takeSnapShot() {
        NodeSnapshot[][] result = new NodeSnapshot[this.spaceTreeLayers.size()][];
        int i = 0;
        while (i < result.length) {
            SpaceTreeLayer layer = this.spaceTreeLayers.get(i);
            result[i] = new NodeSnapshot[layer.nodes.size()];
            int j = 0;
            while (j < result[i].length) {
                result[i][j] = new NodeSnapshot();
                result[i][j].node = layer.nodes.get(j);
                result[i][j].position = result[i][j].node.positionInLayer;
                result[i][j].expanded = result[i][j].node.expanded;
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void revertToSnapshot(NodeSnapshot[][] snapShot) {
        int i = 0;
        while (i < snapShot.length) {
            SpaceTreeLayer layer = this.spaceTreeLayers.get(i);
            layer.nodes.clear();
            int j = 0;
            while (j < snapShot[i].length) {
                snapShot[i][j].node.positionInLayer = snapShot[i][j].position;
                snapShot[i][j].node.expanded = snapShot[i][j].expanded;
                layer.nodes.add(snapShot[i][j].node);
                ++j;
            }
            ++i;
        }
    }

    private class NodeSnapshot {
        SpaceTreeNode node;
        double position;
        boolean expanded;

        private NodeSnapshot() {
        }
    }

    private class SpaceTreeLayer {
        public ArrayList<SpaceTreeNode> nodes = new ArrayList();
        private final int depth;
        public double thickness = 0.0;

        public SpaceTreeLayer(int depth) {
            this.depth = depth;
        }

        public void addNodes(List<TreeLayoutObserver.TreeNode> nodesToAdd) {
            ListIterator<SpaceTreeNode> layerIterator = this.nodes.listIterator();
            SpaceTreeNode previousNode = null;
            for (SpaceTreeNode spaceTreeNode : nodesToAdd) {
                SpaceTreeNode nodeInLayer = null;
                while (layerIterator.hasNext()) {
                    nodeInLayer = layerIterator.next();
                    if (nodeInLayer.order >= spaceTreeNode.order) break;
                    double expectedPostion = previousNode == null ? 0.0 : previousNode.positionInLayer + SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nodeInLayer);
                    nodeInLayer.positionInLayer = Math.max(nodeInLayer.positionInLayer, expectedPostion);
                    previousNode = nodeInLayer;
                }
                if (nodeInLayer == null) {
                    layerIterator.add(spaceTreeNode);
                } else if (nodeInLayer.order == spaceTreeNode.order) {
                    layerIterator.set(spaceTreeNode);
                } else {
                    if (nodeInLayer.order > spaceTreeNode.order) {
                        layerIterator.previous();
                    }
                    layerIterator.add(spaceTreeNode);
                }
                layerIterator.previous();
            }
            while (layerIterator.hasNext()) {
                SpaceTreeNode nodeInLayer = layerIterator.next();
                double d = previousNode == null ? 0.0 : previousNode.positionInLayer + SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nodeInLayer);
                nodeInLayer.positionInLayer = Math.max(nodeInLayer.positionInLayer, d);
                previousNode = nodeInLayer;
            }
            this.refreshThickness();
        }

        public void removeNode(SpaceTreeNode node) {
            if (this.nodes.remove(node)) {
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1)).removeNodes(node.children);
                this.refreshThickness();
            }
        }

        public void removeNodes(List<TreeLayoutObserver.TreeNode> nodesToRemove) {
            if (this.nodes.removeAll(nodesToRemove)) {
                SpaceTreeLayer nextLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                for (SpaceTreeNode spaceTreeNode : nodesToRemove) {
                    nextLayer.removeNodes(spaceTreeNode.children);
                }
                this.refreshThickness();
            }
        }

        public void checkThickness(SpaceTreeNode node) {
            double nodeThickness = 0.0;
            Dimension size = LayoutProperties.getSize(node.node);
            nodeThickness = SpaceTreeLayoutAlgorithm.this.direction == 1 || SpaceTreeLayoutAlgorithm.this.direction == 2 ? size.height : size.width;
            this.thickness = Math.max(this.thickness, nodeThickness);
        }

        public void refreshThickness() {
            this.thickness = 0.0;
            Iterator<SpaceTreeNode> iterator = this.nodes.iterator();
            while (iterator.hasNext()) {
                this.checkThickness(iterator.next());
            }
        }

        public void fitNodesWithinBounds(List<TreeLayoutObserver.TreeNode> nodeList, double startPosition, double endPosition) {
            double expectedDistance;
            SpaceTreeNode previousNode;
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            SpaceTreeNode[] nodes = nodeList.toArray(new SpaceTreeNode[nodeList.size()]);
            double initialStartPosition = nodes[0].positionInLayer;
            double initialNodesBredth = nodes[nodes.length - 1].positionInLayer - initialStartPosition;
            double[] desiredPositions = new double[nodes.length];
            int i = 0;
            while (i < nodes.length) {
                double initialPositionAsPercent = initialNodesBredth > 0.0 ? (nodes[i].positionInLayer - initialStartPosition) / initialNodesBredth : 0.0;
                desiredPositions[i] = initialPositionAsPercent * (endPosition - startPosition);
                ++i;
            }
            i = 1;
            while (i < nodes.length) {
                previousNode = nodes[i - 1];
                SpaceTreeNode node = nodes[i];
                expectedDistance = SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, node);
                if (desiredPositions[i] - desiredPositions[i - 1] < expectedDistance) {
                    desiredPositions[i] = desiredPositions[i - 1] + expectedDistance;
                }
                ++i;
            }
            if (desiredPositions[nodes.length - 1] > endPosition - startPosition) {
                desiredPositions[nodes.length - 1] = endPosition - startPosition;
                i = nodes.length - 1;
                while (i > 0) {
                    previousNode = nodes[i - 1];
                    SpaceTreeNode node = nodes[i];
                    expectedDistance = SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, node);
                    if (!(desiredPositions[i] - desiredPositions[i - 1] < expectedDistance)) break;
                    desiredPositions[i - 1] = desiredPositions[i] - expectedDistance;
                    --i;
                }
            }
            i = 0;
            while (i < nodeList.size()) {
                SpaceTreeNode node = (SpaceTreeNode)nodeList.get(i);
                double desiredPosition = startPosition + desiredPositions[i];
                this.moveNode(node, desiredPosition);
                if (Math.abs(node.positionInLayer - desiredPosition) > 0.5) {
                    startPosition += node.positionInLayer - desiredPosition;
                    i = -1;
                    SpaceTreeLayoutAlgorithm.this.revertToSnapshot(snapShot);
                }
                ++i;
            }
        }

        public void moveNode(SpaceTreeNode node, double newPosition) {
            Collections.sort(this.nodes, new Comparator<SpaceTreeNode>(){

                @Override
                public int compare(SpaceTreeNode arg0, SpaceTreeNode arg1) {
                    return arg0.order - arg1.order;
                }
            });
            double positionInLayerAtStart = node.positionInLayer;
            if (newPosition >= positionInLayerAtStart) {
                this.moveNodeForward(node, newPosition);
            }
            if (newPosition <= positionInLayerAtStart) {
                this.moveNodeBackward(node, newPosition);
            }
        }

        private void moveNodeForward(SpaceTreeNode nodeToMove, double newPosition) {
            int nodeIndex = this.nodes.indexOf(nodeToMove);
            if (nodeIndex == -1) {
                throw new IllegalArgumentException("node not on this layer");
            }
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            boolean firstRun = true;
            block0: while (firstRun || nodeToMove.positionInLayer < newPosition) {
                firstRun = false;
                double requiredSpace = 0.0;
                SpaceTreeNode previousNode = nodeToMove;
                int i = nodeIndex + 1;
                while (i < this.nodes.size()) {
                    SpaceTreeNode nextNode = this.nodes.get(i);
                    requiredSpace += SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nextNode);
                    previousNode = nextNode;
                    ++i;
                }
                if ((requiredSpace += previousNode.spaceRequiredForNode() / 2.0) > SpaceTreeLayoutAlgorithm.this.getAvailableSpace() - newPosition) {
                    boolean removed = false;
                    int i2 = nodeIndex;
                    while (i2 < this.nodes.size()) {
                        SpaceTreeNode nextNode = this.nodes.get(i2);
                        if (SpaceTreeLayoutAlgorithm.this.protectedNode == null || !SpaceTreeLayoutAlgorithm.this.protectedNode.isAncestorOf(nextNode) && !nextNode.parent.isAncestorOf(SpaceTreeLayoutAlgorithm.this.protectedNode)) {
                            this.collapseNode((SpaceTreeNode)nextNode.parent);
                            if (nextNode.parent == nodeToMove.parent) break block0;
                            removed = true;
                            break;
                        }
                        ++i2;
                    }
                    if (!removed) {
                        newPosition = SpaceTreeLayoutAlgorithm.this.getAvailableSpace() - requiredSpace;
                        SpaceTreeLayoutAlgorithm.this.revertToSnapshot(snapShot);
                        continue;
                    }
                }
                SpaceTreeNode currentNodeToMove = nodeToMove;
                double newPositionForCurrent = newPosition;
                int i3 = nodeIndex;
                while (i3 < this.nodes.size()) {
                    currentNodeToMove.positionInLayer = newPositionForCurrent;
                    if (currentNodeToMove.firstChild) {
                        SpaceTreeNode parent = (SpaceTreeNode)currentNodeToMove.parent;
                        if (this.depth > 0 && parent.positionInLayer <= newPositionForCurrent) {
                            SpaceTreeLayer parentLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth - 1);
                            parentLayer.moveNodeForward(parent, newPositionForCurrent);
                            if (parent.positionInLayer < newPositionForCurrent) {
                                double delta = newPositionForCurrent - parent.positionInLayer;
                                newPosition -= delta;
                                SpaceTreeLayoutAlgorithm.this.revertToSnapshot(snapShot);
                                continue block0;
                            }
                        }
                    }
                    if (currentNodeToMove.expanded && !currentNodeToMove.children.isEmpty()) {
                        SpaceTreeNode lastChild = (SpaceTreeNode)currentNodeToMove.children.get(currentNodeToMove.children.size() - 1);
                        if (lastChild.positionInLayer < newPositionForCurrent) {
                            SpaceTreeNode firstChild = (SpaceTreeNode)currentNodeToMove.children.get(0);
                            SpaceTreeLayer childLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                            double expectedDistanceBetweenChildren = currentNodeToMove.spaceRequiredForChildren() - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                            childLayer.moveNodeForward(firstChild, newPositionForCurrent - expectedDistanceBetweenChildren);
                            if (currentNodeToMove.expanded && lastChild.positionInLayer < newPositionForCurrent) {
                                childLayer.moveNodeForward(lastChild, newPositionForCurrent);
                                if (lastChild.positionInLayer < newPositionForCurrent) {
                                    double delta = newPositionForCurrent - lastChild.positionInLayer;
                                    newPosition -= delta;
                                    SpaceTreeLayoutAlgorithm.this.revertToSnapshot(snapShot);
                                    continue block0;
                                }
                            }
                        }
                    }
                    if (i3 < this.nodes.size() - 1) {
                        SpaceTreeNode nextNode = this.nodes.get(i3 + 1);
                        currentNodeToMove = nextNode;
                        if (currentNodeToMove.positionInLayer > (newPositionForCurrent += SpaceTreeLayoutAlgorithm.this.expectedDistance(currentNodeToMove, nextNode))) continue block0;
                    }
                    ++i3;
                }
            }
        }

        private void moveNodeBackward(SpaceTreeNode nodeToMove, double newPosition) {
            int nodeIndex = this.nodes.indexOf(nodeToMove);
            if (nodeIndex == -1) {
                throw new IllegalArgumentException("node not on this layer");
            }
            NodeSnapshot[][] snapShot = SpaceTreeLayoutAlgorithm.this.takeSnapShot();
            boolean firstRun = true;
            block0: while (firstRun || nodeToMove.positionInLayer > newPosition) {
                firstRun = false;
                double requiredSpace = 0.0;
                SpaceTreeNode previousNode = nodeToMove;
                int i = nodeIndex - 1;
                while (i >= 0) {
                    SpaceTreeNode nextNode = this.nodes.get(i);
                    requiredSpace += SpaceTreeLayoutAlgorithm.this.expectedDistance(previousNode, nextNode);
                    previousNode = nextNode;
                    --i;
                }
                if ((requiredSpace += previousNode.spaceRequiredForNode() / 2.0) > newPosition) {
                    boolean removed = false;
                    int i2 = nodeIndex;
                    while (i2 >= 0) {
                        SpaceTreeNode nextNode = this.nodes.get(i2);
                        if (SpaceTreeLayoutAlgorithm.this.protectedNode == null || !SpaceTreeLayoutAlgorithm.this.protectedNode.isAncestorOf(nextNode) && !nextNode.parent.isAncestorOf(SpaceTreeLayoutAlgorithm.this.protectedNode)) {
                            this.collapseNode((SpaceTreeNode)nextNode.parent);
                            if (nextNode.parent == nodeToMove.parent) break block0;
                            nodeIndex -= nextNode.parent.children.size();
                            removed = true;
                            break;
                        }
                        --i2;
                    }
                    if (!removed) {
                        newPosition = requiredSpace;
                        SpaceTreeLayoutAlgorithm.this.revertToSnapshot(snapShot);
                        continue;
                    }
                }
                SpaceTreeNode currentNodeToMove = nodeToMove;
                double newPositionForCurrent = newPosition;
                int i3 = nodeIndex;
                while (i3 >= 0) {
                    currentNodeToMove.positionInLayer = newPositionForCurrent;
                    if (currentNodeToMove.lastChild) {
                        SpaceTreeNode parent = (SpaceTreeNode)currentNodeToMove.parent;
                        if (this.depth > 0 && parent.positionInLayer >= newPositionForCurrent) {
                            SpaceTreeLayer parentLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth - 1);
                            parentLayer.moveNodeBackward(parent, newPositionForCurrent);
                            if (parent.positionInLayer > newPositionForCurrent) {
                                double delta = parent.positionInLayer - newPositionForCurrent;
                                newPosition += delta;
                                SpaceTreeLayoutAlgorithm.this.revertToSnapshot(snapShot);
                                continue block0;
                            }
                        }
                    }
                    if (currentNodeToMove.expanded && !currentNodeToMove.children.isEmpty()) {
                        SpaceTreeNode firstChild = (SpaceTreeNode)currentNodeToMove.children.get(0);
                        if (firstChild.positionInLayer > newPositionForCurrent) {
                            SpaceTreeNode lastChild = (SpaceTreeNode)currentNodeToMove.children.get(currentNodeToMove.children.size() - 1);
                            SpaceTreeLayer childLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                            double expectedDistanceBetweenChildren = currentNodeToMove.spaceRequiredForChildren() - firstChild.spaceRequiredForNode() / 2.0 - lastChild.spaceRequiredForNode() / 2.0;
                            childLayer.moveNodeBackward(lastChild, newPositionForCurrent + expectedDistanceBetweenChildren);
                            if (currentNodeToMove.expanded && firstChild.positionInLayer > newPositionForCurrent) {
                                childLayer.moveNodeBackward(firstChild, newPositionForCurrent);
                                if (firstChild.positionInLayer > newPositionForCurrent) {
                                    double delta = firstChild.positionInLayer - newPositionForCurrent;
                                    newPosition += delta;
                                    SpaceTreeLayoutAlgorithm.this.revertToSnapshot(snapShot);
                                    continue block0;
                                }
                            }
                        }
                    }
                    if (i3 > 0) {
                        SpaceTreeNode nextNode = this.nodes.get(i3 - 1);
                        currentNodeToMove = nextNode;
                        if (currentNodeToMove.positionInLayer < (newPositionForCurrent -= SpaceTreeLayoutAlgorithm.this.expectedDistance(currentNodeToMove, nextNode))) continue block0;
                    }
                    --i3;
                }
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Layer ").append(this.depth).append(": ");
            for (SpaceTreeNode node : this.nodes) {
                buffer.append(node.node).append(", ");
            }
            return buffer.toString();
        }

        private void collapseNode(SpaceTreeNode node) {
            node.expanded = false;
            SpaceTreeLayer layer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(node.depth + 1);
            layer.removeNodes(node.children);
            for (SpaceTreeNode child : node.children) {
                if (!child.expanded) continue;
                this.collapseNode(child);
            }
        }
    }

    private class SpaceTreeNode
    extends TreeLayoutObserver.TreeNode {
        public boolean expanded;
        public double positionInLayer;

        public SpaceTreeNode(INodeLayout node, TreeLayoutObserver owner) {
            super(node, owner);
            this.expanded = true;
        }

        @Override
        protected void addChild(TreeLayoutObserver.TreeNode child) {
            super.addChild(child);
            SpaceTreeNode child2 = (SpaceTreeNode)child;
            child2.expanded = false;
            if (child.depth >= 0) {
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth)).removeNode(child2);
            }
            if (this.expanded) {
                SpaceTreeLayer childLayer;
                child.depth = this.depth + 1;
                if (child.depth < SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size()) {
                    childLayer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth);
                } else {
                    childLayer = new SpaceTreeLayer(child.depth);
                    SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.add(childLayer);
                }
                child.order = childLayer.nodes.isEmpty() ? 0 : childLayer.nodes.get((int)(childLayer.nodes.size() - 1)).order + 1;
                childLayer.addNodes(Arrays.asList(child));
            }
        }

        @Override
        public void precomputeTree() {
            super.precomputeTree();
            if (this == this.owner.getSuperRoot()) {
                this.expanded = true;
                while (SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size() <= this.height) {
                    SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.add(new SpaceTreeLayer(SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.size()));
                }
            }
        }

        public void adjustPosition(Point preferredLocation) {
            double newPositionInLayer;
            SpaceTreeLayoutAlgorithm.this.protectedNode = (SpaceTreeNode)this.owner.getSuperRoot();
            double d = newPositionInLayer = SpaceTreeLayoutAlgorithm.this.direction == 2 || SpaceTreeLayoutAlgorithm.this.direction == 1 ? preferredLocation.x : preferredLocation.y;
            if (((SpaceTreeNode)this.parent).expanded) {
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth)).moveNode(this, newPositionInLayer);
                this.centerParentsTopDown();
            }
        }

        public double spaceRequiredForNode() {
            if (this.node == null) {
                return 0.0;
            }
            switch (SpaceTreeLayoutAlgorithm.this.direction) {
                case 1: 
                case 2: {
                    return LayoutProperties.getSize((INodeLayout)this.node).width;
                }
                case 3: 
                case 4: {
                    return LayoutProperties.getSize((INodeLayout)this.node).height;
                }
            }
            throw new RuntimeException("invalid direction");
        }

        public double spaceRequiredForChildren() {
            if (this.children.isEmpty()) {
                return 0.0;
            }
            double result = 0.0;
            for (SpaceTreeNode child : this.children) {
                result += child.spaceRequiredForNode();
            }
            return result += SpaceTreeLayoutAlgorithm.this.leafGap * (double)(this.children.size() - 1);
        }

        public boolean childrenPositionsOK(ArrayList<TreeLayoutObserver.TreeNode> nodesToCheck) {
            for (SpaceTreeNode spaceTreeNode : nodesToCheck) {
                if (spaceTreeNode.depth < 0 || spaceTreeNode.children.isEmpty()) continue;
                SpaceTreeNode child = (SpaceTreeNode)spaceTreeNode.children.get(0);
                if (child.positionInLayer > spaceTreeNode.positionInLayer) {
                    ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(spaceTreeNode.depth)).moveNode(spaceTreeNode, child.positionInLayer);
                    if (child.positionInLayer > spaceTreeNode.positionInLayer) {
                        ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth)).moveNode(child, spaceTreeNode.positionInLayer);
                        if (child.positionInLayer > spaceTreeNode.positionInLayer) {
                            return false;
                        }
                    }
                }
                child = (SpaceTreeNode)spaceTreeNode.children.get(spaceTreeNode.children.size() - 1);
                if (!(child.positionInLayer < spaceTreeNode.positionInLayer)) continue;
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(spaceTreeNode.depth)).moveNode(spaceTreeNode, child.positionInLayer);
                if (!(child.positionInLayer < spaceTreeNode.positionInLayer)) continue;
                ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(child.depth)).moveNode(child, spaceTreeNode.positionInLayer);
                if (!(child.positionInLayer < spaceTreeNode.positionInLayer)) continue;
                return false;
            }
            return true;
        }

        public void centerParentsBottomUp() {
            if (!this.children.isEmpty() && this.expanded) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((SpaceTreeNode)iterator.next()).centerParentsBottomUp();
                }
                if (this.depth >= 0) {
                    SpaceTreeNode firstChild = (SpaceTreeNode)this.children.get(0);
                    SpaceTreeNode lastChild = (SpaceTreeNode)this.children.get(this.children.size() - 1);
                    SpaceTreeLayer layer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth);
                    layer.moveNode(this, (firstChild.positionInLayer + lastChild.positionInLayer) / 2.0);
                }
            }
        }

        public void centerParentsTopDown() {
            if (this == this.owner.getSuperRoot()) {
                this.positionInLayer = SpaceTreeLayoutAlgorithm.this.getAvailableSpace() / 2.0;
            }
            if (!this.children.isEmpty() && this.expanded) {
                SpaceTreeNode firstChild = (SpaceTreeNode)this.children.get(0);
                SpaceTreeNode lastChild = (SpaceTreeNode)this.children.get(this.children.size() - 1);
                double offset = this.positionInLayer - (firstChild.positionInLayer + lastChild.positionInLayer) / 2.0;
                if (firstChild.positionInLayer - firstChild.spaceRequiredForNode() / 2.0 + offset < 0.0) {
                    offset = -firstChild.positionInLayer + firstChild.spaceRequiredForNode() / 2.0;
                }
                double availableSpace = SpaceTreeLayoutAlgorithm.this.getAvailableSpace();
                if (lastChild.positionInLayer + lastChild.spaceRequiredForNode() / 2.0 + offset > availableSpace) {
                    offset = availableSpace - lastChild.positionInLayer - lastChild.spaceRequiredForNode() / 2.0;
                }
                SpaceTreeLayer layer = (SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth + 1);
                layer.fitNodesWithinBounds(this.children, firstChild.positionInLayer + offset, lastChild.positionInLayer + offset);
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((SpaceTreeNode)iterator.next()).centerParentsTopDown();
                }
            }
        }

        public void flushExpansionChanges() {
            if (this.expanded) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((SpaceTreeNode)iterator.next()).flushExpansionChanges();
                }
            }
        }

        public boolean flushLocationChanges(double thicknessSoFar) {
            Rectangle bounds = LayoutProperties.getBounds(SpaceTreeLayoutAlgorithm.this.context);
            boolean madeChanges = false;
            if (this.node != null) {
                Dimension nodeSize = LayoutProperties.getSize(this.node);
                double x = 0.0;
                double y = 0.0;
                switch (SpaceTreeLayoutAlgorithm.this.direction) {
                    case 1: {
                        x = bounds.getX() + this.positionInLayer;
                        y = thicknessSoFar + nodeSize.height / 2.0;
                        break;
                    }
                    case 2: {
                        x = bounds.getX() + this.positionInLayer;
                        y = bounds.getY() + bounds.getHeight() - thicknessSoFar - nodeSize.height / 2.0;
                        break;
                    }
                    case 3: {
                        x = thicknessSoFar + nodeSize.height / 2.0;
                        y = bounds.getY() + this.positionInLayer;
                        break;
                    }
                    case 4: {
                        x = bounds.getX() + bounds.getWidth() - thicknessSoFar - nodeSize.height / 2.0;
                        y = bounds.getY() + this.positionInLayer;
                    }
                }
                Point currentLocation = LayoutProperties.getLocation(this.node);
                if (currentLocation.x != x || currentLocation.y != y) {
                    LayoutProperties.setLocation(this.node, x, y);
                    SpaceTreeNode spaceTreeNode = (SpaceTreeNode)SpaceTreeLayoutAlgorithm.this.treeObserver.getTreeNode(this.node);
                    spaceTreeNode.adjustPosition(LayoutProperties.getLocation(this.node));
                    ((SpaceTreeLayer)SpaceTreeLayoutAlgorithm.this.spaceTreeLayers.get(this.depth)).refreshThickness();
                    madeChanges = true;
                }
            }
            if (this.expanded) {
                thicknessSoFar += (this.depth >= 0 ? ((SpaceTreeLayer)((SpaceTreeLayoutAlgorithm)SpaceTreeLayoutAlgorithm.this).spaceTreeLayers.get((int)this.depth)).thickness : 0.0) + SpaceTreeLayoutAlgorithm.this.layerGap;
                for (SpaceTreeNode child : this.children) {
                    boolean bl = madeChanges = child.flushLocationChanges(thicknessSoFar) || madeChanges;
                }
            }
            return madeChanges;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.depth) {
                sb.append(" ");
                ++i;
            }
            if (this.node != null) {
                sb.append(this.node.toString());
            }
            sb.append("|" + this.order);
            sb.append('\n');
            for (SpaceTreeNode child : this.children) {
                sb.append(child.toString());
            }
            return sb.toString();
        }
    }
}

