/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.layout.ILayoutAlgorithm;
import org.eclipse.gef4.layout.ILayoutContext;
import org.eclipse.gef4.layout.INodeLayout;
import org.eclipse.gef4.layout.LayoutProperties;

public class HorizontalShiftAlgorithm
implements ILayoutAlgorithm {
    private static final double DELTA = 10.0;
    private static final double VSPACING = 16.0;
    private ILayoutContext context;

    @Override
    public void applyLayout(boolean clean) {
        if (!clean) {
            return;
        }
        ArrayList<List<INodeLayout>> rowsList = new ArrayList<List<INodeLayout>>();
        INodeLayout[] entities = this.context.getNodes();
        int i = 0;
        while (i < entities.length) {
            this.addToRowList(entities[i], rowsList);
            ++i;
        }
        Collections.sort(rowsList, new Comparator<List<INodeLayout>>(){

            @Override
            public int compare(List<INodeLayout> o1, List<INodeLayout> o2) {
                INodeLayout entity0 = o1.get(0);
                INodeLayout entity1 = o2.get(0);
                return (int)(LayoutProperties.getLocation((INodeLayout)entity0).y - LayoutProperties.getLocation((INodeLayout)entity1).y);
            }
        });
        Comparator<INodeLayout> entityComparator = new Comparator<INodeLayout>(){

            @Override
            public int compare(INodeLayout o1, INodeLayout o2) {
                return (int)(LayoutProperties.getLocation((INodeLayout)o1).y - LayoutProperties.getLocation((INodeLayout)o2).y);
            }
        };
        Rectangle bounds = LayoutProperties.getBounds(this.context);
        int heightSoFar = 0;
        for (List<INodeLayout> currentRow : rowsList) {
            Collections.sort(currentRow, entityComparator);
            int i2 = 0;
            int width = (int)(bounds.getWidth() / 2.0 - (double)(currentRow.size() * 75));
            heightSoFar = (int)((double)heightSoFar + (LayoutProperties.getSize((INodeLayout)currentRow.get((int)0)).height + 16.0));
            for (INodeLayout entity : currentRow) {
                Dimension size = LayoutProperties.getSize(entity);
                LayoutProperties.setLocation(entity, (double)(width + 10 * ++i2) + size.width / 2.0, (double)heightSoFar + size.height / 2.0);
                width = (int)((double)width + size.width);
            }
        }
    }

    @Override
    public void setLayoutContext(ILayoutContext context) {
        this.context = context;
    }

    @Override
    public ILayoutContext getLayoutContext() {
        return this.context;
    }

    private void addToRowList(INodeLayout entity, ArrayList<List<INodeLayout>> rowsList) {
        double layoutY = LayoutProperties.getLocation((INodeLayout)entity).y;
        for (List<INodeLayout> currentRow : rowsList) {
            INodeLayout currentRowEntity = currentRow.get(0);
            double currentRowY = LayoutProperties.getLocation((INodeLayout)currentRowEntity).y;
            if (!(layoutY >= currentRowY - 10.0) || !(layoutY <= currentRowY + 10.0)) continue;
            currentRow.add(entity);
            return;
        }
        ArrayList<INodeLayout> newRow = new ArrayList<INodeLayout>();
        newRow.add(entity);
        rowsList.add(newRow);
    }
}

