/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javafx.beans.property.ReadOnlyMapProperty;
import javafx.beans.property.ReadOnlyMapWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.eclipse.gef4.common.attributes.IAttributeStore;
import org.eclipse.gef4.common.beans.property.ReadOnlyMapWrapperEx;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;

public class Edge
implements IAttributeStore {
    private final ReadOnlyMapWrapper<String, Object> attributesProperty = new ReadOnlyMapWrapperEx((Object)this, "attributes", FXCollections.observableHashMap());
    private Node source;
    private Node target;
    private Graph graph;

    public Edge(Map<String, Object> attributes, Node source, Node target) {
        this.attributesProperty.putAll(attributes);
        this.source = source;
        this.target = target;
    }

    public Edge(Node source, Node target) {
        this(new HashMap<String, Object>(), source, target);
    }

    public ReadOnlyMapProperty<String, Object> attributesProperty() {
        return this.attributesProperty.getReadOnlyProperty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Edge)) {
            return false;
        }
        Edge otherEdge = (Edge)other;
        boolean attrsEqual = this.attributesProperty.get() == null ? false : ((ObservableMap)this.attributesProperty().get()).equals(otherEdge.attributesProperty());
        boolean sourceEqual = this.getSource().equals(otherEdge.getSource());
        boolean targetEqual = this.getTarget().equals(otherEdge.getTarget());
        return attrsEqual && sourceEqual && targetEqual;
    }

    public ObservableMap<String, Object> getAttributes() {
        return this.attributesProperty.get();
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Node getSource() {
        return this.source;
    }

    public Node getTarget() {
        return this.target;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.attributesProperty.get() == null ? 0 : this.attributesProperty.get().hashCode());
        result = 31 * result + this.getSource().hashCode();
        result = 31 * result + this.getTarget().hashCode();
        return result;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Edge {");
        boolean separator = false;
        TreeMap<String, Object> sortedAttrs = new TreeMap<String, Object>();
        sortedAttrs.putAll((Map<String, Object>)this.attributesProperty);
        for (Object attrKey : sortedAttrs.keySet()) {
            if (separator) {
                sb.append(", ");
            } else {
                separator = true;
            }
            sb.append(String.valueOf(attrKey.toString()) + " : " + this.attributesProperty.get(attrKey));
        }
        sb.append("} from " + this.getSource() + " to " + this.getTarget());
        return sb.toString();
    }

    public static class Builder {
        private Graph.Builder.Context context;
        private Map<String, Object> attrs = new HashMap<String, Object>();
        private Object sourceNodeOrKey;
        private Object targetNodeOrKey;

        public Builder(Graph.Builder.Context context, Object sourceNodeOrKey, Object targetNodeOrKey) {
            this.context = context;
            if (context != null) {
                context.edgeBuilders.add(this);
            }
            this.sourceNodeOrKey = sourceNodeOrKey;
            this.targetNodeOrKey = targetNodeOrKey;
        }

        public Builder(Node sourceNode, Node targetNode) {
            this(null, sourceNode, targetNode);
        }

        public Builder attr(String key, Object value) {
            this.attrs.put(key, value);
            return this;
        }

        public Graph build() {
            if (this.context == null) {
                throw new IllegalStateException("The builder is not chained.");
            }
            return this.context.builder.build();
        }

        public Edge buildEdge() {
            Node targetNode;
            if (this.context == null && !(this.sourceNodeOrKey instanceof Node)) {
                throw new IllegalStateException("May only use builder keys in case of chained builders.");
            }
            if (this.context == null && !(this.targetNodeOrKey instanceof Node)) {
                throw new IllegalStateException("May only use builder keys in case of chained builders.");
            }
            Node sourceNode = this.sourceNodeOrKey instanceof Node ? (Node)this.sourceNodeOrKey : this.context.builder.findOrCreateNode(this.sourceNodeOrKey);
            Node node = targetNode = this.targetNodeOrKey instanceof Node ? (Node)this.targetNodeOrKey : this.context.builder.findOrCreateNode(this.targetNodeOrKey);
            if (sourceNode == null) {
                throw new IllegalArgumentException("Could not resolve source node (key='" + this.sourceNodeOrKey + "').");
            }
            if (targetNode == null) {
                throw new IllegalArgumentException("Could not resolve target node (key='" + this.targetNodeOrKey + "').");
            }
            return new Edge(this.attrs, sourceNode, targetNode);
        }

        public Builder edge(Object sourceNodeOrKey, Object targetNodeOrKey) {
            Builder eb = new Builder(this.context, sourceNodeOrKey, targetNodeOrKey);
            return eb;
        }

        public Node.Builder node() {
            Node.Builder nb = new Node.Builder(this.context);
            return nb;
        }

        public Node.Builder node(Object key) {
            Node.Builder nb = new Node.Builder(this.context, key);
            return nb;
        }
    }
}

