/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Paint;
import org.eclipse.gef4.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef4.common.collections.CollectionUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.mvc.examples.logo.model.AbstractFXGeometricElement;

public class FXGeometricCurve
extends AbstractFXGeometricElement<ICurve> {
    public static final String SOURCE_DECORATION_PROPERTY = "sourceDecoration";
    public static final String TARGET_DECORATION_PROPERTY = "targetDecoration";
    public static final String ROUTING_STYLE_PROPERTY = "routingStyle";
    public static final String WAY_POINTS_PROPERTY = "wayPoints";
    public static final String DASHES_PROPERTY = "dashes";
    private final ReadOnlyListWrapperEx<Point> wayPointsProperty = new ReadOnlyListWrapperEx((Object)this, "wayPoints", CollectionUtils.observableArrayList());
    private final ObjectProperty<Decoration> sourceDecorationProperty = new SimpleObjectProperty((Object)this, "sourceDecoration", (Object)Decoration.NONE);
    private final ObjectProperty<Decoration> targetDecorationProperty = new SimpleObjectProperty((Object)this, "targetDecoration", (Object)Decoration.NONE);
    private final ObjectProperty<RoutingStyle> routingStyleProperty = new SimpleObjectProperty((Object)this, "routingStyle", (Object)RoutingStyle.STRAIGHT);
    private final ReadOnlyListWrapperEx<Double> dashesProperty = new ReadOnlyListWrapperEx((Object)this, "dashes", CollectionUtils.observableArrayList());
    private final Set<AbstractFXGeometricElement<? extends IGeometry>> sourceAnchorages = new HashSet<AbstractFXGeometricElement<? extends IGeometry>>();
    private final Set<AbstractFXGeometricElement<? extends IGeometry>> targetAnchorages = new HashSet<AbstractFXGeometricElement<? extends IGeometry>>();

    public static ICurve constructCurveFromWayPoints(Point ... waypoints) {
        if (waypoints == null || waypoints.length == 0) {
            waypoints = new Point[]{new Point(), new Point()};
        } else if (waypoints.length == 1) {
            waypoints = new Point[]{new Point(), waypoints[0]};
        }
        return PolyBezier.interpolateCubic((Point[])waypoints);
    }

    public FXGeometricCurve(Point[] waypoints, Paint stroke, double strokeWidth, Double[] dashes, Effect effect) {
        super(FXGeometricCurve.constructCurveFromWayPoints(waypoints), stroke, strokeWidth, effect);
        this.wayPointsProperty.addAll(Arrays.asList(waypoints));
        this.dashesProperty.addAll((Object[])dashes);
    }

    public void addSourceAnchorage(AbstractFXGeometricElement<? extends IGeometry> anchored) {
        this.sourceAnchorages.add(anchored);
    }

    public void addTargetAnchorage(AbstractFXGeometricElement<? extends IGeometry> anchored) {
        this.targetAnchorages.add(anchored);
    }

    public void addWayPoint(int i, Point p) {
        List<Point> points = this.getWayPointsCopy();
        points.add(i, p);
        this.setWayPoints(points.toArray(new Point[0]));
    }

    public ReadOnlyListProperty<Double> dashesProperty() {
        return this.dashesProperty.getReadOnlyProperty();
    }

    public Double[] getDashes() {
        return (Double[])this.dashesProperty.get().toArray((Object[])new Double[0]);
    }

    public RoutingStyle getRoutingStyle() {
        return (RoutingStyle)((Object)this.routingStyleProperty.get());
    }

    public Set<AbstractFXGeometricElement<? extends IGeometry>> getSourceAnchorages() {
        return this.sourceAnchorages;
    }

    public Decoration getSourceDecoration() {
        return (Decoration)((Object)this.sourceDecorationProperty.get());
    }

    public Set<AbstractFXGeometricElement<? extends IGeometry>> getTargetAnchorages() {
        return this.targetAnchorages;
    }

    public Decoration getTargetDecoration() {
        return (Decoration)((Object)this.targetDecorationProperty.get());
    }

    public List<Point> getWayPoints() {
        return Collections.unmodifiableList(this.wayPointsProperty.get());
    }

    public List<Point> getWayPointsCopy() {
        return new ArrayList<Point>(this.getWayPoints());
    }

    public void removeWayPoint(int i) {
        List<Point> points = this.getWayPointsCopy();
        points.remove(i);
        this.setWayPoints(points.toArray(new Point[0]));
    }

    public ObjectProperty<RoutingStyle> routingStyleProperty() {
        return this.routingStyleProperty;
    }

    public void setRoutingStyle(RoutingStyle routingStyle) {
        this.routingStyleProperty.set((Object)routingStyle);
    }

    public void setSourceDecoration(Decoration sourceDecoration) {
        this.sourceDecorationProperty.set((Object)sourceDecoration);
    }

    public void setTargetDecoration(Decoration targetDecoration) {
        this.targetDecorationProperty.set((Object)targetDecoration);
    }

    public void setWayPoint(int i, Point p) {
        List<Point> points = this.getWayPointsCopy();
        points.set(i, p);
        this.setWayPoints(points.toArray(new Point[0]));
    }

    public void setWayPoints(Point ... waypoints) {
        this.wayPointsProperty.setAll(Arrays.asList(waypoints));
        this.setGeometry(FXGeometricCurve.constructCurveFromWayPoints(waypoints));
    }

    public ObjectProperty<Decoration> sourceDecorationProperty() {
        return this.sourceDecorationProperty;
    }

    public ObjectProperty<Decoration> targetDecorationProperty() {
        return this.targetDecorationProperty;
    }

    public ReadOnlyListProperty<Point> wayPointsProperty() {
        return this.wayPointsProperty.getReadOnlyProperty();
    }

    public static enum Decoration {
        NONE,
        ARROW,
        CIRCLE;

    }

    public static enum RoutingStyle {
        STRAIGHT,
        ORTHOGONAL;

    }
}

