/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import java.util.List;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Point;

public class StraightRouter
implements IConnectionRouter {
    private Point getCenter(Connection connection, Node anchorageNode) {
        Point center = FX2Geometry.toRectangle((Bounds)connection.sceneToLocal(anchorageNode.localToScene(anchorageNode.getLayoutBounds()))).getCenter();
        if (Double.isNaN(center.x) || Double.isNaN(center.y)) {
            return null;
        }
        return center;
    }

    private Point getNeighbor(Connection connection, int anchorIndex, int step) {
        List<IAnchor> anchors = connection.getAnchors();
        IAnchor anchor = anchors.get(anchorIndex);
        if (!(anchor instanceof DynamicAnchor)) {
            throw new IllegalStateException("Specified anchor '" + anchor + "' is no DynamicAnchor.");
        }
        Node anchorage = anchor.getAnchorage();
        int i = anchorIndex + step;
        while (i < anchors.size() && i >= 0) {
            IAnchor predAnchor = anchors.get(i);
            if (predAnchor == null) {
                throw new IllegalStateException("connection inconsistent (null anchor)");
            }
            Node predAnchorage = predAnchor.getAnchorage();
            if (predAnchorage == null || predAnchorage == connection) {
                AnchorKey anchorKey = connection.getAnchorKey(i);
                Point position = predAnchor.getPosition(anchorKey);
                if (position == null) {
                    throw new IllegalStateException("connection inconsistent (null position)");
                }
                Point2D local = anchorage.sceneToLocal(connection.localToScene(position.x, position.y));
                if (!anchorage.contains(local)) {
                    return position;
                }
            } else {
                Point position = this.getCenter(connection, predAnchorage);
                if (position == null) {
                    throw new IllegalStateException("cannot determine anchorage center");
                }
                return position;
            }
            i += step;
        }
        return null;
    }

    private Point getPred(Connection connection, int anchorIndex) {
        return this.getNeighbor(connection, anchorIndex, -1);
    }

    private Point getSucc(Connection connection, int anchorIndex) {
        return this.getNeighbor(connection, anchorIndex, 1);
    }

    @Override
    public boolean isImplicitAnchor(IAnchor anchor) {
        return false;
    }

    @Override
    public void route(Connection connection) {
        if (connection.getPoints().size() < 2) {
            return;
        }
        int i = 0;
        while (i < connection.getAnchors().size()) {
            this.updateReferencePoints(connection, i);
            ++i;
        }
    }

    private void updateReferencePoint(Connection connection, int anchorIndex) {
        if (connection.getStartAnchor() == null || connection.getEndAnchor() == null) {
            return;
        }
        IAnchor anchor = connection.getAnchors().get(anchorIndex);
        if (!(anchor instanceof DynamicAnchor)) {
            return;
        }
        AnchorKey anchorKey = connection.getAnchorKey(anchorIndex);
        Point oldRef = (Point)((DynamicAnchor)anchor).referencePointProperty().get((Object)anchorKey);
        Point newRef = null;
        Point pred = this.getPred(connection, anchorIndex);
        Point succ = this.getSucc(connection, anchorIndex);
        newRef = pred == null && succ == null ? new Point() : (pred != null ? pred : (succ != null ? succ : new Line(pred, succ).get(0.5)));
        if (oldRef == null || !newRef.equals((Object)oldRef)) {
            ((DynamicAnchor)anchor).referencePointProperty().put((Object)anchorKey, (Object)newRef);
        }
    }

    private void updateReferencePoints(Connection connection, int anchorIndex) {
        if (connection.getStartAnchor() == null || connection.getEndAnchor() == null) {
            return;
        }
        List<IAnchor> anchors = connection.getAnchors();
        int i = 0;
        while (i < anchors.size()) {
            if (anchorIndex != i) {
                this.updateReferencePoint(connection, i);
            }
            ++i;
        }
    }
}

