/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.StaticAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.Polygon;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class OrthogonalRouter
implements IConnectionRouter {
    private static final double OFFSET = 15.0;

    protected IGeometry getAnchorageGeometry(Connection connection, int index) {
        IAnchor anchor = connection.getAnchor(index);
        if (anchor != null && anchor.getAnchorage() != null && anchor.getAnchorage() != connection) {
            Node anchorage = anchor.getAnchorage();
            IGeometry outlineGeometry = DynamicAnchor.AbstractComputationStrategy.getOutlineGeometry(anchorage);
            return NodeUtils.sceneToLocal((Node)connection, NodeUtils.localToScene(anchorage, outlineGeometry));
        }
        return null;
    }

    private Point getAnchorReferencePoint(Connection connection, int index) {
        IGeometry geometry;
        if (index < 0 || index >= connection.getPoints().size()) {
            throw new IndexOutOfBoundsException();
        }
        IGeometry referenceGeometry = null;
        int referenceIndex = index < connection.getPoints().size() - 1 ? index + 1 : index - 1;
        referenceGeometry = this.getAnchorageGeometry(connection, referenceIndex);
        if (referenceGeometry != null && (geometry = this.getAnchorageGeometry(connection, index)) != null) {
            double y2;
            double x2;
            Rectangle bounds = geometry.getBounds();
            Rectangle refBounds = referenceGeometry.getBounds();
            double x1 = Math.max(bounds.getX(), refBounds.getX());
            if (x1 <= (x2 = Math.min(bounds.getX() + bounds.getWidth(), refBounds.getX() + refBounds.getWidth()))) {
                return new Point(x1 + (x2 - x1) / 2.0, refBounds.getY() > bounds.getY() + bounds.getHeight() ? refBounds.getY() : refBounds.getY() + refBounds.getHeight());
            }
            double y1 = Math.max(bounds.getY(), refBounds.getY());
            if (y1 <= (y2 = Math.min(bounds.getY() + bounds.getHeight(), refBounds.getY() + refBounds.getHeight()))) {
                return new Point(refBounds.getX() > bounds.getX() + bounds.getWidth() ? refBounds.getX() : refBounds.getX() + refBounds.getWidth(), y1 + (y2 - y1) / 2.0);
            }
            return DynamicAnchor.OrthogonalProjectionStrategy.getNearestBoundsProjection(referenceGeometry, geometry.getBounds().getCenter());
        }
        return connection.getPoint(referenceIndex);
    }

    private Vector getDirection(Connection connection, int i) {
        return new Vector(this.getPosition(connection, i), this.getPosition(connection, i + 1));
    }

    private Point getPosition(Connection connection, int index) {
        int numPoints = connection.getPoints().size();
        if (index == 0 || index == numPoints - 1) {
            IAnchor anchor;
            IAnchor iAnchor = index == 0 ? connection.getStartAnchor() : (anchor = index == numPoints - 1 ? connection.getEndAnchor() : connection.getControlAnchor(index - 1));
            if (anchor == null) {
                return connection.getPoint(index);
            }
            if (anchor instanceof DynamicAnchor) {
                Point referencePoint = this.getAnchorReferencePoint(connection, index);
                ((DynamicAnchor)anchor).referencePointProperty().put((Object)connection.getAnchorKey(index), (Object)referencePoint);
                AnchorKey anchorKey = connection.getAnchorKey(index);
                DynamicAnchor.IComputationStrategy computationStrategy = ((DynamicAnchor)anchor).getComputationStrategy(anchorKey);
                Point computePosition = ((DynamicAnchor)anchor).computePosition((Node)connection, referencePoint, computationStrategy);
                return computePosition;
            }
        }
        return connection.getPoint(index);
    }

    private Polygon[] getTriangles(Connection connection, int i) {
        Node anchorage = connection.getAnchor(i).getAnchorage();
        Bounds boundsInScene = anchorage.localToScene(anchorage.getLayoutBounds());
        Rectangle rectangle = FX2Geometry.toRectangle((Bounds)boundsInScene);
        Polygon top = new Polygon(new Point[]{rectangle.getTopLeft(), rectangle.getTopRight(), rectangle.getCenter()});
        Polygon bottom = new Polygon(new Point[]{rectangle.getBottomLeft(), rectangle.getBottomRight(), rectangle.getCenter()});
        Polygon left = new Polygon(new Point[]{rectangle.getTopLeft(), rectangle.getBottomLeft(), rectangle.getCenter()});
        Polygon right = new Polygon(new Point[]{rectangle.getTopRight(), rectangle.getBottomRight(), rectangle.getCenter()});
        return new Polygon[]{top, right, bottom, left};
    }

    private boolean isBottom(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[2].contains(point);
    }

    @Override
    public boolean isImplicitAnchor(IAnchor anchor) {
        return anchor instanceof OrthogonalPolylineRouterAnchor;
    }

    private boolean isLeft(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[3].contains(point);
    }

    private boolean isRight(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[1].contains(point);
    }

    private boolean isSufficientlyHorizontal(Vector currentDirection) {
        return Math.abs(currentDirection.y) < 0.5 && Math.abs(currentDirection.x) > Math.abs(currentDirection.y);
    }

    private boolean isSufficientlyVertical(Vector currentDirection) {
        return Math.abs(currentDirection.y) > Math.abs(currentDirection.x) && Math.abs(currentDirection.x) < 0.5;
    }

    private boolean isTop(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[0].contains(point);
    }

    private boolean isTopOrBottom(Connection connection, int i, Point currentPoint) {
        Point2D pointInScene = connection.localToScene(currentPoint.x, currentPoint.y);
        Point point = FX2Geometry.toPoint((Point2D)pointInScene);
        Polygon[] triangles = this.getTriangles(connection, i);
        return triangles[0].contains(point) || triangles[2].contains(point);
    }

    @Override
    public void route(Connection connection) {
        if (connection.getPoints().size() < 2) {
            return;
        }
        ControlPointManipulator controlPointManipulator = new ControlPointManipulator(connection);
        controlPointManipulator.clearPoints();
        Vector previousDirection = null;
        Vector currentDirection = null;
        int i = 0;
        while (i < connection.getPoints().size() - 1) {
            Point currentPoint = this.getPosition(connection, i);
            previousDirection = currentDirection;
            currentDirection = this.getDirection(connection, i);
            if (Math.abs(currentDirection.x) <= 0.05 && Math.abs(currentDirection.y) <= 0.05) {
                currentDirection = previousDirection;
            } else if (!this.isSufficientlyHorizontal(currentDirection) && !this.isSufficientlyVertical(currentDirection)) {
                currentDirection = this.routeNonOrthogonalSegment(connection, controlPointManipulator, previousDirection, currentDirection, i, currentPoint);
            }
            ++i;
        }
        controlPointManipulator.addPoints();
    }

    protected Vector routeNonOrthogonalSegment(Connection connection, ControlPointManipulator controlPointManipulator, Vector previousDirection, Vector currentDirection, int i, Point currentPoint) {
        controlPointManipulator.setRoutingData(i + 1, currentPoint, currentDirection);
        Vector moveVertically = new Vector(0.0, currentDirection.y);
        Vector moveHorizontally = new Vector(currentDirection.x, 0.0);
        if (i == 0 && connection.isStartConnected() || i == connection.getPoints().size() - 2 && connection.isEndConnected()) {
            if (i == 0 && i != connection.getPoints().size() - 2) {
                currentDirection = this.isTopOrBottom(connection, i, currentPoint) ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally);
            } else if (i != 0 && i == connection.getPoints().size() - 2) {
                currentDirection = this.isTopOrBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y)) ? controlPointManipulator.addRoutingPoint(moveHorizontally) : controlPointManipulator.addRoutingPoint(moveVertically);
            } else {
                boolean currentIsTopOrBottom = this.isTopOrBottom(connection, i, currentPoint);
                boolean nextIsTopOrBottom = this.isTopOrBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if (currentIsTopOrBottom && nextIsTopOrBottom) {
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, currentDirection.y / 2.0, currentDirection.x, currentDirection.y / 2.0);
                } else if (!currentIsTopOrBottom && !nextIsTopOrBottom) {
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, currentDirection.x / 2.0, 0.0, currentDirection.x / 2.0, currentDirection.y);
                } else {
                    currentDirection = currentIsTopOrBottom ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally);
                }
            }
        } else {
            currentDirection = previousDirection == null ? controlPointManipulator.addRoutingPoint(moveHorizontally) : (previousDirection.isHorizontal() ? (previousDirection.x < 0.0 && currentDirection.x < 0.0 || previousDirection.x > 0.0 && currentDirection.x > 0.0 ? controlPointManipulator.addRoutingPoint(moveHorizontally) : controlPointManipulator.addRoutingPoint(moveVertically)) : (previousDirection.y < 0.0 && currentDirection.y < 0.0 || previousDirection.y > 0.0 && currentDirection.y > 0.0 ? controlPointManipulator.addRoutingPoint(moveVertically) : controlPointManipulator.addRoutingPoint(moveHorizontally)));
        }
        return currentDirection;
    }

    protected Vector routeOrthogonalSegment(Connection connection, ControlPointManipulator controlPointManipulator, Vector currentDirection, int i, Point currentPoint) {
        if (i == 0 && connection.isStartConnected() && i != connection.getPoints().size() - 2) {
            if (currentDirection.isVertical()) {
                boolean isLeft = this.isLeft(connection, i, currentPoint);
                boolean isRight = this.isRight(connection, i, currentPoint);
                boolean isBottom = this.isBottom(connection, i, currentPoint);
                boolean isTop = this.isTop(connection, i, currentPoint);
                if ((isLeft || isRight) && !isBottom && !isTop) {
                    double offset = isLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y);
                    currentDirection = new Vector(-offset, 0.0);
                }
            } else if (currentDirection.isHorizontal()) {
                boolean isLeft = this.isLeft(connection, i, currentPoint);
                boolean isRight = this.isRight(connection, i, currentPoint);
                boolean isBottom = this.isBottom(connection, i, currentPoint);
                boolean isTop = this.isTop(connection, i, currentPoint);
                if ((isTop || isBottom) && !isLeft && !isRight) {
                    double offset = isTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x, offset);
                    currentDirection = new Vector(0.0, -offset);
                }
            }
        } else if (i != 0 && i == connection.getPoints().size() - 2 && connection.isEndConnected()) {
            if (currentDirection.isHorizontal()) {
                boolean isLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if ((isTop || isBottom) && !isLeft && !isRight) {
                    double offset = isTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x, offset);
                    currentDirection = new Vector(0.0, -offset);
                }
            } else if (currentDirection.isVertical()) {
                boolean isLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if ((isLeft || isRight) && !isTop && !isBottom) {
                    double offset = isLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y);
                    currentDirection = new Vector(-offset, 0.0);
                }
            }
        } else if (i == 0 && i == connection.getPoints().size() - 2 && connection.isStartConnected() && connection.isEndConnected()) {
            if (currentDirection.isHorizontal()) {
                boolean isCurrentTop = this.isTop(connection, i, currentPoint);
                boolean isNextBottom = this.isBottom(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isCurrentBottom = this.isBottom(connection, i, currentPoint);
                boolean isNextTop = this.isTop(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if (isCurrentTop && isNextBottom || isCurrentBottom && isNextTop) {
                    double offset = isCurrentTop ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, 0.0, offset, currentDirection.x / 2.0, offset, currentDirection.x / 2.0, currentDirection.y - offset, currentDirection.x, currentDirection.y - offset);
                    currentDirection = new Vector(0.0, offset);
                }
            } else if (currentDirection.isVertical()) {
                boolean isCurrentLeft = this.isLeft(connection, i, currentPoint);
                boolean isNextRight = this.isRight(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                boolean isCurrentRight = this.isRight(connection, i, currentPoint);
                boolean isNextLeft = this.isLeft(connection, i + 1, currentPoint.getTranslated(currentDirection.x, currentDirection.y));
                if (isCurrentLeft && isNextRight || isCurrentRight && isNextLeft) {
                    double offset = isCurrentLeft ? -15.0 : 15.0;
                    controlPointManipulator.addRoutingPoints(i + 1, currentPoint, offset, 0.0, offset, currentDirection.y / 2.0, currentDirection.x - offset, currentDirection.y / 2.0, currentDirection.x - offset, currentDirection.y);
                }
            }
        }
        return currentDirection;
    }

    private static class ControlPointManipulator {
        private Connection connection;
        private Map<Integer, List<Point>> pointsToInsert = new HashMap<Integer, List<Point>>();
        private int index;
        private Vector direction;
        private Point point;
        private List<IAnchor> initialControlAnchors;

        public ControlPointManipulator(Connection c) {
            this.connection = c;
        }

        public void addPoints() {
            int pointsInserted = 0;
            for (int insertionIndex : this.pointsToInsert.keySet()) {
                for (Point pointToInsert : this.pointsToInsert.get(insertionIndex)) {
                    this.initialControlAnchors.add(insertionIndex + pointsInserted - 1, new OrthogonalPolylineRouterAnchor((Node)this.connection, pointToInsert));
                    ++pointsInserted;
                }
            }
            this.connection.setControlAnchors(this.initialControlAnchors);
        }

        public Vector addRoutingPoint(int index, Point point, double dx, double dy) {
            Point insertion = point.getTranslated(dx, dy);
            if (!this.pointsToInsert.containsKey(index)) {
                this.pointsToInsert.put(index, new ArrayList());
            }
            this.pointsToInsert.get(index).add(insertion);
            return new Vector(dx, dy);
        }

        public Vector addRoutingPoint(Vector delta) {
            this.direction = this.direction.getSubtracted(this.addRoutingPoint(this.index, this.point, delta.x, delta.y));
            return this.direction;
        }

        public void addRoutingPoints(int index, Point point, double ... deltas) {
            if (deltas == null) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got <null>.");
            }
            if (deltas.length == 0) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got 0.");
            }
            if (deltas.length % 2 != 0) {
                throw new IllegalArgumentException("Even number of routing point deltas required, but got " + deltas.length + ".");
            }
            if (!this.pointsToInsert.containsKey(index)) {
                this.pointsToInsert.put(index, new ArrayList());
            }
            int i = 0;
            while (i < deltas.length) {
                Point insertion = point.getTranslated(deltas[i], deltas[i + 1]);
                this.pointsToInsert.get(index).add(insertion);
                i += 2;
            }
        }

        public void clearPoints() {
            int pointsRemoved = 0;
            this.initialControlAnchors = new ArrayList<IAnchor>(this.connection.getControlAnchors());
            int i = 0;
            while (i < this.initialControlAnchors.size()) {
                if (this.initialControlAnchors.get(i) instanceof OrthogonalPolylineRouterAnchor) {
                    this.connection.removeControlAnchor(i - pointsRemoved);
                    ++pointsRemoved;
                }
                ++i;
            }
            this.initialControlAnchors = new ArrayList<IAnchor>(this.connection.getControlAnchors());
        }

        public void setRoutingData(int index, Point point, Vector direction) {
            this.index = index;
            this.point = point;
            this.direction = direction;
        }
    }

    private static class OrthogonalPolylineRouterAnchor
    extends StaticAnchor {
        public OrthogonalPolylineRouterAnchor(Node anchorage, Point referencePositionInAnchorageLocal) {
            super(anchorage, referencePositionInAnchorageLocal);
        }

        @Override
        public String toString() {
            return "OrthogonalRouterAnchor[referencePosition=" + this.getReferencePosition() + "]";
        }
    }
}

