/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.fx.anchors;

import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.gef4.fx.anchors.AbstractAnchor;
import org.eclipse.gef4.fx.anchors.AnchorKey;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.Point;

public class StaticAnchor
extends AbstractAnchor {
    private ObjectProperty<Point> referencePositionProperty = new SimpleObjectProperty();

    public StaticAnchor(Node anchorage, Point referencePositionInAnchorageLocal) {
        super(anchorage);
        this.referencePositionProperty.addListener((ChangeListener)new ChangeListener<Point>(){

            public void changed(ObservableValue<? extends Point> observable, Point oldValue, Point newValue) {
                for (Set<AnchorKey> keys : StaticAnchor.this.getKeys().values()) {
                    for (AnchorKey key : keys) {
                        StaticAnchor.this.updatePosition(key);
                    }
                }
            }
        });
        this.referencePositionProperty.set((Object)referencePositionInAnchorageLocal);
    }

    public StaticAnchor(Point referencePositionInScene) {
        super(null);
        this.referencePositionProperty.addListener((ChangeListener)new /* invalid duplicate definition of identical inner class */);
        this.referencePositionProperty.set((Object)referencePositionInScene);
    }

    @Override
    protected Point computePosition(AnchorKey key) {
        Node anchored = key.getAnchored();
        Node anchorage = this.getAnchorage();
        Point positionInScene = anchorage == null ? (Point)this.referencePositionProperty.get() : FX2Geometry.toPoint((Point2D)anchorage.localToScene(((Point)this.referencePositionProperty.get()).x, ((Point)this.referencePositionProperty.get()).y));
        Point positionInAnchoredLocal = FX2Geometry.toPoint((Point2D)anchored.sceneToLocal(positionInScene.x, positionInScene.y));
        return positionInAnchoredLocal;
    }

    public Point getReferencePosition() {
        return (Point)this.referencePositionProperty.get();
    }

    public ObjectProperty<Point> referencePositionProperty() {
        return this.referencePositionProperty;
    }

    public void setReferencePosition(Point referencePosition) {
        this.referencePositionProperty.set((Object)referencePosition);
    }

    public String toString() {
        return "StaticAnchor[referencePosition = " + this.referencePositionProperty.get() + "]";
    }
}

