/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal.parser.conversion;

import com.google.inject.Inject;
import org.eclipse.gef4.dot.internal.parser.conversion.DotStringValueConverter;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.impl.AbstractDeclarativeValueConverterService;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.conversion.impl.STRINGValueConverter;

public class DotTerminalConverters
extends AbstractDeclarativeValueConverterService {
    @Inject
    private IDValueConverter compassPtValueConverter;
    @Inject
    private IDValueConverter numeralValueConverter;
    @Inject
    private DotStringValueConverter stringValueConverter;
    @Inject
    private STRINGValueConverter quotedStringValueConverter;

    @ValueConverter(rule="STRING")
    public IValueConverter<String> STRING() {
        return this.stringValueConverter;
    }

    @ValueConverter(rule="NUMERAL")
    public IValueConverter<String> NUMERAL() {
        return this.numeralValueConverter;
    }

    @ValueConverter(rule="COMPASS_PT")
    public IValueConverter<String> COMPASS_PT() {
        return this.compassPtValueConverter;
    }

    @ValueConverter(rule="QUOTED_STRING")
    public IValueConverter<String> QUOTED_STRING() {
        return this.quotedStringValueConverter;
    }

    public static boolean needsToBeQuoted(String value) {
        return value.isEmpty() || value.matches(".*\\s.*");
    }

    public static String quote(String value) {
        if (!DotTerminalConverters.isQuoted(value)) {
            return "\"" + value + "\"";
        }
        return value;
    }

    public static boolean isQuoted(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }

    public static String unquote(String value) {
        if (DotTerminalConverters.isQuoted(value)) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }
}

