/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public final class DotNativeDrawer {
    private DotNativeDrawer() {
    }

    public static File renderImage(File dotExecutablePath, File dotInputFile, String format, String outputFileName) {
        String dotFile = dotInputFile.getName();
        String resultFile = outputFileName == null ? String.valueOf(dotFile.substring(0, dotFile.lastIndexOf(46) + 1)) + format : outputFileName;
        String inputFolder = String.valueOf(new File(dotInputFile.getParent()).getAbsolutePath()) + File.separator;
        String outputFolder = outputFileName == null ? inputFolder : String.valueOf(new File(new File(outputFileName).getAbsolutePath()).getParentFile().getAbsolutePath()) + File.separator;
        File outputFile = new File(outputFolder, resultFile);
        String[] outputs = DotNativeDrawer.executeDot(dotExecutablePath, dotInputFile, outputFile, format);
        if (!outputs[0].isEmpty()) {
            System.out.println("Output from dot call: " + outputs[0]);
        }
        if (!outputs[1].isEmpty()) {
            System.err.println("Errors from dot call: " + outputs[1]);
        }
        return outputFile;
    }

    public static String[] executeDot(File dotExecutablePath, File dotInputFile, File outputFile, String outputFormat) {
        String[] commands = new String[]{dotExecutablePath.getAbsolutePath(), outputFormat == null ? "" : "-T" + outputFormat, outputFile == null ? "" : "-o" + outputFile.toPath().toString(), dotInputFile.toPath().toString()};
        return DotNativeDrawer.call(commands);
    }

    public static String[] getSupportedExportFormats(String dotExecutable) {
        String[] commands = new String[]{dotExecutable, "-T?"};
        String[] outputs = DotNativeDrawer.call(commands);
        String output = outputs[1];
        if (!output.isEmpty()) {
            String supportedFormats = output.substring(output.lastIndexOf(": ") + 2);
            supportedFormats = supportedFormats.trim();
            return supportedFormats.split(" ");
        }
        return new String[0];
    }

    private static String[] call(String[] commands) {
        System.out.print("Calling '" + Arrays.asList(commands) + "'");
        String[] outputs = new String[]{"", ""};
        Runtime runtime = Runtime.getRuntime();
        Process p = null;
        try {
            p = runtime.exec(commands);
            p.waitFor();
            System.out.println(" resulted in exit status: " + p.exitValue() + ".");
        }
        catch (Exception e) {
            System.out.println(" failed with exception " + e.getMessage() + ".");
        }
        if (p != null) {
            String output = DotNativeDrawer.read(p.getInputStream());
            outputs[0] = output.trim();
            String errors = DotNativeDrawer.read(p.getErrorStream());
            outputs[1] = errors.trim();
        }
        return outputs;
    }

    private static String read(InputStream s) {
        StringBuilder builder = new StringBuilder();
        try {
            int current = -1;
            while ((current = s.read()) != -1) {
                builder.append((char)current);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }
}

