/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef4.dot.internal.DotAttributes;
import org.eclipse.gef4.dot.internal.parser.dot.AttrList;
import org.eclipse.gef4.dot.internal.parser.dot.AttrStmt;
import org.eclipse.gef4.dot.internal.parser.dot.Attribute;
import org.eclipse.gef4.dot.internal.parser.dot.AttributeType;
import org.eclipse.gef4.dot.internal.parser.dot.DotAst;
import org.eclipse.gef4.dot.internal.parser.dot.DotGraph;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeRhsNode;
import org.eclipse.gef4.dot.internal.parser.dot.EdgeStmtNode;
import org.eclipse.gef4.dot.internal.parser.dot.GraphType;
import org.eclipse.gef4.dot.internal.parser.dot.NodeId;
import org.eclipse.gef4.dot.internal.parser.dot.NodeStmt;
import org.eclipse.gef4.dot.internal.parser.dot.Stmt;
import org.eclipse.gef4.dot.internal.parser.dot.Subgraph;
import org.eclipse.gef4.dot.internal.parser.dot.util.DotSwitch;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;

public final class DotInterpreter
extends DotSwitch<Object> {
    private Map<String, Node> nodes;
    private Graph.Builder graph;
    private String globalEdgeStyle;
    private String globalEdgeLabel;
    private String globalNodeLabel;
    private String currentArrowHead;
    private String currentEdgeStyle;
    private String currentEdgeLabel;
    private String currentEdgeSourceNodeName;
    private String currentEdgePos;
    private boolean createEdge;
    private String currentEdgeXLabel;
    private String currentEdgeXlp;
    private String currentEdgeLp;
    private String currentEdgeTailLabel;
    private String currentEdgeHeadLabel;
    private String currentEdgeHeadLp;
    private String currentEdgeTailLp;
    private String currentEdgeId;
    private String currentEdgeOp;

    public List<Graph> interpret(DotAst dotAst) {
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        for (DotGraph dotGraph : dotAst.getGraphs()) {
            Graph g = this.interpret(dotGraph, new Graph.Builder());
            if (g == null) continue;
            graphs.add(g);
        }
        return graphs;
    }

    private Graph interpret(DotGraph dotGraph, Graph.Builder graph) {
        this.graph = graph;
        this.nodes = new HashMap<String, Node>();
        this.doSwitch(dotGraph);
        TreeIterator contents = EcoreUtil.getAllProperContents((EObject)dotGraph, (boolean)false);
        while (contents.hasNext()) {
            this.doSwitch((EObject)contents.next());
        }
        return graph.build();
    }

    @Override
    public Object caseDotGraph(DotGraph object) {
        this.createGraph(object);
        return super.caseDotGraph(object);
    }

    @Override
    public Object caseAttribute(Attribute object) {
        if ("rankdir".equals(object.getName())) {
            String value = object.getValue();
            if (value == null) {
                value = "";
            }
            value = value.toLowerCase();
            boolean lr = "lr".equals(value);
            boolean td = "td".equals(value);
            this.graph.attr("layout", (Object)"dot");
            this.graph.attr("rankdir", (Object)(lr ? "lr" : (td ? "td" : "td")));
        }
        return super.caseAttribute(object);
    }

    @Override
    public Object caseAttrStmt(AttrStmt object) {
        this.createAttributes(object);
        return super.caseAttrStmt(object);
    }

    @Override
    public Object caseNodeStmt(NodeStmt object) {
        this.createNode(object);
        return super.caseNodeStmt(object);
    }

    @Override
    public Object caseEdgeStmtNode(EdgeStmtNode object) {
        this.currentEdgeId = this.getAttributeValue(object, "id");
        this.currentEdgeLabel = this.getAttributeValue(object, "label");
        this.currentEdgeLp = this.getAttributeValue(object, "lp");
        this.currentEdgeXLabel = this.getAttributeValue(object, "xlabel");
        this.currentEdgeXlp = this.getAttributeValue(object, "xlp");
        this.currentEdgeStyle = this.getAttributeValue(object, "style");
        this.currentEdgePos = this.getAttributeValue(object, "pos");
        this.currentEdgeHeadLabel = this.getAttributeValue(object, "headlabel");
        this.currentEdgeHeadLp = this.getAttributeValue(object, "head_lp");
        this.currentEdgeTailLabel = this.getAttributeValue(object, "taillabel");
        this.currentEdgeTailLp = this.getAttributeValue(object, "tail_lp");
        this.currentArrowHead = this.getAttributeValue(object, "arrowhead");
        return super.caseEdgeStmtNode(object);
    }

    @Override
    public Object caseNodeId(NodeId object) {
        if (!this.createEdge) {
            this.currentEdgeSourceNodeName = this.escaped(object.getName());
        } else {
            String targetNodeId = this.escaped(object.getName());
            if (this.currentEdgeSourceNodeName != null && targetNodeId != null) {
                this.createEdge(targetNodeId);
                this.currentEdgeSourceNodeName = targetNodeId;
            }
            this.createEdge = false;
        }
        return super.caseNodeId(object);
    }

    private void createEdge(String targetNodeName) {
        Edge.Builder edgeBuilder = new Edge.Builder(this.node(this.currentEdgeSourceNodeName), this.node(targetNodeName));
        String name = String.valueOf(this.currentEdgeSourceNodeName) + this.currentEdgeOp + targetNodeName;
        edgeBuilder.attr("_name", (Object)name);
        if (this.currentEdgeId != null) {
            edgeBuilder.attr("id", (Object)this.currentEdgeId);
        }
        if (this.currentEdgeLabel != null) {
            edgeBuilder.attr("label", (Object)this.currentEdgeLabel);
        } else if (this.globalEdgeLabel != null) {
            edgeBuilder.attr("label", (Object)this.globalEdgeLabel);
        }
        if (this.currentEdgeXLabel != null) {
            edgeBuilder.attr("xlabel", (Object)this.currentEdgeXLabel);
        }
        if (this.currentEdgeHeadLabel != null) {
            edgeBuilder.attr("headlabel", (Object)this.currentEdgeHeadLabel);
        }
        if (this.currentEdgeTailLabel != null) {
            edgeBuilder.attr("taillabel", (Object)this.currentEdgeTailLabel);
        }
        String currentEdgeStyleLc = new String(this.currentEdgeStyle == null ? "" : this.currentEdgeStyle).toLowerCase();
        String globalEdgeStyleLc = new String(this.globalEdgeStyle == null ? "" : this.globalEdgeStyle).toLowerCase();
        if (!"".equals(currentEdgeStyleLc) && this.supported(currentEdgeStyleLc, DotAttributes.STYLE__E__VALUES)) {
            edgeBuilder.attr("style", (Object)currentEdgeStyleLc);
        } else if (!"".equals(globalEdgeStyleLc) && this.supported(globalEdgeStyleLc, DotAttributes.STYLE__E__VALUES)) {
            edgeBuilder.attr("style", (Object)globalEdgeStyleLc);
        }
        if (this.currentEdgePos != null) {
            edgeBuilder.attr("pos", (Object)this.currentEdgePos);
        }
        if (this.currentEdgeLp != null) {
            edgeBuilder.attr("lp", (Object)this.currentEdgeLp);
        }
        if (this.currentEdgeXlp != null) {
            edgeBuilder.attr("xlp", (Object)this.currentEdgeXlp);
        }
        if (this.currentEdgeHeadLp != null) {
            edgeBuilder.attr("head_lp", (Object)this.currentEdgeHeadLp);
        }
        if (this.currentEdgeTailLp != null) {
            edgeBuilder.attr("tail_lp", (Object)this.currentEdgeTailLp);
        }
        if (this.currentArrowHead != null) {
            edgeBuilder.attr("arrowhead", (Object)this.currentArrowHead);
        }
        this.graph.edges(new Edge[]{edgeBuilder.buildEdge()});
    }

    private boolean supported(String value, Set<String> vals) {
        if (value == null) {
            return false;
        }
        return vals.contains(value);
    }

    @Override
    public Object caseEdgeRhsNode(EdgeRhsNode object) {
        this.createEdge = true;
        this.currentEdgeOp = object.getOp().getLiteral();
        return super.caseEdgeRhsNode(object);
    }

    @Override
    public Object caseSubgraph(Subgraph object) {
        return super.caseSubgraph(object);
    }

    private void createGraph(DotGraph dotGraph) {
        GraphType graphType;
        String name = this.escaped(dotGraph.getName());
        if (name != null) {
            this.graph.attr("_name", (Object)name);
        }
        this.graph.attr("_type", (Object)(GraphType.GRAPH.equals((Object)(graphType = dotGraph.getType())) ? DotAttributes._TYPE__G__GRAPH : DotAttributes._TYPE__G__DIGRAPH));
        String layout = this.getAttributeValue(dotGraph, "layout");
        if (layout != null) {
            this.graph.attr("layout", (Object)layout);
        }
    }

    private void createAttributes(AttrStmt attrStmt) {
        AttributeType type = attrStmt.getType();
        switch (type) {
            case EDGE: {
                this.globalEdgeStyle = this.getAttributeValue(attrStmt, "style");
                this.globalEdgeLabel = this.getAttributeValue(attrStmt, "label");
                break;
            }
            case NODE: {
                this.globalNodeLabel = this.getAttributeValue(attrStmt, "label");
                break;
            }
            case GRAPH: {
                for (AttrList al : attrStmt.getAttrLists()) {
                    for (Attribute a : al.getAttributes()) {
                        this.graph.attr(a.getName(), (Object)a.getValue());
                    }
                }
                String graphLayout = this.getAttributeValue(attrStmt, "layout");
                if (graphLayout == null) break;
                String graphLayoutLc = new String(graphLayout).toLowerCase();
                if (!this.supported(graphLayoutLc, DotAttributes.LAYOUT__G__VALUES)) {
                    throw new IllegalArgumentException("Unknown layout algorithm <" + graphLayoutLc + ">.");
                }
                this.graph.attr("layout", (Object)graphLayoutLc);
            }
        }
    }

    private void createNode(NodeStmt nodeStatement) {
        String height;
        String width;
        String xlp;
        String pos;
        String label;
        String nodeName = this.escaped(nodeStatement.getNode().getName());
        Node node = this.nodes.containsKey(nodeName) ? this.nodes.get(nodeName) : new Node.Builder().attr("_name", (Object)nodeName).buildNode();
        String id = this.getAttributeValue(nodeStatement, "id");
        if (id != null) {
            DotAttributes.setId(node, id);
        }
        if ((label = this.getAttributeValue(nodeStatement, "label")) != null) {
            DotAttributes.setLabel(node, label);
        } else if (this.globalNodeLabel != null) {
            DotAttributes.setLabel(node, this.globalNodeLabel);
        }
        String xLabel = this.getAttributeValue(nodeStatement, "xlabel");
        if (xLabel != null) {
            DotAttributes.setXLabel(node, xLabel);
        }
        if ((pos = this.getAttributeValue(nodeStatement, "pos")) != null) {
            DotAttributes.setPos(node, pos);
        }
        if ((xlp = this.getAttributeValue(nodeStatement, "xlp")) != null) {
            DotAttributes.setXlp(node, xlp);
        }
        if ((width = this.getAttributeValue(nodeStatement, "width")) != null) {
            DotAttributes.setWidth(node, width);
        }
        if ((height = this.getAttributeValue(nodeStatement, "height")) != null) {
            DotAttributes.setHeight(node, height);
        }
        if (!this.nodes.containsKey(nodeName)) {
            this.nodes.put(nodeName, node);
            this.graph = this.graph.nodes(new Node[]{node});
        }
    }

    private Node node(String id) {
        if (!this.nodes.containsKey(id)) {
            Node node = new Node.Builder().attr("label", (Object)(this.globalNodeLabel != null ? this.globalNodeLabel : id)).attr("_name", (Object)id).buildNode();
            this.nodes.put(id, node);
            this.graph = this.graph.nodes(new Node[]{node});
        }
        return this.nodes.get(id);
    }

    private String getAttributeValue(DotGraph graph, String name) {
        for (Stmt stmt : graph.getStmts()) {
            if (stmt instanceof AttrStmt) {
                return this.getAttributeValue((AttrStmt)stmt, name);
            }
            if (!(stmt instanceof Attribute)) continue;
            return this.getAttributeValue((Attribute)stmt, name);
        }
        return null;
    }

    private String getAttributeValue(NodeStmt stmt, String name) {
        return this.getAttributeValue((List<AttrList>)stmt.getAttrLists(), name);
    }

    private String getAttributeValue(List<AttrList> attrLists, String name) {
        for (AttrList attrList : attrLists) {
            String value = this.getAttributeValue(attrList, name);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private String getAttributeValue(AttrStmt attrStmt, String name) {
        return this.getAttributeValue((List<AttrList>)attrStmt.getAttrLists(), name);
    }

    private String getAttributeValue(EdgeStmtNode edgeStmtNode, String name) {
        return this.getAttributeValue((List<AttrList>)edgeStmtNode.getAttrLists(), name);
    }

    private String getAttributeValue(AttrList attrList, String name) {
        for (EObject next : attrList.eContents()) {
            String value;
            if (!(next instanceof Attribute) || (value = this.getAttributeValue((Attribute)next, name)) == null) continue;
            return value;
        }
        return null;
    }

    private String getAttributeValue(Attribute attribute, String name) {
        if (attribute.getName().equals(name)) {
            return this.escaped(attribute.getValue());
        }
        return null;
    }

    private String escaped(String id) {
        if (id == null) {
            return null;
        }
        return id.replaceAll("^\"|\"$", "").replaceAll("\\\\\"", "\"");
    }
}

