/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gef4.dot.internal.DotFileUtils;
import org.eclipse.gef4.dot.internal.DotInterpreter;
import org.eclipse.gef4.dot.internal.parser.DotStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.dot.DotAst;
import org.eclipse.gef4.dot.internal.parser.dot.DotGraph;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.GraphCopier;

public final class DotImport {
    private Resource resource;
    private String dotString;

    public DotImport(File dotFile) {
        this.dotString = DotFileUtils.read(dotFile);
        this.load();
    }

    public DotImport(String dotString) {
        this.init(dotString);
    }

    private void init(String dotString) {
        if (dotString == null || dotString.trim().length() == 0) {
            throw new IllegalArgumentException("Passed DOT must not be null or empty: " + dotString);
        }
        this.loadFrom(dotString);
        if (this.getErrors().size() > 0) {
            this.loadFrom(this.wrapped(dotString));
        }
    }

    private void loadFrom(String dotString) {
        this.dotString = dotString;
        this.load();
    }

    private String wrapped(String dotString) {
        return String.format("%s Unnamed{%s}", dotString.contains("->") ? "digraph" : "graph", dotString);
    }

    private void guardFaultyParse() {
        List<String> errors = this.getErrors();
        if (errors.size() > 0) {
            throw new IllegalArgumentException(String.format("Could not parse DOT: %s (%s)", this.dotString, errors.toString()));
        }
    }

    private void load() {
        this.resource = DotImport.loadResource(this.dotString);
    }

    public String getName() {
        return this.dotGraph().getName();
    }

    public Graph toGraph() {
        this.guardFaultyParse();
        return new DotInterpreter().interpret((DotAst)this.resource.getContents().get(0)).get(0);
    }

    private static Resource loadResource(String dot) {
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("dot")) {
            DotStandaloneSetup.doSetup();
        }
        ResourceSetImpl set = new ResourceSetImpl();
        Resource res = set.createResource(URI.createURI((String)"*.dot"));
        try {
            res.load((InputStream)new ByteArrayInputStream(dot.getBytes()), Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public DotGraph dotGraph() {
        EList contents = this.resource.getContents();
        EObject graphs = (EObject)contents.iterator().next();
        EObject graph = (EObject)graphs.eContents().iterator().next();
        return (DotGraph)graph;
    }

    public List<String> getErrors() {
        ArrayList<String> result = new ArrayList<String>();
        EList errors = this.resource.getErrors();
        for (Resource.Diagnostic next : errors) {
            result.add(String.format("Error in line %s: %s ", next.getLine(), next.getMessage()));
        }
        return result;
    }

    public void into(Graph.Builder graph) {
        new GraphCopier(this.toGraph(), "_name").into(graph);
    }

    public String toString() {
        return String.format("%s of %s", this.getClass().getSimpleName(), this.dotString);
    }
}

