/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.gef4.dot.internal.DotFileUtils;

public final class DotExtractor {
    public static final String NO_DOT = "graph{n1[label=\"no DOT\"]}";
    private String input = "graph{n1[label=\"no DOT\"]}";

    public DotExtractor(String input) {
        this.input = input;
    }

    public DotExtractor(File file) {
        this(DotFileUtils.read(file));
    }

    public String getDotString() {
        return this.trimNonDotSuffix(this.trimNonDotPrefix());
    }

    private String trimNonDotPrefix() {
        Matcher m = Pattern.compile("((?:di)?graph\\s*[^{\\s]*\\s*\\{.+)", 32).matcher(this.input);
        String dotSubstring = m.find() ? m.group(1) : NO_DOT;
        return dotSubstring;
    }

    private String trimNonDotSuffix(String dot) {
        int first = dot.indexOf(123) + 1;
        StringBuilder builder = new StringBuilder(dot.substring(0, first));
        int count = 1;
        int index = first;
        while (count > 0 && index < dot.length()) {
            char c = dot.charAt(index);
            builder.append(c);
            count = c == '{' ? count + 1 : (c == '}' ? count - 1 : count);
            ++index;
        }
        return builder.toString().trim();
    }
}

