/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.gef4.dot.internal.parser.DotArrowTypeStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.DotPointStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.DotSplineTypeStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.arrowtype.ArrowType;
import org.eclipse.gef4.dot.internal.parser.dot.GraphType;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotArrowTypeParser;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotPointParser;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotSplineTypeParser;
import org.eclipse.gef4.dot.internal.parser.point.Point;
import org.eclipse.gef4.dot.internal.parser.services.DotArrowTypeGrammarAccess;
import org.eclipse.gef4.dot.internal.parser.services.DotPointGrammarAccess;
import org.eclipse.gef4.dot.internal.parser.services.DotSplineTypeGrammarAccess;
import org.eclipse.gef4.dot.internal.parser.splinetype.SplineType;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;

public class DotAttributes {
    private static final Injector pointInjector = new DotPointStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final DotPointParser dotPointParser = (DotPointParser)((Object)pointInjector.getInstance(DotPointParser.class));
    private static final DotPointGrammarAccess dotPointGrammarAccess = (DotPointGrammarAccess)((Object)pointInjector.getInstance(DotPointGrammarAccess.class));
    private static final Injector splineTypeInjector = new DotSplineTypeStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final DotSplineTypeParser dotSplineTypeParser = (DotSplineTypeParser)((Object)splineTypeInjector.getInstance(DotSplineTypeParser.class));
    private static final DotSplineTypeGrammarAccess dotSplineTypeGrammarAccess = (DotSplineTypeGrammarAccess)((Object)splineTypeInjector.getInstance(DotSplineTypeGrammarAccess.class));
    private static final Injector arrowTypeInjector = new DotArrowTypeStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final DotArrowTypeParser dotArrowTypeParser = (DotArrowTypeParser)((Object)arrowTypeInjector.getInstance(DotArrowTypeParser.class));
    private static final DotArrowTypeGrammarAccess dotArrowTypeGrammarAccess = (DotArrowTypeGrammarAccess)((Object)arrowTypeInjector.getInstance(DotArrowTypeGrammarAccess.class));
    public static final String _NAME__GNE = "_name";
    public static final String _TYPE__G = "_type";
    public static final String _TYPE__G__DIGRAPH = GraphType.DIGRAPH.getLiteral();
    public static final String _TYPE__G__GRAPH = GraphType.GRAPH.getLiteral();
    public static final Set<String> _TYPE__G__VALUES = new HashSet<String>(Arrays.asList(_TYPE__G__GRAPH, _TYPE__G__DIGRAPH));
    public static final String ARROWHEAD__E = "arrowhead";
    public static final String HEAD_LP__E = "head_lp";
    public static final String HEADLABEL__E = "headlabel";
    public static final String HEIGHT__N = "height";
    public static final String ID__GNE = "id";
    public static final String LABEL__GNE = "label";
    public static final String LAYOUT__G__CIRCO = "circo";
    public static final String LAYOUT__G__DOT = "dot";
    public static final String LAYOUT__G__FDP = "fdp";
    public static final String LAYOUT__G__GRID = "grid";
    public static final String LAYOUT__G__NEATO = "neato";
    public static final String LAYOUT__G__OSAGE = "osage";
    public static final String LAYOUT__G__SFDP = "sfdp";
    public static final String LAYOUT__G__TWOPI = "twopi";
    public static final String LAYOUT__G__DEFAULT = "dot";
    public static final Set<String> LAYOUT__G__VALUES = new HashSet<String>(Arrays.asList("dot", "osage", "grid", "twopi", "circo", "neato", "fdp", "sfdp"));
    public static final String LAYOUT_G = "layout";
    public static final String LP__E = "lp";
    public static final String POS__NE = "pos";
    public static final String RANKDIR__G = "rankdir";
    public static final String RANKDIR__G__LR = "lr";
    public static final String RANKDIR__G__TD = "td";
    public static final String RANKDIR__G__DEFAULT = "td";
    public static final Set<String> RANKDIR__G__VALUES = new HashSet<String>(Arrays.asList("lr", "td"));
    public static final String STYLE__E = "style";
    public static final String STYLE__E__BOLD = "bold";
    public static final String STYLE__E__DASHED = "dashed";
    public static final String STYLE__E__DOTTED = "dotted";
    public static final String STYLE__E__INVIS = "invis";
    public static final String STYLE__E__SOLID = "solid";
    public static final String STYLE__E__TAPERED = "tapered";
    public static final String STYLE__E__VOID = "";
    public static final String STYLE__E__DEFAULT = "solid";
    public static final Set<String> STYLE__E__VALUES = new HashSet<String>(Arrays.asList("dashed", "dotted", "solid", "invis", "bold", "tapered", ""));
    public static final String TAIL_LP__E = "tail_lp";
    public static final String TAILLABEL__E = "taillabel";
    public static final String WIDTH__N = "width";
    public static final String XLABEL__NE = "xlabel";
    public static final String XLP__NE = "xlp";

    public static String getArrowHead(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ARROWHEAD__E);
    }

    public static ArrowType getArrowHeadParsed(Edge edge) {
        String arrowHead = DotAttributes.getArrowHead(edge);
        if (arrowHead == null) {
            return null;
        }
        IParseResult parsedPropertyValue = DotAttributes.parsePropertyValue((IParser)dotArrowTypeParser, dotArrowTypeGrammarAccess.getArrowTypeRule(), arrowHead);
        ArrowType arrowType = (ArrowType)parsedPropertyValue.getRootASTElement();
        return arrowType;
    }

    public static String getHeadLabel(Edge edge) {
        return (String)edge.attributesProperty().get((Object)HEADLABEL__E);
    }

    public static String getHeadLp(Edge edge) {
        return (String)edge.attributesProperty().get((Object)HEAD_LP__E);
    }

    public static Point getHeadLpParsed(Edge edge) {
        IParseResult parsedPropertyValue = DotAttributes.parsePropertyValue((IParser)dotPointParser, dotPointGrammarAccess.getPointRule(), DotAttributes.getHeadLp(edge));
        Point point = (Point)parsedPropertyValue.getRootASTElement();
        return point;
    }

    public static String getHeight(Node node) {
        return (String)node.attributesProperty().get((Object)HEIGHT__N);
    }

    public static String getId(Edge edge) {
        return (String)edge.attributesProperty().get((Object)ID__GNE);
    }

    public static String getId(Graph graph) {
        return (String)graph.attributesProperty().get((Object)ID__GNE);
    }

    public static String getId(Node node) {
        return (String)node.attributesProperty().get((Object)ID__GNE);
    }

    public static String getLabel(Edge edge) {
        return (String)edge.attributesProperty().get((Object)LABEL__GNE);
    }

    public static String getLabel(Node node) {
        return (String)node.attributesProperty().get((Object)LABEL__GNE);
    }

    public static String getLayout(Graph graph) {
        return (String)graph.attributesProperty().get((Object)LAYOUT_G);
    }

    public static String getLp(Edge edge) {
        return (String)edge.attributesProperty().get((Object)LP__E);
    }

    public static Point getLpParsed(Edge edge) {
        IParseResult parsedPropertyValue = DotAttributes.parsePropertyValue((IParser)dotPointParser, dotPointGrammarAccess.getPointRule(), DotAttributes.getLp(edge));
        Point point = (Point)parsedPropertyValue.getRootASTElement();
        return point;
    }

    public static String getName(Edge edge) {
        return (String)edge.attributesProperty().get((Object)_NAME__GNE);
    }

    public static String getName(Graph graph) {
        return (String)graph.attributesProperty().get((Object)_NAME__GNE);
    }

    public static String getName(Node node) {
        return (String)node.attributesProperty().get((Object)_NAME__GNE);
    }

    public static String getPos(Edge edge) {
        return (String)edge.attributesProperty().get((Object)POS__NE);
    }

    public static String getPos(Node node) {
        return (String)node.attributesProperty().get((Object)POS__NE);
    }

    public static SplineType getPosParsed(Edge edge) {
        IParseResult parsedPropertyValue = DotAttributes.parsePropertyValue((IParser)dotSplineTypeParser, dotSplineTypeGrammarAccess.getSplineTypeRule(), DotAttributes.getPos(edge));
        SplineType splineType = (SplineType)parsedPropertyValue.getRootASTElement();
        return splineType;
    }

    public static Point getPosParsed(Node node) {
        IParseResult parsedPropertyValue = DotAttributes.parsePropertyValue((IParser)dotPointParser, dotPointGrammarAccess.getPointRule(), DotAttributes.getPos(node));
        Point point = (Point)parsedPropertyValue.getRootASTElement();
        return point;
    }

    public static String getRankdir(Graph graph) {
        return (String)graph.attributesProperty().get((Object)RANKDIR__G);
    }

    public static String getStyle(Edge edge) {
        return (String)edge.attributesProperty().get((Object)STYLE__E);
    }

    private static String getSyntaxErrorMessages(IParseResult parseResult) {
        StringBuilder sb = new StringBuilder();
        for (INode error : parseResult.getSyntaxErrors()) {
            SyntaxErrorMessage syntaxErrorMessage = error.getSyntaxErrorMessage();
            sb.append(syntaxErrorMessage.getMessage());
        }
        return sb.toString();
    }

    public static String getTailLabel(Edge edge) {
        return (String)edge.attributesProperty().get((Object)TAILLABEL__E);
    }

    public static String getTailLp(Edge edge) {
        return (String)edge.attributesProperty().get((Object)TAIL_LP__E);
    }

    public static Point getTailLpParsed(Edge edge) {
        IParseResult parsedPropertyValue = DotAttributes.parsePropertyValue((IParser)dotPointParser, dotPointGrammarAccess.getPointRule(), DotAttributes.getTailLp(edge));
        Point point = (Point)parsedPropertyValue.getRootASTElement();
        return point;
    }

    public static String getType(Graph graph) {
        return (String)graph.attributesProperty().get((Object)_TYPE__G);
    }

    public static String getWidth(Node node) {
        return (String)node.attributesProperty().get((Object)WIDTH__N);
    }

    public static String getXLabel(Edge edge) {
        return (String)edge.attributesProperty().get((Object)XLABEL__NE);
    }

    public static String getXLabel(Node node) {
        return (String)node.attributesProperty().get((Object)XLABEL__NE);
    }

    public static String getXlp(Edge edge) {
        return (String)edge.attributesProperty().get((Object)XLP__NE);
    }

    public static String getXlp(Node node) {
        return (String)node.attributesProperty().get((Object)XLP__NE);
    }

    public static Point getXlpParsed(Edge edge) {
        IParseResult parsedPropertyValue = DotAttributes.parsePropertyValue((IParser)dotPointParser, dotPointGrammarAccess.getPointRule(), DotAttributes.getXlp(edge));
        Point point = (Point)parsedPropertyValue.getRootASTElement();
        return point;
    }

    public static Point getXlpParsed(Node node) {
        IParseResult parsedPropertyValue = DotAttributes.parsePropertyValue((IParser)dotPointParser, dotPointGrammarAccess.getPointRule(), DotAttributes.getXlp(node));
        Point point = (Point)parsedPropertyValue.getRootASTElement();
        return point;
    }

    private static IParseResult parsePropertyValue(IParser parser, ParserRule rule, String propertyValue) {
        IParseResult parseResult = parser.parse(rule, (Reader)new StringReader(propertyValue));
        return parseResult;
    }

    public static void setArrowHead(Edge edge, String arrowHead) {
        edge.attributesProperty().put((Object)ARROWHEAD__E, (Object)arrowHead);
    }

    public static void setHeadLabel(Edge edge, String label) {
        edge.attributesProperty().put((Object)HEADLABEL__E, (Object)label);
    }

    public static void setHeadLp(Edge edge, String headLp) {
        edge.attributesProperty().put((Object)LP__E, (Object)headLp);
    }

    public static void setHeight(Node node, String height) {
        try {
            Double.parseDouble(height);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Cannot set node attribute 'height' to '" + height + "': parsing as double failed.");
        }
        node.getAttributes().put((Object)HEIGHT__N, (Object)height);
    }

    public static void setId(Edge edge, String id) {
        edge.attributesProperty().put((Object)ID__GNE, (Object)id);
    }

    public static void setId(Graph graph, String id) {
        graph.attributesProperty().put((Object)ID__GNE, (Object)id);
    }

    public static void setId(Node node, String id) {
        node.attributesProperty().put((Object)ID__GNE, (Object)id);
    }

    public static void setLabel(Edge edge, String label) {
        edge.attributesProperty().put((Object)LABEL__GNE, (Object)label);
    }

    public static void setLabel(Node node, String label) {
        node.attributesProperty().put((Object)LABEL__GNE, (Object)label);
    }

    public static void setLayout(Graph graph, String layout) {
        if (!LAYOUT__G__VALUES.contains(layout)) {
            throw new IllegalArgumentException("Cannot set graph attribute \"layout\" to \"" + layout + "\"; supported values: " + LAYOUT__G__VALUES);
        }
        graph.attributesProperty().put((Object)LAYOUT_G, (Object)layout);
    }

    public static void setLp(Edge edge, String lp) {
        edge.attributesProperty().put((Object)LP__E, (Object)lp);
    }

    public static void setName(Edge edge, String name) {
        edge.attributesProperty().put((Object)_NAME__GNE, (Object)name);
    }

    public static void setName(Graph graph, String name) {
        graph.attributesProperty().put((Object)_NAME__GNE, (Object)name);
    }

    public static void setName(Node node, String id) {
        node.attributesProperty().put((Object)_NAME__GNE, (Object)id);
    }

    public static void setPos(Edge edge, String pos) {
        IParseResult parseResult = DotAttributes.parsePropertyValue((IParser)dotSplineTypeParser, dotSplineTypeGrammarAccess.getSplineTypeRule(), pos);
        if (parseResult.hasSyntaxErrors()) {
            throw new IllegalArgumentException("Cannot set edge attribute 'pos' to '" + pos + "': " + DotAttributes.getSyntaxErrorMessages(parseResult));
        }
        edge.getAttributes().put((Object)POS__NE, (Object)pos);
    }

    public static void setPos(Node node, String pos) {
        IParseResult parseResult = DotAttributes.parsePropertyValue((IParser)dotPointParser, dotPointGrammarAccess.getPointRule(), pos);
        if (parseResult.hasSyntaxErrors()) {
            throw new IllegalArgumentException("Cannot set node attribute 'pos' to '" + pos + "': " + DotAttributes.getSyntaxErrorMessages(parseResult));
        }
        node.getAttributes().put((Object)POS__NE, (Object)pos);
    }

    public static void setRankdir(Graph graph, String rankdir) {
        if (!RANKDIR__G__VALUES.contains(rankdir)) {
            throw new IllegalArgumentException("Cannot set graph attribute \"rankdir\" to \"" + rankdir + "\"; supported values: " + RANKDIR__G__VALUES);
        }
        graph.attributesProperty().put((Object)RANKDIR__G, (Object)rankdir);
    }

    public static void setStyle(Edge edge, String style) {
        if (!STYLE__E__VALUES.contains(style)) {
            throw new IllegalArgumentException("Cannot set edge attribute \"style\" to \"" + style + "\"; supported values: " + STYLE__E__VALUES);
        }
        edge.attributesProperty().put((Object)STYLE__E, (Object)style);
    }

    public static void setTailLabel(Edge edge, String label) {
        edge.attributesProperty().put((Object)TAILLABEL__E, (Object)label);
    }

    public static void setTailLp(Edge edge, String tailLp) {
        edge.attributesProperty().put((Object)TAIL_LP__E, (Object)tailLp);
    }

    public static void setType(Graph graph, String type) {
        if (!_TYPE__G__VALUES.contains(type)) {
            throw new IllegalArgumentException("Cannot set graph attribute \"type\" to \"" + type + "\"; supported values: " + _TYPE__G__VALUES);
        }
        graph.attributesProperty().put((Object)_TYPE__G, (Object)type);
    }

    public static void setWidth(Node node, String width) {
        try {
            Double.parseDouble(width);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Cannot set node attribute 'width' to '" + width + "': parsing as double failed.");
        }
        node.getAttributes().put((Object)WIDTH__N, (Object)width);
    }

    public static void setXLabel(Edge edge, String xLabel) {
        edge.attributesProperty().put((Object)XLABEL__NE, (Object)xLabel);
    }

    public static void setXLabel(Node node, String xLabel) {
        node.attributesProperty().put((Object)XLABEL__NE, (Object)xLabel);
    }

    public static void setXlp(Edge edge, String xlp) {
        edge.attributesProperty().put((Object)XLP__NE, (Object)xlp);
    }

    public static void setXlp(Node node, String xlp) {
        node.attributesProperty().put((Object)XLP__NE, (Object)xlp);
    }

    public static boolean isValidArrowType(String arrowType) {
        IParseResult parseResult = DotAttributes.parsePropertyValue((IParser)dotArrowTypeParser, dotArrowTypeGrammarAccess.getArrowTypeRule(), arrowType);
        return !parseResult.hasSyntaxErrors();
    }
}

