/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.parts;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionForwarder<VR>
implements ISelectionChangedListener {
    private final SelectionObserver selectionObserver = new SelectionObserver();
    private final ISelectionProvider selectionProvider;
    private final IViewer<VR> viewer;
    private final SelectionModel<VR> selectionModel;

    public SelectionForwarder(ISelectionProvider selectionProvider, IViewer<VR> viewer) {
        if (viewer == null) {
            throw new IllegalArgumentException("The given IViewer<VR> may not be null.");
        }
        this.selectionProvider = selectionProvider;
        this.viewer = viewer;
        this.selectionModel = this.getSelectionModel();
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.selectionModel.getSelectionUnmodifiable().addListener((ListChangeListener)this.selectionObserver);
    }

    public void dispose() {
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (this.selectionModel != null) {
            this.selectionModel.getSelectionUnmodifiable().removeListener((ListChangeListener)this.selectionObserver);
        }
    }

    protected SelectionModel<VR> getSelectionModel() {
        SelectionModel selectionModel = (SelectionModel)this.viewer.getAdapter(new TypeToken<SelectionModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.viewer.getClass())));
        return selectionModel;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            if (!this.selectionModel.getSelectionUnmodifiable().isEmpty()) {
                this.selectionModel.clearSelection();
            }
        } else if (selection instanceof StructuredSelection) {
            Object[] selected = ((StructuredSelection)selection).toArray();
            ArrayList<IContentPart> parts = new ArrayList<IContentPart>(selected.length);
            Object[] objectArray = selected;
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object content = objectArray[n2];
                IContentPart part = (IContentPart)this.viewer.getContentPartMap().get(content);
                if (part != null) {
                    parts.add(part);
                }
                ++n2;
            }
            if (!this.selectionModel.getSelectionUnmodifiable().equals(parts)) {
                this.selectionModel.setSelection(parts);
            }
        }
    }

    private class SelectionObserver
    implements ListChangeListener<IContentPart<VR, ? extends VR>> {
        private SelectionObserver() {
        }

        public void onChanged(ListChangeListener.Change<? extends IContentPart<VR, ? extends VR>> c) {
            ISelection oldSelectedContent = SelectionForwarder.this.selectionProvider.getSelection();
            if (c.getList().isEmpty()) {
                if (oldSelectedContent == null || !oldSelectedContent.isEmpty()) {
                    SelectionForwarder.this.selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            } else {
                ObservableList selectedContentParts = c.getList();
                ArrayList<Object> selectedContentElements = new ArrayList<Object>(selectedContentParts.size());
                for (IContentPart cp : selectedContentParts) {
                    selectedContentElements.add(cp.getContent());
                }
                StructuredSelection newSelectedContent = new StructuredSelection(selectedContentElements);
                if (!newSelectedContent.equals((Object)oldSelectedContent)) {
                    SelectionForwarder.this.selectionProvider.setSelection((ISelection)newSelectedContent);
                }
            }
        }
    }
}

