/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.ui.parts;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.policies.DeletionPolicy;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.actions.ActionFactory;

public class DeleteActionHandler
extends Action {
    private FXViewer viewer = null;
    private ListChangeListener<IContentPart<?, ?>> selectionListener = new ListChangeListener<IContentPart<?, ?>>(){

        public void onChanged(ListChangeListener.Change<? extends IContentPart<?, ?>> c) {
            DeleteActionHandler.this.updateEnabledState((SelectionModel<Node>)DeleteActionHandler.this.getSelectionModel());
        }
    };

    public DeleteActionHandler() {
        super("Delete");
        this.setId(ActionFactory.DELETE.getId());
        this.setEnabled(false);
    }

    private SelectionModel<Node> getSelectionModel() {
        if (this.viewer == null) {
            return null;
        }
        return (SelectionModel)this.viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){});
    }

    public void init(FXViewer viewer) {
        SelectionModel<Node> oldSelectionModel = this.getSelectionModel();
        SelectionModel newSelectionModel = null;
        this.viewer = viewer;
        if (viewer != null) {
            newSelectionModel = (SelectionModel)viewer.getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){});
        }
        if (oldSelectionModel != null && oldSelectionModel != newSelectionModel) {
            oldSelectionModel.getSelectionUnmodifiable().removeListener(this.selectionListener);
        }
        if (newSelectionModel != null && oldSelectionModel != newSelectionModel) {
            newSelectionModel.getSelectionUnmodifiable().addListener(this.selectionListener);
        }
        this.updateEnabledState(newSelectionModel);
    }

    public void runWithEvent(Event event) {
        DeletionPolicy deletionPolicy = (DeletionPolicy)this.viewer.getRootPart().getAdapter((TypeToken)new TypeToken<DeletionPolicy<Node>>(){});
        if (deletionPolicy == null) {
            throw new IllegalStateException("DeleteActionHandler requires a DeletionPolicy to be registered at the viewer's root part.");
        }
        deletionPolicy.init();
        for (IContentPart s : new ArrayList(this.getSelectionModel().getSelectionUnmodifiable())) {
            deletionPolicy.delete(s);
        }
        ITransactionalOperation deleteOperation = deletionPolicy.commit();
        if (deleteOperation != null) {
            try {
                this.viewer.getDomain().execute((IUndoableOperation)deleteOperation);
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected void updateEnabledState(SelectionModel<Node> selectionModel) {
        if (selectionModel == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(!selectionModel.getSelectionUnmodifiable().isEmpty());
        }
    }
}

