/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.ScrollEvent;
import org.eclipse.gef4.fx.gestures.AbstractScrollGesture;
import org.eclipse.gef4.mvc.fx.policies.IFXOnScrollPolicy;
import org.eclipse.gef4.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXScrollTool
extends AbstractTool<Node> {
    public static final Class<IFXOnScrollPolicy> ON_SCROLL_POLICY_KEY = IFXOnScrollPolicy.class;
    @Inject
    private ITargetPolicyResolver targetPolicyResolver;
    private final Map<Scene, AbstractScrollGesture> gestures = new HashMap<Scene, AbstractScrollGesture>();
    private final Map<IViewer<Node>, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer<Node>, ChangeListener<Boolean>>();

    public List<? extends IFXOnScrollPolicy> getActivePolicies(IViewer<Node> viewer) {
        return super.getActivePolicies(viewer);
    }

    protected void registerListeners() {
        super.registerListeners();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue == null || !newValue.booleanValue()) {
                        for (IFXOnScrollPolicy iFXOnScrollPolicy : FXScrollTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                            iFXOnScrollPolicy.scrollAborted();
                        }
                        FXScrollTool.this.clearActivePolicies(viewer);
                        FXScrollTool.this.getDomain().closeExecutionTransaction((ITool)FXScrollTool.this);
                    }
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put((IViewer<Node>)viewer, viewerFocusChangeListener);
            Scene scene = ((FXViewer)viewer).getScene();
            if (this.gestures.containsKey(scene)) continue;
            AbstractScrollGesture scrollGesture = new AbstractScrollGesture(){

                protected void scroll(ScrollEvent event) {
                    for (IFXOnScrollPolicy iFXOnScrollPolicy : FXScrollTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnScrollPolicy.scroll(event);
                    }
                }

                protected void scrollFinished() {
                    for (IFXOnScrollPolicy iFXOnScrollPolicy : FXScrollTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnScrollPolicy.scrollFinished();
                    }
                    FXScrollTool.this.clearActivePolicies(viewer);
                    FXScrollTool.this.getDomain().closeExecutionTransaction((ITool)FXScrollTool.this);
                }

                protected void scrollStarted(ScrollEvent event) {
                    EventTarget eventTarget = event.getTarget();
                    FXScrollTool.this.getDomain().openExecutionTransaction((ITool)FXScrollTool.this);
                    FXScrollTool.this.setActivePolicies(viewer, FXScrollTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXScrollTool.this, eventTarget instanceof Node ? (Node)eventTarget : null, ON_SCROLL_POLICY_KEY));
                    for (IFXOnScrollPolicy iFXOnScrollPolicy : FXScrollTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnScrollPolicy.scrollStarted(event);
                    }
                }
            };
            scrollGesture.setScene(scene);
            this.gestures.put(scene, scrollGesture);
        }
    }

    protected void unregisterListeners() {
        for (Scene scene : this.gestures.keySet()) {
            this.gestures.remove(scene).setScene(null);
        }
        for (IViewer iViewer : this.viewerFocusChangeListeners.keySet()) {
            iViewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(iViewer));
        }
        super.unregisterListeners();
    }
}

