/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.tools;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.RotateEvent;
import org.eclipse.gef4.fx.gestures.AbstractRotateGesture;
import org.eclipse.gef4.mvc.fx.policies.IFXOnRotatePolicy;
import org.eclipse.gef4.mvc.fx.tools.ITargetPolicyResolver;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.tools.AbstractTool;
import org.eclipse.gef4.mvc.tools.ITool;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXRotateTool
extends AbstractTool<Node> {
    public static final Class<IFXOnRotatePolicy> ON_ROTATE_POLICY_KEY = IFXOnRotatePolicy.class;
    @Inject
    private ITargetPolicyResolver targetPolicyResolver;
    private final Map<Scene, AbstractRotateGesture> gestures = new HashMap<Scene, AbstractRotateGesture>();
    private final Map<IViewer<Node>, ChangeListener<Boolean>> viewerFocusChangeListeners = new HashMap<IViewer<Node>, ChangeListener<Boolean>>();

    public List<? extends IFXOnRotatePolicy> getActivePolicies(IViewer<Node> viewer) {
        return super.getActivePolicies(viewer);
    }

    protected void registerListeners() {
        super.registerListeners();
        for (final IViewer viewer : this.getDomain().getViewers().values()) {
            ChangeListener<Boolean> viewerFocusChangeListener = new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue == null || !newValue.booleanValue()) {
                        for (IFXOnRotatePolicy iFXOnRotatePolicy : FXRotateTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                            iFXOnRotatePolicy.rotationAborted();
                        }
                        FXRotateTool.this.clearActivePolicies(viewer);
                        FXRotateTool.this.getDomain().closeExecutionTransaction((ITool)FXRotateTool.this);
                    }
                }
            };
            viewer.viewerFocusedProperty().addListener((ChangeListener)viewerFocusChangeListener);
            this.viewerFocusChangeListeners.put((IViewer<Node>)viewer, viewerFocusChangeListener);
            Scene scene = ((FXViewer)viewer).getScene();
            if (this.gestures.containsKey(scene)) continue;
            AbstractRotateGesture gesture = new AbstractRotateGesture(){

                protected void rotate(RotateEvent event) {
                    for (IFXOnRotatePolicy iFXOnRotatePolicy : FXRotateTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnRotatePolicy.rotate(event);
                    }
                }

                protected void rotationFinished(RotateEvent event) {
                    for (IFXOnRotatePolicy iFXOnRotatePolicy : FXRotateTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnRotatePolicy.rotationFinished(event);
                    }
                    FXRotateTool.this.clearActivePolicies(viewer);
                    FXRotateTool.this.getDomain().closeExecutionTransaction((ITool)FXRotateTool.this);
                }

                protected void rotationStarted(RotateEvent event) {
                    EventTarget eventTarget = event.getTarget();
                    FXRotateTool.this.setActivePolicies(viewer, FXRotateTool.this.targetPolicyResolver.getTargetPolicies((ITool<Node>)FXRotateTool.this, eventTarget instanceof Node ? (Node)eventTarget : null, ON_ROTATE_POLICY_KEY));
                    FXRotateTool.this.getDomain().openExecutionTransaction((ITool)FXRotateTool.this);
                    for (IFXOnRotatePolicy iFXOnRotatePolicy : FXRotateTool.this.getActivePolicies((IViewer<Node>)viewer)) {
                        iFXOnRotatePolicy.rotationStarted(event);
                    }
                }
            };
            gesture.setScene(scene);
            this.gestures.put(scene, gesture);
        }
    }

    protected void unregisterListeners() {
        for (IViewer<Node> viewer : this.viewerFocusChangeListeners.keySet()) {
            viewer.viewerFocusedProperty().removeListener(this.viewerFocusChangeListeners.remove(viewer));
        }
        for (Scene scene : this.gestures.keySet()) {
            this.gestures.remove(scene).setScene(null);
        }
        super.unregisterListeners();
    }
}

