/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.policies;

import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.StaticAnchor;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.fx.utils.NodeUtils;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.convert.fx.Geometry2FX;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.fx.operations.FXBendConnectionOperation;
import org.eclipse.gef4.mvc.fx.parts.FXPartUtils;
import org.eclipse.gef4.mvc.models.GridModel;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.DeselectOperation;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.SelectOperation;
import org.eclipse.gef4.mvc.parts.IBendableContentPart;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.policies.AbstractBendPolicy;
import org.eclipse.gef4.mvc.policies.AbstractTransformPolicy;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class FXBendConnectionPolicy
extends AbstractBendPolicy<Node> {
    protected static final double DEFAULT_OVERLAY_THRESHOLD = 10.0;
    private List<AnchorHandle> explicitAnchors = new ArrayList<AnchorHandle>();
    private List<AnchorHandle> selectedAnchors = new ArrayList<AnchorHandle>();
    private List<PointOverlay> pointOverlays = new ArrayList<PointOverlay>();
    private List<SegmentOverlay> segmentOverlays = new ArrayList<SegmentOverlay>();

    static Object getAnchorageContent(IViewer<Node> viewer, IAnchor anchor) {
        Node anchorageNode = anchor.getAnchorage();
        IVisualPart<Node, ? extends Node> part = FXPartUtils.retrieveVisualPart(viewer, anchorageNode);
        if (part instanceof IContentPart) {
            return ((IContentPart)part).getContent();
        }
        return null;
    }

    static List<IBendableContentPart.BendPoint> getCurrentBendPoints(IVisualPart<Node, ? extends Connection> connectionPart) {
        ArrayList<IBendableContentPart.BendPoint> bendPoints = new ArrayList<IBendableContentPart.BendPoint>();
        Connection connection = (Connection)connectionPart.getVisual();
        List anchors = connection.getAnchors();
        int i = 0;
        while (i < anchors.size()) {
            IAnchor a = (IAnchor)anchors.get(i);
            if (!connection.getRouter().isImplicitAnchor(a)) {
                if (connection.isConnected(i)) {
                    bendPoints.add(new IBendableContentPart.BendPoint(FXBendConnectionPolicy.getAnchorageContent((IViewer<Node>)connectionPart.getRoot().getViewer(), a)));
                } else {
                    bendPoints.add(new IBendableContentPart.BendPoint(connection.getPoint(i)));
                }
            }
            ++i;
        }
        return bendPoints;
    }

    protected boolean canConnect(int explicitAnchorIndex) {
        return explicitAnchorIndex == 0 || explicitAnchorIndex == this.explicitAnchors.size() - 1;
    }

    public ITransactionalOperation commit() {
        this.normalize();
        ITransactionalOperation commit = super.commit();
        if (commit == null || commit.isNoOp()) {
            return null;
        }
        ForwardUndoCompositeOperation updateOperation = new ForwardUndoCompositeOperation(commit.getLabel());
        updateOperation.add((IUndoableOperation)commit);
        ReverseUndoCompositeOperation reselectOperation = this.createReselectOperation();
        if (reselectOperation != null) {
            updateOperation.add((IUndoableOperation)reselectOperation);
        }
        return updateOperation;
    }

    public AnchorHandle createAfter(AnchorHandle explicitAnchorHandle, Point mouseInScene) {
        this.checkInitialized();
        int insertionIndex = explicitAnchorHandle.explicitAnchorIndex + 1;
        this.insertExplicitAnchor(insertionIndex, mouseInScene);
        return this.explicitAnchors.get(insertionIndex);
    }

    public AnchorHandle createBefore(AnchorHandle explicitAnchorHandle, Point mouseInScene) {
        this.checkInitialized();
        int insertionIndex = explicitAnchorHandle.explicitAnchorIndex;
        this.insertExplicitAnchor(insertionIndex, mouseInScene);
        return this.explicitAnchors.get(insertionIndex);
    }

    protected ITransactionalOperation createOperation() {
        return new FXBendConnectionOperation(this.getConnection());
    }

    protected ReverseUndoCompositeOperation createReselectOperation() {
        if (!(this.getHost() instanceof IContentPart) || !((SelectionModel)this.getHost().getRoot().getViewer().getAdapter((TypeToken)new TypeToken<SelectionModel<Node>>(){})).isSelected((IContentPart)this.getHost())) {
            return null;
        }
        ReverseUndoCompositeOperation reselectOperation = new ReverseUndoCompositeOperation("re-select");
        IViewer viewer = this.getHost().getRoot().getViewer();
        DeselectOperation deselectOperation = new DeselectOperation(viewer, Collections.singletonList((IContentPart)this.getHost()));
        SelectOperation selectOperation = new SelectOperation(viewer, Collections.singletonList((IContentPart)this.getHost()));
        reselectOperation.add((IUndoableOperation)deselectOperation);
        reselectOperation.add((IUndoableOperation)selectOperation);
        return reselectOperation;
    }

    protected IAnchor createUnconnectedAnchor(Point selectedPointCurrentPositionInLocal) {
        return new StaticAnchor((Node)this.getConnection(), selectedPointCurrentPositionInLocal);
    }

    protected AnchorHandle findExplicitAnchor(int startConnectionIndex, int step) {
        List anchors = this.getConnection().getAnchors();
        IConnectionRouter router = this.getConnection().getRouter();
        int i = startConnectionIndex;
        while (i >= 0 && i < anchors.size()) {
            IAnchor anchor = (IAnchor)anchors.get(i);
            if (!router.isImplicitAnchor(anchor)) {
                int j = 0;
                while (j < this.explicitAnchors.size()) {
                    if (this.explicitAnchors.get(j).getConnectionIndex() == i) {
                        return this.explicitAnchors.get(j);
                    }
                    ++j;
                }
                throw new IllegalStateException("The explicit anchors of the connection are out of sync with the explicit anchors of the policy.");
            }
            i += step;
        }
        throw new IllegalStateException("The start and end anchor of a Connection need to be explicit.");
    }

    public AnchorHandle findExplicitAnchorBackward(int connectionIndex) {
        return this.findExplicitAnchor(connectionIndex, -1);
    }

    public AnchorHandle findExplicitAnchorForward(int connectionIndex) {
        return this.findExplicitAnchor(connectionIndex, 1);
    }

    protected IAnchor findOrCreateAnchor(Point positionInLocal, boolean canConnect) {
        IAnchor anchor = null;
        if (canConnect) {
            Point selectedPointCurrentPositionInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)positionInLocal)));
            List pickedNodes = NodeUtils.getNodesAt((Node)((Node)this.getHost().getRoot().getVisual()), (double)selectedPointCurrentPositionInScene.x, (double)selectedPointCurrentPositionInScene.y);
            IContentPart<Node, ? extends Node> anchorPart = this.getAnchorPart(this.getParts(pickedNodes));
            if (anchorPart != null) {
                anchor = (IAnchor)((Provider)anchorPart.getAdapter((TypeToken)new TypeToken<Provider<? extends IAnchor>>(){})).get();
            }
        }
        if (anchor == null) {
            anchor = this.createUnconnectedAnchor(positionInLocal);
        }
        return anchor;
    }

    private IContentPart<Node, ? extends Node> getAnchorPart(List<IContentPart<Node, ? extends Node>> partsUnderMouse) {
        for (IContentPart<Node, ? extends Node> cp : partsUnderMouse) {
            IContentPart<Node, ? extends Node> part = cp;
            Provider anchorProvider = (Provider)part.getAdapter((TypeToken)new TypeToken<Provider<? extends IAnchor>>(){});
            if (anchorProvider == null || anchorProvider.get() == null) continue;
            return part;
        }
        return null;
    }

    protected FXBendConnectionOperation getBendOperation() {
        return (FXBendConnectionOperation)super.getOperation();
    }

    protected Connection getConnection() {
        return (Connection)this.getHost().getVisual();
    }

    protected List<IBendableContentPart.BendPoint> getCurrentBendPoints() {
        return FXBendConnectionPolicy.getCurrentBendPoints(this.getHost());
    }

    public IVisualPart<Node, Connection> getHost() {
        return super.getHost();
    }

    protected Point getMouseDeltaInLocal(Point initialMousePositionInScene, Point currentMousePositionInScene) {
        Point mouseInLocal = FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)currentMousePositionInScene)));
        Point deltaInLocal = mouseInLocal.getTranslated(FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)initialMousePositionInScene))).getNegated());
        return deltaInLocal;
    }

    protected double getOverlayThreshold() {
        GridModel model = (GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class);
        if (model != null && model.isSnapToGrid()) {
            return Math.min(model.getGridCellWidth(), model.getGridCellHeight()) / 4.0;
        }
        return 10.0;
    }

    private List<IContentPart<Node, ? extends Node>> getParts(List<Node> nodesUnderMouse) {
        ArrayList<IContentPart<Node, ? extends Node>> parts = new ArrayList<IContentPart<Node, ? extends Node>>();
        IViewer viewer = this.getHost().getRoot().getViewer();
        for (Node node : nodesUnderMouse) {
            IVisualPart<Node, ? extends Node> part = FXPartUtils.retrieveVisualPart((IViewer<Node>)viewer, node);
            if (!(part instanceof IContentPart)) continue;
            parts.add((IContentPart<Node, ? extends Node>)((IContentPart)part));
        }
        return parts;
    }

    private SegmentOverlay getSegmentOverlayLeft() {
        int i;
        double distance;
        int connectionIndex = this.selectedAnchors.get(0).getConnectionIndex();
        if (connectionIndex < 2) {
            return null;
        }
        AnchorHandle constrainedSelectedHandle = this.selectedAnchors.get(1);
        IAnchor constrainedSelectedOldAnchor = constrainedSelectedHandle.getAnchor();
        AnchorHandle removedSelectedHandle = this.selectedAnchors.get(0);
        IAnchor removedSelectedOldAnchor = removedSelectedHandle.getAnchor();
        int removedNeighborIndex = removedSelectedHandle.getConnectionIndex() - 1;
        IAnchor removedNeighborOldAnchor = this.getConnection().getAnchor(removedNeighborIndex);
        boolean removedNeighborWasExplicit = this.isExplicit(removedNeighborIndex);
        AnchorHandle removedNeighborHandle = this.makeExplicit(removedNeighborIndex);
        int retainedNeighborIndex = removedNeighborIndex - 1;
        IAnchor retainedNeighborOldAnchor = this.getConnection().getAnchor(retainedNeighborIndex);
        boolean retainedNeighborWasExplicit = this.isExplicit(retainedNeighborIndex);
        AnchorHandle retainedNeighborHandle = this.makeExplicit(retainedNeighborIndex);
        IAnchor retainedNeighborNewAnchor = retainedNeighborHandle.getAnchor();
        Point removedNeighborPosition = removedNeighborHandle.getPosition();
        Point constrainedSelectedPosition = constrainedSelectedHandle.getPosition();
        boolean isSelectedSameY = this.isSelectionOnHorizontalLine();
        double y0 = removedNeighborPosition.y;
        double y1 = retainedNeighborHandle.getPosition().y;
        boolean isNeighborsSameY = this.isUnpreciseEquals(y0, y1);
        Point newConstrainedPosition = new Point(isNeighborsSameY ? constrainedSelectedPosition.x : removedNeighborPosition.x, isNeighborsSameY ? removedNeighborPosition.y : constrainedSelectedPosition.y);
        IAnchor constrainedSelectedNewAnchor = this.createUnconnectedAnchor(newConstrainedPosition);
        SegmentOverlay segmentOverlay = new SegmentOverlay(true, retainedNeighborHandle, retainedNeighborOldAnchor, retainedNeighborNewAnchor, removedNeighborHandle, removedNeighborOldAnchor, removedSelectedHandle, removedSelectedOldAnchor, constrainedSelectedHandle, constrainedSelectedOldAnchor, constrainedSelectedNewAnchor);
        double d = distance = isSelectedSameY ? Math.abs(removedNeighborHandle.getPosition().y - removedSelectedHandle.getPosition().y) : Math.abs(removedNeighborHandle.getPosition().x - removedSelectedHandle.getPosition().x);
        if (isSelectedSameY == isNeighborsSameY && distance < 10.0) {
            return segmentOverlay;
        }
        if (!removedNeighborWasExplicit) {
            this.getBendOperation().getNewAnchors().remove(removedNeighborHandle.explicitAnchorIndex);
            this.explicitAnchors.remove(removedNeighborHandle.explicitAnchorIndex);
            this.locallyExecuteOperation();
            i = 0;
            while (i < this.explicitAnchors.size()) {
                this.explicitAnchors.get(i).explicitAnchorIndex = i;
                ++i;
            }
        }
        if (!retainedNeighborWasExplicit) {
            this.getBendOperation().getNewAnchors().remove(retainedNeighborHandle.explicitAnchorIndex);
            this.explicitAnchors.remove(retainedNeighborHandle.explicitAnchorIndex);
            this.locallyExecuteOperation();
            i = 0;
            while (i < this.explicitAnchors.size()) {
                this.explicitAnchors.get(i).explicitAnchorIndex = i;
                ++i;
            }
        }
        return null;
    }

    private SegmentOverlay getSegmentOverlayRight() {
        int i;
        double distance;
        int connectionIndex = this.selectedAnchors.get(1).getConnectionIndex();
        if (connectionIndex + 2 >= this.getConnection().getPoints().size()) {
            return null;
        }
        int retainedNeighborIndex = connectionIndex + 2;
        IAnchor retainedNeighborOldAnchor = this.getConnection().getAnchor(retainedNeighborIndex);
        boolean retainedNeighborWasExplicit = this.isExplicit(retainedNeighborIndex);
        AnchorHandle retainedNeighborHandle = this.makeExplicit(retainedNeighborIndex, retainedNeighborIndex).get(0);
        IAnchor retainedNeighborNewAnchor = retainedNeighborHandle.getAnchor();
        int removedNeighborIndex = retainedNeighborIndex - 1;
        IAnchor removedNeighborOldAnchor = this.getConnection().getAnchor(removedNeighborIndex);
        boolean removedNeighborWasExplicit = this.isExplicit(removedNeighborIndex);
        AnchorHandle removedNeighborHandle = this.makeExplicit(removedNeighborIndex, removedNeighborIndex).get(0);
        AnchorHandle removedSelectedHandle = this.selectedAnchors.get(1);
        IAnchor removedSelectedOldAnchor = removedSelectedHandle.getAnchor();
        AnchorHandle constrainedSelectedHandle = this.selectedAnchors.get(0);
        IAnchor constrainedSelectedOldAnchor = constrainedSelectedHandle.getAnchor();
        Point removedNeighborPosition = removedNeighborHandle.getPosition();
        Point constrainedSelectedPosition = constrainedSelectedHandle.getPosition();
        boolean isSelectedSameY = this.isSelectionOnHorizontalLine();
        double y0 = removedNeighborPosition.y;
        double y1 = retainedNeighborHandle.getPosition().y;
        boolean isNeighborsSameY = this.isUnpreciseEquals(y0, y1);
        Point newConstrainedPosition = new Point(isNeighborsSameY ? constrainedSelectedPosition.x : removedNeighborPosition.x, isNeighborsSameY ? removedNeighborPosition.y : constrainedSelectedPosition.y);
        IAnchor constrainedSelectedNewAnchor = this.createUnconnectedAnchor(newConstrainedPosition);
        SegmentOverlay segmentOverlay = new SegmentOverlay(false, retainedNeighborHandle, retainedNeighborOldAnchor, retainedNeighborNewAnchor, removedNeighborHandle, removedNeighborOldAnchor, removedSelectedHandle, removedSelectedOldAnchor, constrainedSelectedHandle, constrainedSelectedOldAnchor, constrainedSelectedNewAnchor);
        double d = distance = isSelectedSameY ? Math.abs(removedNeighborHandle.getPosition().y - removedSelectedHandle.getPosition().y) : Math.abs(removedNeighborHandle.getPosition().x - removedSelectedHandle.getPosition().x);
        if (isSelectedSameY == isNeighborsSameY && distance < 10.0) {
            return segmentOverlay;
        }
        if (!retainedNeighborWasExplicit) {
            this.getBendOperation().getNewAnchors().remove(retainedNeighborHandle.explicitAnchorIndex);
            this.explicitAnchors.remove(retainedNeighborHandle.explicitAnchorIndex);
            this.locallyExecuteOperation();
            i = 0;
            while (i < this.explicitAnchors.size()) {
                this.explicitAnchors.get(i).explicitAnchorIndex = i;
                ++i;
            }
        }
        if (!removedNeighborWasExplicit) {
            this.getBendOperation().getNewAnchors().remove(removedNeighborHandle.explicitAnchorIndex);
            this.explicitAnchors.remove(removedNeighborHandle.explicitAnchorIndex);
            this.locallyExecuteOperation();
            i = 0;
            while (i < this.explicitAnchors.size()) {
                this.explicitAnchors.get(i).explicitAnchorIndex = i;
                ++i;
            }
        }
        return null;
    }

    public void init() {
        this.selectedAnchors.clear();
        this.explicitAnchors.clear();
        this.pointOverlays.clear();
        this.segmentOverlays.clear();
        int explicitAnchorIndex = 0;
        int i = 0;
        while (i < this.getConnection().getAnchors().size()) {
            IAnchor anchor = this.getConnection().getAnchor(i);
            if (!this.getConnection().getRouter().isImplicitAnchor(anchor)) {
                this.explicitAnchors.add(new AnchorHandle(explicitAnchorIndex++));
            }
            ++i;
        }
        super.init();
    }

    protected void insertExplicitAnchor(int insertionIndex, Point mouseInScene) {
        Point mouseInLocal = FX2Geometry.toPoint((Point2D)this.getConnection().sceneToLocal(Geometry2FX.toFXPoint((Point)mouseInScene)));
        this.getBendOperation().getNewAnchors().add(insertionIndex, this.createUnconnectedAnchor(mouseInLocal));
        this.locallyExecuteOperation();
        AnchorHandle newAnchorHandle = new AnchorHandle(insertionIndex);
        this.explicitAnchors.add(insertionIndex, newAnchorHandle);
        int i = 0;
        while (i < this.explicitAnchors.size()) {
            this.explicitAnchors.get(i).explicitAnchorIndex = i;
            ++i;
        }
    }

    public boolean isExplicit(int connectionIndex) {
        IAnchor anchor = this.getConnection().getAnchor(connectionIndex);
        return !this.getConnection().getRouter().isImplicitAnchor(anchor);
    }

    private boolean isExplicitOverlay(int overlayingExplicitAnchorIndex, int overlainExplicitAnchorIndex) {
        AnchorHandle overlaying = this.explicitAnchors.get(overlayingExplicitAnchorIndex);
        AnchorHandle overlain = this.explicitAnchors.get(overlainExplicitAnchorIndex);
        return overlaying.getPosition().getDistance(overlain.getPosition()) <= 10.0;
    }

    public boolean isSelectionOnHorizontalLine() {
        double y0 = this.selectedAnchors.get((int)0).getInitialPosition().y;
        double y1 = this.selectedAnchors.get((int)1).getInitialPosition().y;
        boolean isHorizontallyConstrained = this.isUnpreciseEquals(y0, y1);
        return isHorizontallyConstrained;
    }

    private boolean isUnpreciseEquals(double y0, double y1) {
        return Math.abs(y0 - y1) < 1.0;
    }

    public AnchorHandle makeExplicit(int connectionIndex) {
        return this.makeExplicit(connectionIndex, connectionIndex).get(0);
    }

    public List<AnchorHandle> makeExplicit(int startConnectionIndex, int endConnectionIndex) {
        ArrayList<ImplicitGroup> implicitGroups = new ArrayList<ImplicitGroup>();
        boolean isStartExplicit = this.isExplicit(startConnectionIndex);
        implicitGroups.add(new ImplicitGroup(this.findExplicitAnchorBackward(startConnectionIndex)));
        int i = startConnectionIndex;
        while (i <= endConnectionIndex) {
            if (this.isExplicit(i)) {
                AnchorHandle explicitAnchorHandle = this.findExplicitAnchorBackward(i);
                implicitGroups.add(new ImplicitGroup(explicitAnchorHandle));
            } else {
                Point pointInLocal = this.getConnection().getPoint(i);
                Point pointInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)pointInLocal)));
                ((ImplicitGroup)implicitGroups.get((int)(implicitGroups.size() - 1))).points.add(pointInScene);
            }
            ++i;
        }
        if (((ImplicitGroup)implicitGroups.get((int)0)).points.isEmpty()) {
            implicitGroups.remove(0);
        }
        ArrayList<AnchorHandle> handles = new ArrayList<AnchorHandle>();
        for (ImplicitGroup ig : implicitGroups) {
            AnchorHandle prec = ig.precedingHandle;
            if (!handles.isEmpty() || isStartExplicit) {
                handles.add(prec);
            }
            for (Point p : ig.points) {
                prec = this.createAfter(prec, p);
                handles.add(prec);
            }
        }
        return handles;
    }

    public void move(Point initialMouseInScene, Point currentMouseInScene) {
        this.checkInitialized();
        this.restoreRemoved();
        int numPoints = this.selectedAnchors.size();
        boolean isSegmentBased = numPoints > 1 && this.getConnection().getRouter() instanceof OrthogonalRouter;
        Point mouseDeltaInLocal = this.getMouseDeltaInLocal(initialMouseInScene, currentMouseInScene);
        if (isSegmentBased) {
            if (this.isSelectionOnHorizontalLine()) {
                mouseDeltaInLocal.x = 0.0;
            } else {
                mouseDeltaInLocal.y = 0.0;
            }
        }
        int i = 0;
        while (i < this.selectedAnchors.size()) {
            Point selectedPointCurrentPositionInLocal = this.selectedAnchors.get(i).getInitialPosition().getTranslated(mouseDeltaInLocal);
            Dimension snapToGridOffset = AbstractTransformPolicy.getSnapToGridOffset((GridModel)((GridModel)this.getHost().getRoot().getViewer().getAdapter(GridModel.class)), (double)selectedPointCurrentPositionInLocal.x, (double)selectedPointCurrentPositionInLocal.y, (double)0.5, (double)0.5);
            selectedPointCurrentPositionInLocal.translate(snapToGridOffset.getNegated());
            int explicitAnchorIndex = this.selectedAnchors.get(i).explicitAnchorIndex;
            boolean canConnect = this.canConnect(explicitAnchorIndex);
            this.getBendOperation().getNewAnchors().set(explicitAnchorIndex, this.findOrCreateAnchor(selectedPointCurrentPositionInLocal, canConnect));
            ++i;
        }
        this.locallyExecuteOperation();
        this.removeOverlain();
    }

    public void normalize() {
        if (!(this.getConnection().getRouter() instanceof OrthogonalRouter)) {
            return;
        }
        this.locallyExecuteOperation();
        List anchors = this.getConnection().getAnchors();
        List positions = this.getConnection().getPoints();
        int explicitIndex = 0;
        boolean removed = false;
        int i = 1;
        while (i < anchors.size() - 1) {
            IAnchor anchor = (IAnchor)anchors.get(i);
            if (!this.getConnection().getRouter().isImplicitAnchor(anchor)) {
                AnchorHandle explicitHandle = this.explicitAnchors.get(++explicitIndex);
                Point prev = (Point)positions.get(i - 1);
                Point next = (Point)positions.get(i + 1);
                Point current = (Point)positions.get(i);
                Vector inDirection = new Vector(prev, current);
                Vector outDirection = new Vector(current, next);
                if (inDirection.isNull() || outDirection.isNull() || inDirection.isParallelTo(outDirection)) {
                    Point prevInScene = FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(prev.x, prev.y));
                    if (this.getConnection().getRouter().isImplicitAnchor((IAnchor)anchors.get(i + 1))) {
                        this.makeExplicit(i + 1);
                    }
                    if (this.getConnection().getRouter().isImplicitAnchor((IAnchor)anchors.get(i - 1))) {
                        this.createBefore(explicitHandle, prevInScene);
                        ++explicitIndex;
                    }
                    this.explicitAnchors.remove(explicitIndex);
                    this.getBendOperation().getNewAnchors().remove(explicitIndex);
                    int j = 0;
                    while (j < this.explicitAnchors.size()) {
                        this.explicitAnchors.get(j).explicitAnchorIndex = j;
                        ++j;
                    }
                    removed = true;
                    break;
                }
            }
            ++i;
        }
        if (removed) {
            this.normalize();
        }
    }

    private void removeOverlain() {
        if (this.getConnection().getRouter() instanceof OrthogonalRouter && this.selectedAnchors.size() == 2) {
            this.removeOverlainSegments();
            if (!this.segmentOverlays.isEmpty()) {
                return;
            }
        }
        this.removeOverlainPoints();
    }

    private void removeOverlainPoints() {
        int i = 0;
        while (i < this.selectedAnchors.size()) {
            int overlainIndex;
            AnchorHandle explicitNeighborHandle;
            boolean isRightOverlain;
            AnchorHandle handle = this.selectedAnchors.get(i);
            int index = handle.explicitAnchorIndex;
            boolean isLeftOverlain = index > 0 && this.isExplicitOverlay(index, index - 1);
            boolean bl = isRightOverlain = index < this.explicitAnchors.size() - 1 && this.isExplicitOverlay(index, index + 1);
            if ((isLeftOverlain || isRightOverlain) && !this.selectedAnchors.contains(explicitNeighborHandle = this.explicitAnchors.get(overlainIndex = isLeftOverlain ? index - 1 : index + 1))) {
                this.explicitAnchors.remove(index);
                int connectionIndex = handle.getConnectionIndex();
                IAnchor toBeRemovedAnchor = this.getConnection().getAnchor(connectionIndex);
                this.getBendOperation().getNewAnchors().remove(index);
                int j = index;
                while (j < this.explicitAnchors.size()) {
                    AnchorHandle anchorHandle = this.explicitAnchors.get(j);
                    anchorHandle.explicitAnchorIndex = anchorHandle.explicitAnchorIndex - 1;
                    ++j;
                }
                PointOverlay pointOverlay = new PointOverlay(toBeRemovedAnchor, explicitNeighborHandle, !isLeftOverlain, handle);
                this.pointOverlays.add(pointOverlay);
                this.locallyExecuteOperation();
            }
            ++i;
        }
    }

    private void removeOverlainSegments() {
        SegmentOverlay segmentOverlay = this.getSegmentOverlayLeft();
        if (segmentOverlay != null) {
            this.segmentOverlays.add(segmentOverlay);
            this.getBendOperation().getNewAnchors().set(segmentOverlay.constrainedSelectedHandle.explicitAnchorIndex, segmentOverlay.constrainedSelectedNewAnchor);
            int index = segmentOverlay.removedSelectedHandle.explicitAnchorIndex;
            this.getBendOperation().getNewAnchors().remove(index);
            this.explicitAnchors.remove(index);
            index = segmentOverlay.removedNeighborHandle.explicitAnchorIndex;
            this.getBendOperation().getNewAnchors().remove(index);
            this.explicitAnchors.remove(index);
            index = segmentOverlay.retainedNeighborHandle.explicitAnchorIndex;
            this.getBendOperation().getNewAnchors().set(index, segmentOverlay.retainedNeighborNewAnchor);
            int j = 0;
            while (j < this.explicitAnchors.size()) {
                this.explicitAnchors.get(j).explicitAnchorIndex = j;
                ++j;
            }
        } else {
            segmentOverlay = this.getSegmentOverlayRight();
            if (segmentOverlay != null) {
                this.segmentOverlays.add(segmentOverlay);
                int index = segmentOverlay.retainedNeighborHandle.explicitAnchorIndex;
                this.getBendOperation().getNewAnchors().set(index, segmentOverlay.retainedNeighborNewAnchor);
                index = segmentOverlay.removedNeighborHandle.explicitAnchorIndex;
                this.getBendOperation().getNewAnchors().remove(index);
                this.explicitAnchors.remove(index);
                index = segmentOverlay.removedSelectedHandle.explicitAnchorIndex;
                this.getBendOperation().getNewAnchors().remove(index);
                this.explicitAnchors.remove(index);
                this.getBendOperation().getNewAnchors().set(segmentOverlay.constrainedSelectedHandle.explicitAnchorIndex, segmentOverlay.constrainedSelectedNewAnchor);
                int j = 0;
                while (j < this.explicitAnchors.size()) {
                    this.explicitAnchors.get(j).explicitAnchorIndex = j;
                    ++j;
                }
            }
        }
        if (!this.segmentOverlays.isEmpty()) {
            this.locallyExecuteOperation();
        }
    }

    private void restoreRemoved() {
        while (!this.segmentOverlays.isEmpty()) {
            int i;
            SegmentOverlay segmentOverlay = this.segmentOverlays.remove(0);
            if (segmentOverlay.isNeighborsFirst) {
                this.getBendOperation().getNewAnchors().set(segmentOverlay.constrainedSelectedHandle.explicitAnchorIndex, segmentOverlay.constrainedSelectedOldAnchor);
                this.getBendOperation().getNewAnchors().add(segmentOverlay.constrainedSelectedHandle.explicitAnchorIndex, segmentOverlay.removedSelectedOldAnchor);
                this.explicitAnchors.add(segmentOverlay.constrainedSelectedHandle.explicitAnchorIndex, segmentOverlay.removedSelectedHandle);
                if (!this.getConnection().getRouter().isImplicitAnchor(segmentOverlay.removedNeighborOldAnchor)) {
                    this.getBendOperation().getNewAnchors().add(segmentOverlay.retainedNeighborHandle.explicitAnchorIndex + 1, segmentOverlay.removedNeighborOldAnchor);
                    this.explicitAnchors.add(segmentOverlay.retainedNeighborHandle.explicitAnchorIndex + 1, segmentOverlay.removedNeighborHandle);
                }
                this.getBendOperation().getNewAnchors().set(segmentOverlay.retainedNeighborHandle.explicitAnchorIndex, segmentOverlay.retainedNeighborOldAnchor);
                i = 0;
                while (i < this.explicitAnchors.size()) {
                    this.explicitAnchors.get(i).explicitAnchorIndex = i;
                    ++i;
                }
                this.locallyExecuteOperation();
                continue;
            }
            this.getBendOperation().getNewAnchors().set(segmentOverlay.retainedNeighborHandle.explicitAnchorIndex, segmentOverlay.retainedNeighborOldAnchor);
            if (this.getConnection().getRouter().isImplicitAnchor(segmentOverlay.removedNeighborOldAnchor)) {
                this.getBendOperation().getNewAnchors().remove(segmentOverlay.retainedNeighborHandle.explicitAnchorIndex);
                this.explicitAnchors.remove(segmentOverlay.retainedNeighborHandle.explicitAnchorIndex);
            }
            if (!this.getConnection().getRouter().isImplicitAnchor(segmentOverlay.removedNeighborOldAnchor)) {
                this.getBendOperation().getNewAnchors().add(segmentOverlay.retainedNeighborHandle.explicitAnchorIndex, segmentOverlay.removedNeighborOldAnchor);
                this.explicitAnchors.add(segmentOverlay.retainedNeighborHandle.explicitAnchorIndex, segmentOverlay.removedNeighborHandle);
            }
            this.getBendOperation().getNewAnchors().add(segmentOverlay.constrainedSelectedHandle.explicitAnchorIndex + 1, segmentOverlay.removedSelectedOldAnchor);
            this.explicitAnchors.add(segmentOverlay.constrainedSelectedHandle.explicitAnchorIndex + 1, segmentOverlay.removedSelectedHandle);
            this.getBendOperation().getNewAnchors().set(segmentOverlay.constrainedSelectedHandle.explicitAnchorIndex, segmentOverlay.constrainedSelectedOldAnchor);
            i = 0;
            while (i < this.explicitAnchors.size()) {
                this.explicitAnchors.get(i).explicitAnchorIndex = i;
                ++i;
            }
            this.locallyExecuteOperation();
        }
        while (!this.pointOverlays.isEmpty()) {
            PointOverlay pointOverlay = this.pointOverlays.remove(0);
            AnchorHandle replacementHandle = pointOverlay.replacement;
            int insertionIndex = pointOverlay.wasBefore ? replacementHandle.explicitAnchorIndex : replacementHandle.explicitAnchorIndex + 1;
            this.getBendOperation().getNewAnchors().add(insertionIndex, pointOverlay.removed);
            this.locallyExecuteOperation();
            this.explicitAnchors.add(insertionIndex, pointOverlay.selected);
            int i = insertionIndex;
            while (i < this.explicitAnchors.size()) {
                this.explicitAnchors.get(i).explicitAnchorIndex = i;
                ++i;
            }
        }
    }

    public void select(AnchorHandle explicitAnchorHandle) {
        this.checkInitialized();
        this.selectedAnchors.add(explicitAnchorHandle);
    }

    public void selectSegment(int segmentIndex) {
        int firstSegmentIndex = segmentIndex;
        int secondSegmentIndex = segmentIndex + 1;
        Node firstAnchorage = this.getConnection().getAnchor(firstSegmentIndex).getAnchorage();
        boolean isFirstConnected = firstAnchorage != null && firstAnchorage != this.getConnection();
        Node secondAnchorage = this.getConnection().getAnchor(secondSegmentIndex).getAnchorage();
        boolean isSecondConnected = secondAnchorage != null && secondAnchorage != this.getConnection();
        List<AnchorHandle> explicit = this.makeExplicit(firstSegmentIndex, secondSegmentIndex);
        AnchorHandle firstAnchorHandle = explicit.get(0);
        AnchorHandle secondAnchorHandle = explicit.get(1);
        if (isFirstConnected) {
            firstAnchorHandle = this.createAfter(firstAnchorHandle, FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)firstAnchorHandle.getInitialPosition()))));
        }
        if (isSecondConnected) {
            secondAnchorHandle = this.createBefore(secondAnchorHandle, FX2Geometry.toPoint((Point2D)this.getConnection().localToScene(Geometry2FX.toFXPoint((Point)secondAnchorHandle.getInitialPosition()))));
        }
        this.select(firstAnchorHandle);
        this.select(secondAnchorHandle);
    }

    public String toString() {
        return "FXBendConnectionPolicy[host=" + this.getHost() + "]";
    }

    public class AnchorHandle {
        private Point initialPosition = null;
        private int explicitAnchorIndex = 0;

        public AnchorHandle(int explicitAnchorIndex) {
            this.explicitAnchorIndex = explicitAnchorIndex;
            this.initialPosition = this.getPosition();
        }

        public IAnchor getAnchor() {
            return FXBendConnectionPolicy.this.getConnection().getAnchor(this.getConnectionIndex());
        }

        public int getConnectionIndex() {
            int explicitCount = -1;
            int i = 0;
            while (i < FXBendConnectionPolicy.this.getConnection().getPoints().size()) {
                IAnchor a = FXBendConnectionPolicy.this.getConnection().getAnchor(i);
                if (!FXBendConnectionPolicy.this.getConnection().getRouter().isImplicitAnchor(a)) {
                    ++explicitCount;
                }
                if (explicitCount == this.explicitAnchorIndex) {
                    return i;
                }
                ++i;
            }
            throw new IllegalArgumentException("Cannot determine connection index for operation index " + this.explicitAnchorIndex + ".");
        }

        public Point getInitialPosition() {
            return this.initialPosition;
        }

        public int getOperationIndex() {
            return this.explicitAnchorIndex;
        }

        public Point getPosition() {
            return FXBendConnectionPolicy.this.getConnection().getPoint(this.getConnectionIndex());
        }

        public boolean isConnected() {
            return this.getAnchor().getAnchorage() != null && this.getAnchor().getAnchorage() != FXBendConnectionPolicy.this.getConnection();
        }
    }

    private static class ImplicitGroup {
        AnchorHandle precedingHandle;
        List<Point> points = new ArrayList<Point>();

        public ImplicitGroup(AnchorHandle preceding) {
            this.precedingHandle = preceding;
        }
    }

    public class PointOverlay {
        private AnchorHandle replacement;
        private IAnchor removed;
        private boolean wasBefore;
        private AnchorHandle selected;

        public PointOverlay(IAnchor removed, AnchorHandle replacement, boolean wasBefore, AnchorHandle selectedHandle) {
            this.removed = removed;
            this.replacement = replacement;
            this.wasBefore = wasBefore;
            this.selected = selectedHandle;
        }
    }

    public class SegmentOverlay {
        private boolean isNeighborsFirst;
        private AnchorHandle retainedNeighborHandle;
        private IAnchor retainedNeighborOldAnchor;
        private IAnchor retainedNeighborNewAnchor;
        private AnchorHandle removedNeighborHandle;
        private IAnchor removedNeighborOldAnchor;
        private AnchorHandle removedSelectedHandle;
        private IAnchor removedSelectedOldAnchor;
        private AnchorHandle constrainedSelectedHandle;
        private IAnchor constrainedSelectedOldAnchor;
        private IAnchor constrainedSelectedNewAnchor;

        public SegmentOverlay(boolean isNeighborsFirst, AnchorHandle retainedNeighborHandle, IAnchor retainedNeighborOldAnchor, IAnchor retainedNeighborNewAnchor, AnchorHandle removedNeighborHandle, IAnchor removedNeighborOldAnchor, AnchorHandle removedSelectedHandle, IAnchor removedSelectedOldAnchor, AnchorHandle constrainedSelectedHandle, IAnchor constrainedSelectedOldAnchor, IAnchor constrainedSelectedNewAnchor) {
            this.isNeighborsFirst = isNeighborsFirst;
            this.retainedNeighborHandle = retainedNeighborHandle;
            this.retainedNeighborOldAnchor = retainedNeighborOldAnchor;
            this.retainedNeighborNewAnchor = retainedNeighborNewAnchor;
            this.removedNeighborHandle = removedNeighborHandle;
            this.removedNeighborOldAnchor = removedNeighborOldAnchor;
            this.removedSelectedHandle = removedSelectedHandle;
            this.removedSelectedOldAnchor = removedSelectedOldAnchor;
            this.constrainedSelectedHandle = constrainedSelectedHandle;
            this.constrainedSelectedOldAnchor = constrainedSelectedOldAnchor;
            this.constrainedSelectedNewAnchor = constrainedSelectedNewAnchor;
        }
    }
}

