/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.fx.listeners.VisualChangeListener;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.mvc.parts.AbstractHandlePart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public abstract class AbstractFXHandlePart<V extends Node>
extends AbstractHandlePart<Node, V> {
    private final Map<IVisualPart<Node, ? extends Node>, VisualChangeListener> visualChangeListeners = new HashMap<IVisualPart<Node, ? extends Node>, VisualChangeListener>();
    private final Map<IVisualPart<Node, ? extends Node>, Integer> anchorageLinkCount = new HashMap<IVisualPart<Node, ? extends Node>, Integer>();
    private final Map<IVisualPart<Node, ? extends Node>, ChangeListener<ICurve>> geometryChangeListeners = new HashMap<IVisualPart<Node, ? extends Node>, ChangeListener<ICurve>>();

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        int count;
        int n = count = this.anchorageLinkCount.get(anchorage) == null ? 0 : this.anchorageLinkCount.get(anchorage);
        if (count == 0) {
            VisualChangeListener listener = new VisualChangeListener(){

                protected void boundsInLocalChanged(Bounds oldBounds, Bounds newBounds) {
                    AbstractFXHandlePart.this.refreshVisual();
                }

                protected void localToParentTransformChanged(Node observed, Transform oldTransform, Transform newTransform) {
                    AbstractFXHandlePart.this.refreshVisual();
                }
            };
            this.visualChangeListeners.put(anchorage, listener);
            listener.register((Node)anchorage.getVisual(), (Node)this.getVisual());
            Node anchorageVisual = (Node)anchorage.getVisual();
            if (anchorageVisual instanceof Connection) {
                Connection connection = (Connection)anchorageVisual;
                ChangeListener<ICurve> geometryListener = new ChangeListener<ICurve>(){

                    public void changed(ObservableValue<? extends ICurve> observable, ICurve oldValue, ICurve newValue) {
                        AbstractFXHandlePart.this.refreshVisual();
                    }
                };
                connection.getCurveNode().geometryProperty().addListener((ChangeListener)geometryListener);
                this.geometryChangeListeners.put(anchorage, geometryListener);
            }
        }
        this.anchorageLinkCount.put(anchorage, count + 1);
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        int count = this.anchorageLinkCount.get(anchorage);
        if (count == 1) {
            this.visualChangeListeners.remove(anchorage).unregister();
            ChangeListener<ICurve> geometryListener = this.geometryChangeListeners.remove(anchorage);
            if (geometryListener != null) {
                ((Connection)anchorage.getVisual()).getCurveNode().geometryProperty().removeListener(geometryListener);
            }
        }
        if (count > 0) {
            this.anchorageLinkCount.put(anchorage, count - 1);
        } else {
            this.anchorageLinkCount.remove(anchorage);
        }
    }
}

