/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.parts;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.transform.Transform;
import org.eclipse.gef4.fx.listeners.VisualChangeListener;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.mvc.parts.AbstractFeedbackPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public abstract class AbstractFXFeedbackPart<V extends Node>
extends AbstractFeedbackPart<Node, V> {
    private final VisualChangeListener visualListener = new VisualChangeListener(){

        protected void boundsInLocalChanged(Bounds oldBounds, Bounds newBounds) {
            AbstractFXFeedbackPart.this.refreshVisual();
        }

        protected void localToParentTransformChanged(Node observed, Transform oldTransform, Transform newTransform) {
            AbstractFXFeedbackPart.this.refreshVisual();
        }
    };
    private ChangeListener<ICurve> geometryListener = new ChangeListener<ICurve>(){

        public void changed(ObservableValue<? extends ICurve> observable, ICurve oldValue, ICurve newValue) {
            AbstractFXFeedbackPart.this.refreshVisual();
        }
    };

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        Node anchorageVisual = (Node)anchorage.getVisual();
        this.visualListener.register(anchorageVisual, (Node)this.getVisual());
        if (anchorageVisual instanceof Connection) {
            Connection connection = (Connection)anchorageVisual;
            connection.getCurveNode().geometryProperty().addListener(this.geometryListener);
        }
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        Node anchorageVisual = (Node)anchorage.getVisual();
        if (anchorageVisual instanceof Connection) {
            Connection connection = (Connection)anchorageVisual;
            connection.getCurveNode().geometryProperty().removeListener(this.geometryListener);
        }
        this.visualListener.unregister();
    }
}

